/*
 * Decompiled with CFR 0.152.
 */
package com.billy.android.loading;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class Gloading {
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_LOAD_SUCCESS = 2;
    public static final int STATUS_LOAD_FAILED = 3;
    public static final int STATUS_EMPTY_DATA = 4;
    private static volatile Gloading mDefault;
    private Adapter mAdapter;
    private static boolean DEBUG;

    public static void debug(boolean debug) {
        DEBUG = debug;
    }

    private Gloading() {
    }

    public static Gloading from(Adapter adapter) {
        Gloading gloading = new Gloading();
        gloading.mAdapter = adapter;
        return gloading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Gloading getDefault() {
        if (mDefault != null) return mDefault;
        Class<Gloading> clazz = Gloading.class;
        synchronized (Gloading.class) {
            if (mDefault != null) return mDefault;
            mDefault = new Gloading();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mDefault;
        }
    }

    public static void initDefault(Adapter adapter) {
        Gloading.getDefault().mAdapter = adapter;
    }

    public Holder wrap(Activity activity) {
        ViewGroup wrapper = (ViewGroup)activity.findViewById(0x1020002);
        return new Holder(this.mAdapter, (Context)activity, wrapper);
    }

    public Holder wrap(View view) {
        FrameLayout wrapper = new FrameLayout(view.getContext());
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp != null) {
            wrapper.setLayoutParams(lp);
        }
        if (view.getParent() != null) {
            ViewGroup parent = (ViewGroup)view.getParent();
            int index = parent.indexOfChild(view);
            parent.removeView(view);
            parent.addView((View)wrapper, index);
        }
        FrameLayout.LayoutParams newLp = new FrameLayout.LayoutParams(-1, -1);
        wrapper.addView(view, (ViewGroup.LayoutParams)newLp);
        return new Holder(this.mAdapter, view.getContext(), (ViewGroup)wrapper);
    }

    private static void printLog(String msg) {
        if (DEBUG) {
            Log.e((String)"Gloading", (String)msg);
        }
    }

    static {
        DEBUG = false;
    }

    public static class Holder {
        private Adapter mAdapter;
        private Context mContext;
        private Runnable mRetryTask;
        private View mCurStatusView;
        private ViewGroup mWrapper;
        private int curState;
        private SparseArray<View> mStatusViews = new SparseArray(4);
        private Object mData;

        private Holder(Adapter adapter, Context context, ViewGroup wrapper) {
            this.mAdapter = adapter;
            this.mContext = context;
            this.mWrapper = wrapper;
        }

        public Holder withRetry(Runnable task) {
            this.mRetryTask = task;
            return this;
        }

        public Holder withData(Object data) {
            this.mData = data;
            return this;
        }

        public void showLoading() {
            this.showLoadingStatus(1);
        }

        public void showLoadSuccess() {
            this.showLoadingStatus(2);
        }

        public void showLoadFailed() {
            this.showLoadingStatus(3);
        }

        public void showEmpty() {
            this.showLoadingStatus(4);
        }

        public void showLoadingStatus(int status) {
            block11: {
                if (this.curState == status || !this.validate()) {
                    return;
                }
                this.curState = status;
                View convertView = (View)this.mStatusViews.get(status);
                if (convertView == null) {
                    convertView = this.mCurStatusView;
                }
                try {
                    View view = this.mAdapter.getView(this, convertView, status);
                    if (view == null) {
                        Gloading.printLog(this.mAdapter.getClass().getName() + ".getView returns null");
                        return;
                    }
                    if (view != this.mCurStatusView || this.mWrapper.indexOfChild(view) < 0) {
                        if (this.mCurStatusView != null) {
                            this.mWrapper.removeView(this.mCurStatusView);
                        }
                        if (Build.VERSION.SDK_INT >= 21) {
                            view.setElevation(Float.MAX_VALUE);
                        }
                        this.mWrapper.addView(view);
                        ViewGroup.LayoutParams lp = view.getLayoutParams();
                        if (lp != null) {
                            lp.width = -1;
                            lp.height = -1;
                        }
                    } else if (this.mWrapper.indexOfChild(view) != this.mWrapper.getChildCount() - 1) {
                        view.bringToFront();
                    }
                    this.mCurStatusView = view;
                    this.mStatusViews.put(status, (Object)view);
                }
                catch (Exception e) {
                    if (!DEBUG) break block11;
                    e.printStackTrace();
                }
            }
        }

        private boolean validate() {
            if (this.mAdapter == null) {
                Gloading.printLog("Gloading.Adapter is not specified.");
            }
            if (this.mContext == null) {
                Gloading.printLog("Context is null.");
            }
            if (this.mWrapper == null) {
                Gloading.printLog("The mWrapper of loading status view is null.");
            }
            return this.mAdapter != null && this.mContext != null && this.mWrapper != null;
        }

        public Context getContext() {
            return this.mContext;
        }

        public ViewGroup getWrapper() {
            return this.mWrapper;
        }

        public Runnable getRetryTask() {
            return this.mRetryTask;
        }

        public <T> T getData() {
            try {
                return (T)this.mData;
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }
    }

    public static interface Adapter {
        public View getView(Holder var1, View var2, int var3);
    }
}

