/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.debug.log;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.bihe0832.android.common.debug.item.DebugItemData;
import com.bihe0832.android.common.debug.item.DebugItemToolsKt;
import com.bihe0832.android.common.debug.log.SectionDataContent;
import com.bihe0832.android.common.debug.log.SectionDataHeader;
import com.bihe0832.android.common.list.CardItemForCommonList;
import com.bihe0832.android.common.list.CommonListLiveData;
import com.bihe0832.android.common.list.swiperefresh.CommonListActivity;
import com.bihe0832.android.common.webview.core.WebViewLoggerFile;
import com.bihe0832.android.framework.R;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.framework.log.LoggerFile;
import com.bihe0832.android.framework.router.RouterHelperWrapperKt;
import com.bihe0832.android.framework.router.RouterInterrupt;
import com.bihe0832.android.lib.adapter.CardBaseModule;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.select.FileSelectTools;
import com.bihe0832.android.lib.router.annotation.Module;
import com.bihe0832.android.lib.theme.ThemeResourcesManager;
import com.bihe0832.android.lib.ui.recycleview.ext.SafeGridLayoutManager;
import com.bihe0832.android.lib.utils.ConvertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010\u001f\u001a\u00020 H\u0014J\"\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/bihe0832/android/common/debug/log/DebugLogListActivity;", "Lcom/bihe0832/android/common/list/swiperefresh/CommonListActivity;", "()V", "isView", "", "mDataList", "Ljava/util/ArrayList;", "Lcom/bihe0832/android/lib/adapter/CardBaseModule;", "Lkotlin/collections/ArrayList;", "getMDataList", "()Ljava/util/ArrayList;", "showTitle", "getCardList", "", "Lcom/bihe0832/android/common/list/CardItemForCommonList;", "getCommonLogList", "getDataLiveData", "Lcom/bihe0832/android/common/list/CommonListLiveData;", "getItemList", "getLayoutManagerForList", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "getLogPathItem", "Lcom/bihe0832/android/common/debug/item/DebugItemData;", "path", "", "getNavigationBarColor", "", "getOpenLogItem", "getSendLogItem", "getTempData", "getTitleText", "initView", "", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "parseBundle", "bundle", "Landroid/os/Bundle;", "showAction", "CommonDebug_release"})
@Module(value="loglist")
public class DebugLogListActivity
extends CommonListActivity {
    @NotNull
    private final ArrayList<CardBaseModule> mDataList = new ArrayList();
    private boolean isView = true;
    private boolean showTitle;

    @NotNull
    public final ArrayList<CardBaseModule> getMDataList() {
        return this.mDataList;
    }

    protected void parseBundle(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        super.parseBundle(bundle);
        this.showTitle = ConvertUtils.parseBoolean((String)bundle.getString("showAction", ""), (boolean)this.showTitle);
    }

    public boolean showAction() {
        return false;
    }

    @NotNull
    public RecyclerView.LayoutManager getLayoutManagerForList() {
        return (RecyclerView.LayoutManager)new SafeGridLayoutManager((Context)this, 3);
    }

    public int getNavigationBarColor() {
        Integer n = ThemeResourcesManager.INSTANCE.getColor(R.color.transparent);
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    @Nullable
    public List<CardItemForCommonList> getCardList() {
        List list;
        List $this$getCardList_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        $this$getCardList_u24lambda_u240.add(new CardItemForCommonList(SectionDataHeader.class, true));
        $this$getCardList_u24lambda_u240.add(new CardItemForCommonList(SectionDataContent.class));
        $this$getCardList_u24lambda_u240.add(new CardItemForCommonList(DebugItemData.class, true));
        return list;
    }

    @NotNull
    protected List<CardBaseModule> getCommonLogList() {
        List list;
        List $this$getCommonLogList_u24lambda_u241 = list = (List)new ArrayList();
        boolean bl = false;
        $this$getCommonLogList_u24lambda_u241.add(new SectionDataHeader("\u901a\u7528\u65e5\u5fd7\u5de5\u5177"));
        $this$getCommonLogList_u24lambda_u241.add(this.getLogPathItem(LoggerFile.INSTANCE.getZixieFileLogPathByModule("*")));
        $this$getCommonLogList_u24lambda_u241.add(this.getSendLogItem(ZixieContext.INSTANCE.getLogFolder()));
        $this$getCommonLogList_u24lambda_u241.add(this.getOpenLogItem(ZixieContext.INSTANCE.getLogFolder()));
        return list;
    }

    @NotNull
    protected List<CardBaseModule> getItemList() {
        List list;
        List $this$getItemList_u24lambda_u242 = list = (List)new ArrayList();
        boolean bl = false;
        $this$getItemList_u24lambda_u242.add(new SectionDataHeader("\u57fa\u7840\u901a\u7528\u65e5\u5fd7"));
        $this$getItemList_u24lambda_u242.add(new SectionDataContent("\u8def\u7531\u8df3\u8f6c", RouterInterrupt.INSTANCE.getRouterLogPath(), this.showAction(), true, false));
        $this$getItemList_u24lambda_u242.add(new SectionDataContent("Webview", WebViewLoggerFile.INSTANCE.getWebviewLogPath(), this.showAction(), false, true));
        return list;
    }

    @NotNull
    protected final DebugItemData getLogPathItem(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebugItemToolsKt.getLittleDebugItem("\u65e5\u5fd7\u8def\u5f84\uff1a<BR><small>" + path + "</small>", null, false, null);
    }

    @NotNull
    protected final DebugItemData getSendLogItem(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebugItemToolsKt.getDebugItem("\u9009\u62e9\u5e76\u53d1\u9001\u65e5\u5fd7", arg_0 -> DebugLogListActivity.getSendLogItem$lambda$3(this, path, arg_0));
    }

    @NotNull
    protected final CardBaseModule getOpenLogItem(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return DebugItemToolsKt.getDebugItem("\u9009\u62e9\u5e76\u67e5\u770b\u65e5\u5fd7", arg_0 -> DebugLogListActivity.getOpenLogItem$lambda$4(this, path, arg_0));
    }

    @NotNull
    public CommonListLiveData getDataLiveData() {
        return new CommonListLiveData(this){
            final /* synthetic */ DebugLogListActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void initData() {
                this.this$0.getMDataList().addAll((Collection<CardBaseModule>)this.this$0.getTempData());
                this.postValue(this.this$0.getMDataList());
            }

            public void refresh() {
            }

            public void loadMore() {
            }

            public boolean hasMore() {
                return false;
            }

            public boolean canRefresh() {
                return false;
            }
        };
    }

    @NotNull
    public List<CardBaseModule> getTempData() {
        List list;
        List $this$getTempData_u24lambda_u245 = list = (List)new ArrayList();
        boolean bl = false;
        if (this.showTitle) {
            $this$getTempData_u24lambda_u245.addAll((Collection)this.getCommonLogList());
        }
        $this$getTempData_u24lambda_u245.addAll((Collection)this.getItemList());
        return list;
    }

    @NotNull
    public String getTitleText() {
        return "\u65e5\u5fd7\u529f\u80fd\u6c47\u603b";
    }

    protected void initView() {
        super.initView();
        this.updateIcon(R.drawable.ic_left_arrow, true);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        block0: {
            Object filePath;
            block1: {
                if (requestCode != 1 || resultCode != -1) break block0;
                Object object = data;
                if (object == null || (object = object.getExtras()) == null || (object = object.getString("url", "")) == null) break block0;
                filePath = object;
                boolean bl = false;
                if (!this.isView) break block1;
                RouterHelperWrapperKt.showLog((String)filePath, (boolean)false, (boolean)true, (int)2000);
                break block0;
            }
            boolean it = FileUtils.INSTANCE.sendFile((Context)this, (String)filePath);
            boolean bl = false;
            if (it) break block0;
            ZixieContext.INSTANCE.showToast("\u5206\u4eab\u6587\u4ef6:" + (String)filePath + " \u5931\u8d25");
        }
    }

    private static final void getSendLogItem$lambda$3(DebugLogListActivity this$0, String $path, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        this$0.isView = false;
        FileSelectTools.openFileSelect((Activity)((Activity)this$0), (String)$path);
    }

    private static final void getOpenLogItem$lambda$4(DebugLogListActivity this$0, String $path, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        this$0.isView = true;
        FileSelectTools.openFileSelect((Activity)((Activity)this$0), (String)$path);
    }
}

