/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.debug;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.fragment.app.Fragment;
import com.bihe0832.android.common.debug.module.DebugRootActivity;
import com.bihe0832.android.lib.debug.DebugTools;
import com.bihe0832.android.lib.ui.dialog.callback.DialogCompletedStringCallback;
import com.bihe0832.android.lib.ui.dialog.tools.DialogUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0002J \u0010\f\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bJ \u0010\u0010\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bJ&\u0010\u0010\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J&\u0010\u0012\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J0\u0010\u0013\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u001a2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001b\u001a\u00020\u001cJ8\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\"\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001b\u001a\u00020\u001cJ8\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\u001c\u0010 \u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bJ2\u0010 \u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ\u0018\u0010 \u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u000bJ$\u0010!\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0014\u001a\u00020\u000b\u00a8\u0006\""}, d2={"Lcom/bihe0832/android/common/debug/DebugUtils;", "", "()V", "getIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "cls", "Ljava/lang/Class;", "data", "", "", "sendInfo", "", "title", "content", "showInfo", "", "showInfoWithHTML", "showInputDialog", "titleName", "msg", "defaultValue", "listener", "Lcom/bihe0832/android/lib/ui/dialog/callback/DialogCompletedStringCallback;", "startActivityForResultWithException", "Landroid/app/Activity;", "requestCode", "", "activity", "fragment", "Landroidx/fragment/app/Fragment;", "startActivityWithException", "startDebugActivity", "CommonDebug_release"})
public final class DebugUtils {
    @NotNull
    public static final DebugUtils INSTANCE = new DebugUtils();

    private DebugUtils() {
    }

    public final void sendInfo(@Nullable Context context, @NotNull String title, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        DebugTools.sendInfo((Context)context, (String)title, (String)content, (boolean)false);
    }

    public final void showInfo(@Nullable Context context, @NotNull String title, @NotNull List<String> content) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        StringBuilder $this$showInfo_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = content;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$showInfo_u24lambda_u241.append(it + '\n');
        }
        StringBuilder it = stringBuilder;
        boolean bl3 = false;
        DebugTools.showInfo((Context)context, (String)title, (String)it.toString(), (String)"\u53d1\u9001\u5230\u7b2c\u4e09\u65b9");
    }

    public final void showInfoWithHTML(@Nullable Context context, @NotNull String title, @NotNull List<String> content) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        StringBuilder $this$showInfoWithHTML_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = content;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$showInfoWithHTML_u24lambda_u244.append(it + "<BR>");
        }
        StringBuilder it = stringBuilder;
        boolean bl3 = false;
        DebugTools.showInfoWithHTML((Context)context, (String)title, (String)it.toString(), (String)"\u53d1\u9001\u5230\u7b2c\u4e09\u65b9");
    }

    public final void showInfo(@Nullable Context context, @NotNull String title, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        DebugTools.showInfo((Context)context, (String)title, (String)content, (String)"\u53d1\u9001\u5230\u7b2c\u4e09\u65b9");
    }

    public final void showInputDialog(@Nullable Context context, @NotNull String titleName, @NotNull String msg, @NotNull String defaultValue, @NotNull DialogCompletedStringCallback listener) {
        Intrinsics.checkNotNullParameter((Object)titleName, (String)"titleName");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        DialogUtils.INSTANCE.showInputDialog(context2, titleName, msg, defaultValue, listener);
    }

    public final void startDebugActivity(@Nullable Context context, @NotNull Class<?> cls, @NotNull String titleName) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)titleName, (String)"titleName");
        DebugRootActivity.startDebugRootActivity(context, cls, titleName);
    }

    public final void startActivityWithException(@Nullable Context context, @NotNull String cls) {
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        Class<?> clazz = Class.forName(cls);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(cls)");
        this.startActivityWithException(context, clazz);
    }

    public final void startActivityWithException(@Nullable Context context, @NotNull Class<?> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        this.startActivityWithException(context, cls, null);
    }

    public final void startActivityWithException(@Nullable Context context, @NotNull Class<?> cls, @Nullable Map<String, String> data) {
        block2: {
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            Intent intent = new Intent(context, cls);
            intent.addFlags(0x10000000);
            Map<String, String> map = data;
            if (map != null) {
                Map<String, String> it = map;
                boolean bl = false;
                for (Map.Entry<String, String> entry : it.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    intent.putExtra(key, value);
                }
            }
            Context context2 = context;
            if (context2 == null) break block2;
            context2.startActivity(intent);
        }
    }

    public final void startActivityForResultWithException(@NotNull Activity context, @NotNull Class<?> cls, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        this.startActivityForResultWithException(context, cls, requestCode, null);
    }

    public final void startActivityForResultWithException(@NotNull Fragment fragment, @NotNull Class<?> cls, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        this.startActivityForResultWithException(fragment, cls, requestCode, null);
    }

    private final Intent getIntent(Context context, Class<?> cls, Map<String, String> data) {
        Intent intent;
        block1: {
            intent = new Intent(context, cls);
            Map<String, String> map = data;
            if (map == null) break block1;
            Map<String, String> it = map;
            boolean bl = false;
            for (Map.Entry<String, String> entry : it.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                intent.putExtra(key, value);
            }
        }
        return intent;
    }

    public final void startActivityForResultWithException(@NotNull Activity activity, @NotNull Class<?> cls, int requestCode, @Nullable Map<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intent intent = this.getIntent((Context)activity, cls, data);
        activity.startActivityForResult(intent, requestCode);
    }

    public final void startActivityForResultWithException(@NotNull Fragment fragment, @NotNull Class<?> cls, int requestCode, @Nullable Map<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Context context = fragment.getContext();
        Intrinsics.checkNotNull((Object)context);
        Intent intent = this.getIntent(context, cls, data);
        fragment.startActivityForResult(intent, requestCode);
    }
}

