/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.socket;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.socket.SocketConnection;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.generic.MessageConnectionServer;

public class SocketConnectionServer
implements MessageConnectionServer {
    private ServerSocket ss;
    private JMXServiceURL addr;
    private boolean wildcard;
    private Map env;
    private static final String DEFAULT_PROTOCOL = "jmxmp";
    private static final int DEFAULT_BACKLOG = 100;
    private final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SocketConnectionServer");

    public SocketConnectionServer(JMXServiceURL addr, Map env) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("constructor", "Constructs a SocketConnectionServer on " + addr);
        }
        if (addr == null) {
            throw new NullPointerException("Null address.");
        }
        if (!DEFAULT_PROTOCOL.equalsIgnoreCase(addr.getProtocol())) {
            throw new MalformedURLException("Unknown protocol: " + addr.getProtocol());
        }
        String wildcardS = null;
        if (env != null) {
            wildcardS = (String)env.get("jmx.remote.server.address.wildcard");
        }
        this.wildcard = wildcardS == null ? true : wildcardS.equalsIgnoreCase("true");
        this.addr = addr;
    }

    @Override
    public void start(Map env) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("start", "Starts the server now.");
        }
        HashMap newEnv = new HashMap();
        if (this.env != null) {
            newEnv.putAll(this.env);
        }
        if (env != null) {
            newEnv.putAll(env);
        }
        int port = this.addr.getPort();
        String host = this.addr.getHost();
        if (host.equals("")) {
            host = InetAddress.getLocalHost().getHostName();
        }
        if (this.wildcard) {
            this.ss = new ServerSocket(0, 100, InetAddress.getByName(host));
            this.ss.close();
        }
        Object o = null;
        try {
            Constructor<?> ct;
            Class<?> c = Class.forName("java.net.InetSocketAddress");
            if (this.wildcard) {
                ct = c.getDeclaredConstructor(Integer.TYPE);
                o = ct.newInstance(new Integer(port));
            } else {
                ct = c.getDeclaredConstructor(String.class, Integer.TYPE);
                o = ct.newInstance(host, new Integer(port));
            }
        }
        catch (Exception ee) {
            // empty catch block
        }
        if (o != null && DefaultConfig.getServerReuseAddress(newEnv)) {
            try {
                Class<ServerSocket> cc = ServerSocket.class;
                Method m1 = cc.getMethod("setReuseAddress", Boolean.TYPE);
                Method m2 = cc.getMethod("bind", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                this.ss = (ServerSocket)cc.newInstance();
                m1.invoke((Object)this.ss, Boolean.TRUE);
                m2.invoke((Object)this.ss, o, new Integer(100));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)e).getTargetException();
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Exception) {
                        e = (Exception)t;
                    }
                }
                IOException ioe = new IOException(e.toString());
                EnvHelp.initCause(ioe, e);
                throw ioe;
            }
        } else {
            this.ss = this.wildcard ? new ServerSocket(port, 100) : new ServerSocket(port, 100, InetAddress.getByName(host));
        }
        this.addr = new JMXServiceURL(DEFAULT_PROTOCOL, host, this.ss.getLocalPort());
        this.env = newEnv;
    }

    @Override
    public MessageConnection accept() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("accept", "Waiting a new connection...");
        }
        SocketConnection mc = new SocketConnection(this.ss.accept());
        return mc;
    }

    @Override
    public void stop() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("stop", "Stops the server now.");
        }
        if (this.ss != null) {
            this.ss.close();
        }
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.addr;
    }
}

