/*
 * Decompiled with CFR 0.152.
 */
package com.benasher44.uuid;

import com.benasher44.uuid.PlatformKt;
import com.benasher44.uuid.Uuid;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0015\u0010\u001c\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0001H\u0080\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00038\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\b\"\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u00038\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0006\u001a\u0004\b\u000f\u0010\b\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"UUID_BYTES", "", "UUID_CHARS", "", "", "UUID_CHARS$annotations", "()V", "getUUID_CHARS", "()Ljava/util/List;", "UUID_CHAR_RANGES", "Lkotlin/ranges/IntRange;", "UUID_CHAR_RANGES$annotations", "getUUID_CHAR_RANGES", "UUID_HYPHEN_INDICES", "UUID_HYPHEN_INDICES$annotations", "getUUID_HYPHEN_INDICES", "UUID_STRING_LENGTH", "halfByteFromChar", "char", "(C)Ljava/lang/Integer;", "uuid4", "Lcom/benasher44/uuid/Uuid;", "uuidFrom", "string", "", "uuidOf", "bytes", "", "setVersion", "version", "uuid"})
@JvmName(name="UuidUtil")
public final class UuidUtil {
    public static final int UUID_BYTES = 16;
    public static final int UUID_STRING_LENGTH = 36;
    @NotNull
    private static final List<IntRange> UUID_CHAR_RANGES = CollectionsKt.listOf((Object[])new IntRange[]{RangesKt.until((int)0, (int)8), RangesKt.until((int)9, (int)13), RangesKt.until((int)14, (int)18), RangesKt.until((int)19, (int)23), RangesKt.until((int)24, (int)36)});
    @NotNull
    private static final List<Integer> UUID_HYPHEN_INDICES = CollectionsKt.listOf((Object[])new Integer[]{8, 13, 18, 23});
    @NotNull
    private static final List<Character> UUID_CHARS;

    public static /* synthetic */ void UUID_CHAR_RANGES$annotations() {
    }

    @NotNull
    public static final List<IntRange> getUUID_CHAR_RANGES() {
        return UUID_CHAR_RANGES;
    }

    public static /* synthetic */ void UUID_HYPHEN_INDICES$annotations() {
    }

    @NotNull
    public static final List<Integer> getUUID_HYPHEN_INDICES() {
        return UUID_HYPHEN_INDICES;
    }

    public static /* synthetic */ void UUID_CHARS$annotations() {
    }

    @NotNull
    public static final List<Character> getUUID_CHARS() {
        return UUID_CHARS;
    }

    @NotNull
    public static final byte[] setVersion(@NotNull byte[] $this$setVersion, int version) {
        int $i$f$setVersion = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$setVersion, (String)"$this$setVersion");
        byte[] byArray = $this$setVersion;
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        $this$apply[6] = (byte)($this$apply[6] & 0xF | version << 4);
        $this$apply[8] = (byte)($this$apply[8] & 0x3F | 0x80);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Uuid uuid4() {
        void var10_8;
        void $this$setVersion$iv;
        byte[] byArray = PlatformKt.getRandomUuidBytes();
        int version$iv = 4;
        boolean $i$f$setVersion = false;
        void var3_3 = $this$setVersion$iv;
        boolean bl = false;
        boolean bl2 = false;
        void $this$apply$iv = var3_3;
        boolean bl3 = false;
        $this$apply$iv[6] = (byte)($this$apply$iv[6] & 0xF | version$iv << 4);
        $this$apply$iv[8] = (byte)($this$apply$iv[8] & 0x3F | 0x80);
        void var11_9 = var10_8 = var3_3;
        return new Uuid((byte[])var11_9);
    }

    @NotNull
    public static final Uuid uuidOf(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return new Uuid(bytes);
    }

    private static final Integer halfByteFromChar(char c) {
        char c2 = c;
        char c3 = c2;
        return '0' <= c3 && '9' >= c3 ? Integer.valueOf(c - 48) : ('a' <= (c3 = c2) && 'f' >= c3 ? Integer.valueOf(c - 87) : ('A' <= (c3 = c2) && 'F' >= c3 ? Integer.valueOf(c - 55) : null));
    }

    @NotNull
    public static final Uuid uuidFrom(@NotNull String string) {
        boolean bl;
        boolean $i$f$all;
        boolean bl2;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            boolean bl3 = string.length() == 36;
            boolean bl4 = false;
            bl2 = false;
            if (!bl3) {
                boolean bl5 = false;
                String string2 = "Uuid string has invalid length: " + string;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            Iterable $this$all$iv = UUID_HYPHEN_INDICES;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl6 = false;
                    if (string.charAt(it) == '-') continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        boolean $this$all$iv = bl;
        $i$f$all = false;
        bl2 = false;
        if (!$this$all$iv) {
            boolean bl7 = false;
            String string3 = "Uuid string has invalid format: " + string;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        byte[] bytes = new byte[16];
        int n = 0;
        for (IntRange range : UUID_CHAR_RANGES) {
            int i = range.getFirst();
            while (i < range.getLast()) {
                Integer left = UuidUtil.halfByteFromChar(string.charAt(i++));
                Integer right = UuidUtil.halfByteFromChar(string.charAt(i++));
                boolean bl8 = left != null && right != null;
                boolean bl9 = false;
                boolean bl10 = false;
                if (!bl8) {
                    boolean bl11 = false;
                    String string4 = "Uuid string has invalid characters: " + string;
                    throw (Throwable)new IllegalArgumentException(string4.toString());
                }
                bytes[n++] = (byte)(left << 4 | right);
            }
        }
        return new Uuid(bytes);
    }

    static {
        char c = '0';
        CharRange charRange = new CharRange(c, '9');
        c = 'a';
        UUID_CHARS = CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)new CharRange(c, 'f')));
    }
}

