/**
 * Created by jiangyue on 17-11-22.   和原生交互的方法
 */
var sysPlatform;
var ua = navigator.userAgent.toLowerCase();
if (/iphone|ipad|ipod/.test(ua)) {
    sysPlatform = "IOS";
} else if (/android/.test(ua)) {
    sysPlatform = "ANDROID";
}

function connectWebViewJavascriptBridgeIOS (callback){
    if (window.WebViewJavascriptBridge) { return callback(WebViewJavascriptBridge); }
    if (window.WVJBCallbacks) { return window.WVJBCallbacks.push(callback); }
    window.WVJBCallbacks = [callback];
    var WVJBIframe = document.createElement('iframe');
    WVJBIframe.style.display = 'none';
    WVJBIframe.src = 'wvjbscheme://__BRIDGE_LOADED__';
    document.documentElement.appendChild(WVJBIframe);
    setTimeout(function() { document.documentElement.removeChild(WVJBIframe) }, 0);
}

function connectWebViewJavascriptBridgeANDROID(callback) {
    if (window.WebViewJavascriptBridge) {
        callback(WebViewJavascriptBridge)
    } else {
        document.addEventListener(
            'WebViewJavascriptBridgeReady', function() {
                callback(WebViewJavascriptBridge)
            },
            false
        );
    }
}

function initBridgetFunc(bridge) {
    window.ssqBridge = bridge;

    //通知html bridge已建立
    // if (window.bridgeConnected) {
    //     bridgeConnected();
    // }
    if(afterBridge && afterBridge.length>0){
        for(var i=0 ; i< afterBridge.length; i++){
            afterBridge[i].call();
        }
    }
}

if(sysPlatform == "IOS"){
    connectWebViewJavascriptBridgeIOS(function(bridge) {
        initBridgetFunc(bridge);
    });
}else if(sysPlatform == "ANDROID"){
    connectWebViewJavascriptBridgeANDROID(function(bridge) {
        initBridgetFunc(bridge);
//        bridge.init();
    });
}


var afterBridge = [];


var SSQCommon= {
    afterReady:  function(callback){
        if (window.ssqBridge) {
            callback();
        } else {
            afterBridge.push(callback);
        }
    },
    //h5 注册方法
    registerCallback: function(callback) {
        this.afterReady(function() {
            ssqBridge.registerHandler('useH5Function', function(data, responseCallback) {
                var dataObj=JSON.parse(data);
                callback(dataObj);
            });
        });
    },
    
    //设置页面标题
    setTitle: function(data) {
        this.afterReady(function() {
            var dataJSON = {
                function: '1068',
                data: data||{}
            };
            ssqBridge.callHandler('useNativeFunction',JSON.stringify(dataJSON), function(response){
            });
        });
    },
    
   
    //日期   传给原生  当前的日期 lastDate  返回  birthday
    setDate: function(data) {
        this.afterReady(function() {
            var dataJSON = {
                function: '1030',
                data: data||{}
            };
            ssqBridge.callHandler('useNativeFunction',JSON.stringify(dataJSON), function(response){
            });
        });
    },
    
    //原生提示框   data
    AppToast: function(text) {
        var data={
            msg:text
        }
        this.afterReady(function() {
            var dataJSON = {
                function: '1065',
                data: data||{}
            };
            ssqBridge.callHandler('useNativeFunction',JSON.stringify(dataJSON), function(response){
            });
        });
    },
    



};
document.addEventListener("DOMContentLoaded", function() {
    SSQCommon.setTitle({'title': document.title});
}, false);



