package com.ssqandroidweb;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.design.widget.BottomSheetDialog;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.github.lzyzsd.jsbridge.BridgeHandler;
import com.github.lzyzsd.jsbridge.BridgeWebView;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import com.github.lzyzsd.jsbridge.DefaultHandler;
import com.google.gson.Gson;
import com.ssqandroidweb.bean.ProcessBean;
import com.ssqandroidweb.bean.WZBean;
import com.ssqandroidweb.bean.WebInAppBean;
import com.ssqandroidweb.bean.WzBack;
import com.ssqandroidweb.constant.Constant;
import com.ssqandroidweb.provide.BestsignFileProvider;
import com.ssqandroidweb.utils.StringUtils;
import com.webank.faceaction.tools.WbCloudFaceVerifySdk;
import com.webank.faceaction.ui.FaceVerifyStatus;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class SsqWebActivity extends AppCompatActivity {

    private BridgeWebView mWebView;
    private static SsqWebFinishListener mSsqWebFinishListener;
    private TextView tv_left_ssq, tv_title_ssq, tv_toolbar_operator;
    protected String mUrl, mLicense;
    public static final String EXTRA_NAME_URL = "url";
    public static final String EXTRA_NAME_LICENSE = "license";
    int RESULT_CODE = 0;
    private ValueCallback<Uri> uploadMessage;
    private ValueCallback<Uri[]> uploadMessageAboveL;
    private ProgressBar progressBar;
    private String result = "failure";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ssq_webview);
        mUrl = getIntent().getStringExtra(EXTRA_NAME_URL);
        mLicense = getIntent().getStringExtra(EXTRA_NAME_LICENSE);
        tv_left_ssq = findViewById(R.id.tv_left_ssq);
        tv_title_ssq = findViewById(R.id.tv_title_ssq);
        tv_toolbar_operator = findViewById(R.id.tv_toolbar_operator);
        progressBar = findViewById(R.id.pb_progress);
        mWebView = findViewById(R.id.webview);
        mWebView.setDefaultHandler(new DefaultHandler());
//        mWebView.setWebViewClient(new MyWebViewClient());
        final WebSettings settings = mWebView.getSettings();
        settings.setCacheMode(WebSettings.LOAD_DEFAULT);//根据cache-control决定是否从网络上取数据。。

        settings.setDomStorageEnabled(true);

        settings.setAppCacheMaxSize(1024 * 1024 * 8);

        String appCachePath = getApplicationContext().getCacheDir().getAbsolutePath();

        settings.setAppCachePath(appCachePath);

        settings.setAllowFileAccess(true);

        settings.setAppCacheEnabled(true);

        mWebView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress < 100) {
                    progressBar.setVisibility(View.VISIBLE);
                } else {
                    progressBar.setVisibility(View.GONE);
                }
                progressBar.setProgress(newProgress);
            }

            @Override
            public void onReceivedTitle(WebView view, String title) {
                tv_title_ssq.setText(title);
            }

            // For Android < 3.0
            public void openFileChooser(ValueCallback<Uri> valueCallback) {
                uploadMessage = valueCallback;
                choseFlieType();
            }

            // For Android  >= 3.0
            public void openFileChooser(ValueCallback valueCallback, String acceptType) {
                uploadMessage = valueCallback;
                choseFlieType();
            }

            //For Android  >= 4.1
            public void openFileChooser(ValueCallback<Uri> valueCallback, String acceptType, String capture) {
                uploadMessage = valueCallback;
                choseFlieType();
            }

            // For Android >= 5.0
            @Override
            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
                uploadMessageAboveL = filePathCallback;
                choseFlieType();
                return true;
            }

            @Override
            public void onCloseWindow(WebView window) {
                super.onCloseWindow(window);
            }

            @Override
            //扩容
            public void onReachedMaxAppCacheSize(long requiredStorage, long quota, WebStorage.QuotaUpdater quotaUpdater) {
                quotaUpdater.updateQuota(requiredStorage * 2);
            }
        });
        mWebView.loadUrl(StringUtils.isNotBlank(mUrl) ? mUrl : "http://192.168.90.124:9000/signing/transition?token=6RFZje&contractId=2118752089671729157&type=sign");
        mWebView.registerHandler("useNativeFunction", new BridgeHandler() {
            public void handler(String data, CallBackFunction function) {
                try {
                    JSONObject jsonObject = new JSONObject(data);
                    String functionName = jsonObject.getString("functionName");
                    Gson gson = new Gson();
                    if (functionName.equals(Constant.START_WZ)) {
                        WZBean wzBean = gson.fromJson(data, WZBean.class);
                        WZBean.DataBean dataBean = wzBean.getData();
                        openCloudFaceService(FaceVerifyStatus.Mode.MIDDLE, dataBean.getSign(), dataBean.getUserId(), dataBean.getNonce(), dataBean.getOrderNo(), dataBean.getRealName(), dataBean.getIdCardNo());
                    } else if (functionName.equals(Constant.INITAPPSDK)) {
                        WebInAppBean webInAppBean = new WebInAppBean();
                        webInAppBean.setFunctionName(Constant.INITAPPSDK);
                        WebInAppBean.DataBean dataBean = new WebInAppBean.DataBean();
                        dataBean.setIsInAppSdk("1");
                        webInAppBean.setData(dataBean);
                        mWebView.callHandler("useH5Function", new Gson().toJson(webInAppBean), null);
                    } else if (functionName.equals(Constant.PROCESSRESULT)) {
                        ProcessBean processBean = gson.fromJson(data, ProcessBean.class);
                        ProcessBean.DataBean dataBean = processBean.getData();
                        if (mSsqWebFinishListener != null && dataBean != null) {
                            result = dataBean.getResult();
                            String close = dataBean.getClose();
                            if (close.equals("1")) {
                                if (result.equals("1")) {
                                    result = "success";
                                } else {
                                    result = "failure";
                                }
                                mSsqWebFinishListener.onSuccess(result);
                                finish();
                            } else {
                                if (result.equals("1")) {
                                    result = "success";
                                } else {
                                    result = "failure";
                                }
                            }
                           /* if (StringUtils.isNotBlank(result)) {
                                if (result.equals("1")) {
                                    mSsqWebFinishListener.onSuccess();
                                } else {
                                    mSsqWebFinishListener.onFailed();
                                }
                            }*/
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        initListener();
    }

    private void initListener() {
        tv_left_ssq.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                backIfPossible();
            }
        });
        tv_toolbar_operator.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (mSsqWebFinishListener != null) {
                    mSsqWebFinishListener.onSuccess(result);
                }
                finish();
            }
        });
    }

    private boolean isShowFail;
    private boolean isShowSuccess;
    private String color;
    private String srcPhotoType;
    private String srcPhotoString;
    private String compareType;

    private static final String TAG = "SsqWebActivity";

    public void openCloudFaceService(final FaceVerifyStatus.Mode mode, String sign, String userId, String nonce, String orderNo, String realName, String idCardNo) {
        if (StringUtils.isEmpty(sign)) {
            showToast("获取微众签名为空，请稍后重试");
            return;
        }
        color = WbCloudFaceVerifySdk.BLACK;
//        color = WbCloudFaceVerifySdk.WHITE;
        //默认展示成功/失败页面
        isShowSuccess = false;
        isShowFail = false;
        //默认公安网纹图片比对
        compareType = WbCloudFaceVerifySdk.ID_CARD;
        //只有自带比对源比对才需要设置
        srcPhotoString = null;
        srcPhotoType = null;
        Bundle data = new Bundle();
        WbCloudFaceVerifySdk.InputData inputData = new WbCloudFaceVerifySdk.InputData(
                realName,
                "01",
                idCardNo,
                orderNo,
                "ip=xxx.xxx.xxx.xxx",
                "lgt=xxx,xxx;lat=xxx.xxx",
                Constant.APPID,
                Constant.APPVERSION,
                nonce,
                userId,
                sign,
                false,
                mode,
                StringUtils.isEmpty(mLicense) ? Constant.LICENSE : mLicense);

        data.putSerializable(WbCloudFaceVerifySdk.INPUT_DATA, inputData);

        //个性化参数设置,可以不设置，不设置则为默认选项。
        //是否展示刷脸成功页面，默认展示
        data.putBoolean(WbCloudFaceVerifySdk.SHOW_SUCCESS_PAGE, isShowSuccess);
        //是否展示刷脸失败页面，默认展示
        data.putBoolean(WbCloudFaceVerifySdk.SHOW_FAIL_PAGE, isShowFail);
        //sdk样式设置，需要与资源包一起配合使用
        //默认黑色模式
        data.putString(WbCloudFaceVerifySdk.COLOR_MODE, color);
        //是否对录制视频进行检查,默认不检查
        data.putBoolean(WbCloudFaceVerifySdk.VIDEO_CHECK, false);
        //设置选择的比对类型  默认为公安网纹图片对比
        //公安网纹图片比对 WbCloudFaceVerifySdk.ID_CRAD
        //自带比对源比对  WbCloudFaceVerifySdk.SRC_IMG
        //仅活体检测  WbCloudFaceVerifySdk.NONE
        //默认公安网纹图片比对
        data.putString(WbCloudFaceVerifySdk.COMPARE_TYPE, compareType);
        //自带比对源设置
        //比对源图片需要合作方转换成base64 string传入sdk
        //上送自带的数据源信息，照片类型与照片string缺一不可
        // 不带比对源的可不传这两个字段
        //上送照片类型，1是水纹照  2是高清照
        data.putString(WbCloudFaceVerifySdk.SRC_PHOTO_TYPE, srcPhotoType);  //1是水纹照  2是高清照
        data.putString(WbCloudFaceVerifySdk.SRC_PHOTO_STRING, srcPhotoString);  //比对源照片的BASE64 string

        WbCloudFaceVerifySdk.getInstance().init(SsqWebActivity.this, data, new WbCloudFaceVerifySdk.FaceVerifyLoginListener() {
            @Override
            public void onLoginSuccess() {
                WbCloudFaceVerifySdk.getInstance().startActivityForSecurity(new WbCloudFaceVerifySdk.FaceVerifyResultForSecureListener() {
                    @Override
                    public void onFinish(int resultCode, boolean nextShowGuide, String faceCode, String faceMsg, String sign, Bundle extendData) {
                        String liveRate = null;
                        String similarity = null;
                        if (extendData != null) {
                            liveRate = extendData.getString(WbCloudFaceVerifySdk.FACE_RESULT_LIVE_RATE);
                            similarity = extendData.getString(WbCloudFaceVerifySdk.FACE_RESULT_SIMILIRATY);
                        }

                        if (resultCode == 0) {
                            WzBack wzBack = new WzBack();
                            wzBack.setFunctionName(Constant.START_WZ);
                            WzBack.DataBean dataBean = new WzBack.DataBean();
                            dataBean.setResult("1");
                            wzBack.setData(dataBean);
                            mWebView.callHandler("useH5Function", new Gson().toJson(wzBack), null);
                            Log.d(TAG, "刷脸成功！后台可以拉取到用户刷脸照片！errorCode=" + resultCode + " ;faceCode=" + faceCode + "; faceMsg=" + faceMsg
                                    + "; Sign=" + sign + "; liveRate=" + liveRate + "; similarity=" + similarity);
                            if (!isShowSuccess) {
                               /* if ("facesigngoto".equals(source)) {
                                    action.processFacePPFaceAuth(orderNo, documentId);
                                } else {
                                    action.processFacePPFaceAuth(orderNo, "");
                                }*/
                            }
                        } else {

                            Log.d(TAG, "刷脸失败！errorCode=" + resultCode + " ;faceCode=" + faceCode + "; faceMsg=" + faceMsg + "; Sign=" + sign);
                            if (resultCode == com.webank.faceaction.tools.ErrorCode.FACEVERIFY_ERROR_DEFAULT) {
                                Log.d(TAG, "后台对比失败! liveRate=" + liveRate + "; similarity=" + similarity);
                                if (StringUtils.isNotBlank(similarity)) {
                                    try {
                                        if (Double.parseDouble(similarity) < 71) {
//                                            showToast("刷脸不通过，请确保是本人操作");
                                        }
//                                        showGotoMobileAuthDialog();
                                    } catch (NumberFormatException e) {
//                                        showGotoMobileAuthDialog();
                                    }
                                }
                                if (faceCode.equals("66660004")) {
                                    Log.d(TAG, "但是后台可以拉取到用户刷脸照片!");
                                } else {
                                    Log.d(TAG, "后台不可以拉取到用户刷脸图片！");
                                }
                            } else {
                                Log.d(TAG, "前端失败！");
                                showToast("刷脸取消");
                            }
                            if (!isShowFail) {
//                                showToast("刷脸失败：errorCode=" + resultCode + " ;faceCode= " + faceCode + " ;faceMsg=" + faceMsg);
                            }
                            WzBack wzBack = new WzBack();
                            wzBack.setFunctionName(Constant.START_WZ);
                            WzBack.DataBean dataBean = new WzBack.DataBean();
                            dataBean.setResult("0");
                            wzBack.setData(dataBean);
                            mWebView.callHandler("useH5Function", new Gson().toJson(wzBack), null);
                        }
                    }
                });
            }

            @Override
            public void onLoginFailed(String errorCode, String errorMsg) {
                WzBack wzBack = new WzBack();
                wzBack.setFunctionName(Constant.START_WZ);
                WzBack.DataBean dataBean = new WzBack.DataBean();
                dataBean.setResult("0");
                wzBack.setData(dataBean);
                mWebView.callHandler("useH5Function", new Gson().toJson(wzBack), null);
                if (errorCode == com.webank.faceaction.tools.ErrorCode.FACEVERIFY_LOGIN_PARAMETER_ERROR) {
                    showToast("传入参数有误！" + errorMsg);
                } else {
                    showToast("登录刷脸sdk失败！" + "errorCode= " + errorCode + " ;errorMsg=" + errorMsg);
                }
            }
        });
    }


    public void showToast(String msg) {
        Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
    }

    BottomSheetDialog bsd1;
    public static final int MY_PERMISSIONS_REQUEST_CALL_PHONE = 6;
    public static final int MY_PERMISSIONS_REQUEST_CALL_PHONE2 = 8;
    public static final int FILECHOOSER_RESULTCODE = 1000;
    public static final int REQ_CHOOSE = 1001;
    String[] permissions = new String[]{
            Manifest.permission.CAMERA,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
    };

    // 声明一个集合，在后面的代码中用来存储用户拒绝授权的权
    List<String> mPermissionList = new ArrayList<>();

    private void choseFlieType() {
        View view = View.inflate(this, R.layout.webview_chose_file, null);
        RelativeLayout rl_take_photo = (RelativeLayout) view.findViewById(R.id.rl_take_photo);
        RelativeLayout rl_image_chooser = (RelativeLayout) view.findViewById(R.id.rl_image_chooser);
        RelativeLayout rl_cancle = (RelativeLayout) view.findViewById(R.id.rl_cancle);
        rl_take_photo.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                bsd1.dismiss();
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    mPermissionList.clear();
                    for (int i = 0; i < permissions.length; i++) {
                        if (ContextCompat.checkSelfPermission(SsqWebActivity.this, permissions[i]) != PackageManager.PERMISSION_GRANTED) {
                            mPermissionList.add(permissions[i]);
                        }
                    }
                    if (mPermissionList.isEmpty()) {
                        takePhoto();
                    } else {//请求权限方法
                        String[] permissions = mPermissionList.toArray(new String[mPermissionList.size()]);//将List转为数组
                        ActivityCompat.requestPermissions(SsqWebActivity.this, permissions, MY_PERMISSIONS_REQUEST_CALL_PHONE);
                    }
                } else {
                    takePhoto();
                }
            }
        });
        rl_image_chooser.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                bsd1.dismiss();
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    mPermissionList.clear();
                    for (int i = 0; i < permissions.length; i++) {
                        if (ContextCompat.checkSelfPermission(SsqWebActivity.this, permissions[i]) != PackageManager.PERMISSION_GRANTED) {
                            mPermissionList.add(permissions[i]);
                        }
                    }
                    if (mPermissionList.isEmpty()) {
                        openImageChooserActivity();
                    } else {//请求权限方法
                        String[] permissions = mPermissionList.toArray(new String[mPermissionList.size()]);//将List转为数组
                        ActivityCompat.requestPermissions(SsqWebActivity.this, permissions, MY_PERMISSIONS_REQUEST_CALL_PHONE2);
                    }
                } else {
                    openImageChooserActivity();
                }
            }
        });
        rl_cancle.setOnClickListener(new View.OnClickListener() {
                                         @Override
                                         public void onClick(View view) {
                                             bsd1.cancel();
                                         }
                                     }
        );
        if (bsd1 == null) {
            bsd1 = new BottomSheetDialog(SsqWebActivity.this);
            bsd1.setContentView(view);
        }
        bsd1.setOnCancelListener(new DialogInterface.OnCancelListener() {
                                     @Override
                                     public void onCancel(DialogInterface dialogInterface) {
                                         cancelFilePathCallback();
                                     }
                                 }
        );
        bsd1.show();
    }

    /**
     * 取消mFilePathCallback回调
     */
    public void cancelFilePathCallback() {
        if (uploadMessageAboveL != null) {
            uploadMessageAboveL.onReceiveValue(null);
            uploadMessageAboveL = null;
        } else if (uploadMessage != null) {
            uploadMessage.onReceiveValue(null);
            uploadMessage = null;
        }
    }

    public void takePhoto() {
        Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        if (takePictureIntent.resolveActivity(getPackageManager()) != null) {
            String filename = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.CHINA)
                    .format(new Date()) + ".png";
            File file = new File(Environment.getExternalStorageDirectory(), filename);
            mCurrentPhotoPath = file.getAbsolutePath();

            Uri fileUri = BestsignFileProvider.getUriForFile(this, getApplicationInfo().packageName + ".fileprovider", file);
            System.out.println("======" + getApplicationInfo().packageName);
            takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri);
            startActivityForResult(takePictureIntent, FILECHOOSER_RESULTCODE);
        }
    }

    String mCurrentPhotoPath = null;

    public void pickFile() {
        Intent chooserIntent = new Intent(Intent.ACTION_GET_CONTENT);
        chooserIntent.setType("image/*");
        startActivityForResult(chooserIntent, RESULT_CODE);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (resultCode == RESULT_OK) {
            if (requestCode == FILECHOOSER_RESULTCODE || requestCode == REQ_CHOOSE) {
                if (null == uploadMessage && null == uploadMessageAboveL) return;
                Uri result = intent == null || resultCode != RESULT_OK ? null : intent.getData();
                if (uploadMessageAboveL != null) {
                    onActivityResultAboveL(requestCode, intent);
                } else if (uploadMessage != null) {
                    uploadMessage.onReceiveValue(result);
                    uploadMessage = null;
                }
            }
        } else {
            cancelFilePathCallback();
        }
    }

    //5.0以上版本，由于api不一样，要单独处理
    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private void onActivityResultAboveL(int requestCode, Intent data) {

        if (uploadMessageAboveL == null) {
            return;
        }
        Uri result = null;
        if (requestCode == FILECHOOSER_RESULTCODE) {
            File file = new File(mCurrentPhotoPath);
            Uri localUri = Uri.fromFile(file);
            Intent localIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, localUri);
            sendBroadcast(localIntent);
            result = Uri.fromFile(file);

        } else if (requestCode == REQ_CHOOSE) {
            result = data.getData();
        }
        uploadMessageAboveL.onReceiveValue(new Uri[]{result});
        uploadMessageAboveL = null;
        return;
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == MY_PERMISSIONS_REQUEST_CALL_PHONE) {
            boolean hasPermissionDismiss = false;//有权限没有通过
            for (int i = 0; i < grantResults.length; i++) {
                if (grantResults[i] == PackageManager.PERMISSION_DENIED) {
                    hasPermissionDismiss = true;
                }
            }
            if (hasPermissionDismiss) {
                Toast.makeText(this, R.string.request_storage, Toast.LENGTH_LONG).show();
                cancelFilePathCallback();
            } else {
                takePhoto();
            }
        }
        if (requestCode == MY_PERMISSIONS_REQUEST_CALL_PHONE2) {
            boolean hasPermissionDismiss = false;//有权限没有通过
            for (int i = 0; i < grantResults.length; i++) {
                if (grantResults[i] == PackageManager.PERMISSION_DENIED) {
                    hasPermissionDismiss = true;
                }
            }
            if (hasPermissionDismiss) {
                Toast.makeText(this, R.string.request_storage, Toast.LENGTH_LONG).show();
                cancelFilePathCallback();
            } else {
                openImageChooserActivity();
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

    }

    public void openImageChooserActivity() {
        Intent i = createFileItent();
        startActivityForResult(Intent.createChooser(i, "Image Chooser"), REQ_CHOOSE);
    }

    /**
     * 创建选择图库的intent
     *
     * @return
     */
    private Intent createFileItent() {
        Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
        intent.addCategory(Intent.CATEGORY_OPENABLE);
        intent.setType("*/*");
        return intent;

    }

    @Override
    public void onBackPressed() {
        backIfPossible();
    }

    private void backIfPossible() {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
        } else {
            if (mSsqWebFinishListener != null) {
                mSsqWebFinishListener.onSuccess(result);
            }
            finish();
        }
    }

    public interface SsqWebFinishListener {
        void onSuccess(String result);
    }

    public static void start(Activity activity, String url, String license, SsqWebFinishListener ssqWebFinishListener) {
        Intent intent = new Intent(activity, SsqWebActivity.class);
        intent.putExtra(EXTRA_NAME_URL, url);
        intent.putExtra(EXTRA_NAME_LICENSE, license);
        activity.startActivity(intent);
        mSsqWebFinishListener = ssqWebFinishListener;
    }

    @Override
    protected void onDestroy() {
        if (mWebView != null) {
            ViewParent parent = mWebView.getParent();
            if (parent != null) {
                ((ViewGroup) parent).removeView(mWebView);
            }
            mWebView.stopLoading();
            // 退出时调用此方法，移除绑定的服务，否则某些特定系统会报错
            mWebView.getSettings().setJavaScriptEnabled(false);
            mWebView.clearHistory();
            mWebView.clearView();
            mWebView.removeAllViews();
            mWebView.destroy();
        }
        super.onDestroy();
    }
}
