/*
 * Decompiled with CFR 0.152.
 */
package com.beastwall.storagemanager.utils;

import com.beastwall.storagemanager.utils.FileType;
import com.beastwall.storagemanager.utils.MimeType;
import java.io.File;
import java.util.Date;
import java.util.Random;

public final class StorageUtils {
    public static String STORAGE_MAIN_FOLDER = "beastwall/storagemanager" + File.separator;
    public static String OTHER_FILES_FOLDER = STORAGE_MAIN_FOLDER + "other" + File.separator;

    public static String randomName(String prefix, FileType fileType) {
        if (prefix == null) {
            prefix = "";
        }
        String typePrefix = "others";
        if (fileType == FileType.HTML || fileType == FileType.CSS) {
            typePrefix = "web_file";
        } else if (fileType == FileType.MICROSOFT_EXCEL || fileType == FileType.MICROSOFT_WORD || fileType == FileType.MICROSOFT_POWERPOINT) {
            typePrefix = "office";
        } else if (fileType == FileType.SQL_DATABASE) {
            typePrefix = "database";
        } else if (fileType == FileType.ANDROID_APPLICATION) {
            typePrefix = "android_app";
        } else if (fileType == FileType.JAR) {
            typePrefix = "jar";
        } else if (fileType == FileType.IMAGE) {
            typePrefix = "picture";
        } else if (fileType == FileType.VIDEO) {
            typePrefix = "movie";
        } else if (fileType == FileType.AUDIO) {
            typePrefix = "audio";
        } else if (fileType == FileType.PDF) {
            typePrefix = "pdf";
        } else if (fileType == FileType.TEXT) {
            typePrefix = "text";
        } else if (fileType == FileType.XML) {
            typePrefix = "xml";
        }
        long time = new Date().getTime();
        Random random = new Random();
        return prefix + "_" + typePrefix + "_" + time + "_" + random.nextLong() + "_" + random.nextLong() + "_" + time * (long)random.nextInt();
    }

    public static String randomNameWithExtension(String prefix, MimeType mimeType) {
        FileType fileType = StorageUtils.guessFileType(mimeType.toString());
        return StorageUtils.randomName(prefix, fileType) + StorageUtils.guessFileExtension(mimeType);
    }

    public static final String defaultRandomName(FileType fileType) {
        return StorageUtils.randomName("", fileType);
    }

    public static FileType guessFileType(String path) {
        if (path == null || path.isEmpty()) {
            return FileType.NOT_A_FILE;
        }
        String lCPath = path.trim().toLowerCase();
        if (lCPath.contains("image/") || lCPath.contains(".webp") || lCPath.contains(".png") || lCPath.contains(".jpg") || lCPath.contains(".jpeg") || lCPath.contains(".gif") || lCPath.contains(".bmp") || lCPath.contains(".gifv") || lCPath.contains(".apng") || lCPath.contains(".avif") || lCPath.contains(".jfif") || lCPath.contains(".pjpeg") || lCPath.contains(".pjp") || lCPath.contains(".svg") || lCPath.contains(".ico") || lCPath.contains(".cur") || lCPath.contains(".tif")) {
            return FileType.IMAGE;
        }
        if (lCPath.contains("video/") || lCPath.contains(".mp4") || lCPath.contains(".mpg") || lCPath.contains(".mpeg") || lCPath.contains(".3gp") || lCPath.contains(".mkv") || lCPath.contains(".webm") || lCPath.contains(".flv") || lCPath.contains(".vob") || lCPath.contains(".ogv") || lCPath.contains(".ovv") || lCPath.contains(".drc") || lCPath.contains(".f4b") || lCPath.contains(".mnv") || lCPath.contains(".avi") || lCPath.contains("ts") || lCPath.contains(".mov") || lCPath.contains(".qt") || lCPath.contains(".wmv") || lCPath.contains(".yuv") || lCPath.contains(".viv") || lCPath.contains(".asf") || lCPath.contains(".amv") || lCPath.contains(".m4v") || lCPath.contains(".svi") || lCPath.contains(".3g2") || lCPath.contains(".mxf") || lCPath.contains(".roq") || lCPath.contains(".nsv") || lCPath.contains(".f4v") || lCPath.contains(".f4p") || lCPath.contains(".f4a")) {
            return FileType.VIDEO;
        }
        if (lCPath.contains("audio/") || lCPath.contains(".aa") || lCPath.contains(".act") || lCPath.contains(".aiff") || lCPath.contains(".alac") || lCPath.contains(".ape") || lCPath.contains(".amr") || lCPath.contains(".au") || lCPath.contains(".awb") || lCPath.contains(".dss") || lCPath.contains(".dvf") || lCPath.contains(".flac") || lCPath.contains(".gsm") || lCPath.contains(".iklax") || lCPath.contains(".ivs") || lCPath.contains(".m4a") || lCPath.contains(".m4b") || lCPath.contains(".m4p") || lCPath.contains(".mmf") || lCPath.contains(".mp3") || lCPath.contains(".mpc") || lCPath.contains(".msv") || lCPath.contains(".nmf") || lCPath.contains(".ogg") || lCPath.contains(".oga") || lCPath.contains(".mogg") || lCPath.contains(".opus") || lCPath.contains(".org") || lCPath.contains(".ra") || lCPath.contains(".rm") || lCPath.contains(".raw") || lCPath.contains(".rf64") || lCPath.contains(".sln") || lCPath.contains(".tta") || lCPath.contains(".voc") || lCPath.contains(".vox") || lCPath.contains(".wav") || lCPath.contains(".wma") || lCPath.contains(".wv") || lCPath.contains(".8svx") || lCPath.contains(".cda")) {
            return FileType.AUDIO;
        }
        if (lCPath.contains(".txt")) {
            return FileType.TEXT;
        }
        if (lCPath.contains(".xls") || lCPath.contains(".xlt") || lCPath.contains(".xla") || lCPath.contains(".xlsx") || lCPath.contains(".xlsm") || lCPath.contains(".xltx") || lCPath.contains(".xltm") || lCPath.contains(".xlam")) {
            return FileType.MICROSOFT_EXCEL;
        }
        if (lCPath.contains(".doc") || lCPath.contains(".dot") || lCPath.contains(".wbk") || lCPath.contains(".docx") || lCPath.contains(".docm") || lCPath.contains(".dotx") || lCPath.contains(".dotm") || lCPath.contains(".docb")) {
            return FileType.MICROSOFT_WORD;
        }
        if (lCPath.contains(".ppt")) {
            return FileType.MICROSOFT_POWERPOINT;
        }
        if (lCPath.contains(".pdf")) {
            return FileType.PDF;
        }
        if (lCPath.contains(".htm")) {
            return FileType.HTML;
        }
        if (lCPath.contains(".css")) {
            return FileType.CSS;
        }
        if (lCPath.contains(".xml")) {
            return FileType.XML;
        }
        if (lCPath.contains(".exe")) {
            return FileType.WINDOWS_EXECUTABLE;
        }
        if (lCPath.contains(".lib")) {
            return FileType.WINDOWS_EXTERNAL_LIBRARY;
        }
        if (lCPath.contains(".db") || lCPath.contains(".mdf") || lCPath.contains(".sdf")) {
            return FileType.SQL_DATABASE;
        }
        if (lCPath.equals("application/vnd.android.package-archive") || lCPath.contains(".apk") || lCPath.contains(".aab")) {
            return FileType.ANDROID_APPLICATION;
        }
        if (lCPath.equals((Object)MimeType.JAR_FILE) || lCPath.contains(".jar")) {
            return FileType.JAR;
        }
        return FileType.OTHERS;
    }

    public static FileType guessFileType(File file) {
        String path = file == null || !file.exists() ? null : file.getName();
        return StorageUtils.guessFileType(path);
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.isEmpty() || !fileName.contains(".")) {
            return "";
        }
        String[] parts = fileName.replace(".", "##").split("##");
        return "." + parts[parts.length - 1];
    }

    public static String guessFileExtension(MimeType mimeType) {
        if (mimeType == null || mimeType.toString().isEmpty()) {
            return ".bin";
        }
        String lcMime = mimeType.toString().toLowerCase();
        String extension = "";
        extension = lcMime.contains(MimeType.IMAGE_APNG.toString()) ? ".apng" : (lcMime.contains(MimeType.IMAGE_AVIF.toString()) ? ".avif" : (lcMime.contains(MimeType.IMAGE_GIF.toString()) ? ".gif" : (lcMime.contains(MimeType.IMAGE_JPEG.toString()) ? ".jpg" : (lcMime.contains(MimeType.IMAGE_PNG.toString()) ? ".png" : (lcMime.contains(MimeType.IMAGE_SVG.toString()) ? ".svg" : (lcMime.contains(MimeType.IMAGE_WEBP.toString()) ? ".webp" : (lcMime.contains(MimeType.IMAGE_BITMAP.toString()) ? ".bmp" : (lcMime.contains(MimeType.IMAGE_IEF.toString()) ? ".ief" : (lcMime.contains(MimeType.IMAGE_PIPEG.toString()) ? ".pipeg" : (lcMime.contains(MimeType.IMAGE_TIFF.toString()) ? ".tiff" : (lcMime.contains(MimeType.IMAGE_ICON.toString()) ? ".ico" : (lcMime.contains(MimeType.AUDIO_FLAC.toString()) ? ".flac" : (lcMime.contains(MimeType.AUDIO_M3U.toString()) ? ".m3u" : (lcMime.contains(MimeType.AUDIO_M4B.toString()) ? ".m4b" : (lcMime.contains(MimeType.AUDIO_MP3.toString()) ? ".mp3" : (lcMime.contains(MimeType.AUDIO_OGG.toString()) ? ".ogg" : (lcMime.contains(MimeType.AUDIO_PLS.toString()) ? ".pls" : (lcMime.contains(MimeType.AUDIO_WAV.toString()) ? ".wav" : (lcMime.contains(MimeType.AUDIO_AAC.toString()) ? ".aac" : (lcMime.contains(MimeType.AUDIO_WEBM.toString()) ? ".webm" : (lcMime.contains(MimeType.AUDIO_WMA.toString()) ? ".wma" : (lcMime.contains(MimeType.AUDIO_AU.toString()) ? ".au" : (lcMime.contains(MimeType.AUDIO_MID.toString()) ? ".mid" : (lcMime.contains(MimeType.AUDIO_3G2.toString()) ? ".3g2" : (lcMime.contains(MimeType.AUDIO_XSPF.toString()) ? ".xspf" : (lcMime.contains(MimeType.VIDEO_FLV.toString()) ? ".flv" : (lcMime.contains(MimeType.VIDEO_MP4.toString()) ? ".mp4" : (lcMime.contains(MimeType.VIDEO_3GP.toString()) ? ".3gp" : (lcMime.contains(MimeType.VIDEO_MOV.toString()) ? ".mov" : (lcMime.contains(MimeType.VIDEO_AVI.toString()) ? ".avi" : (lcMime.contains(MimeType.VIDEO_WMV.toString()) ? ".wmv" : (lcMime.contains(MimeType.VIDEO_MPEG.toString()) ? ".mpeg" : (lcMime.contains(MimeType.VIDEO_OGV.toString()) ? ".ogv" : (lcMime.contains(MimeType.VIDEO_WEBM.toString()) ? ".webm" : (lcMime.contains(MimeType.APPLICATION_ANDROID.toString()) ? ".apk" : (lcMime.contains(MimeType.APPLICATION_XML.toString()) ? ".xml" : (lcMime.contains(MimeType.ZIP.toString()) ? ".zip" : (lcMime.contains(MimeType.JAR_FILE.toString()) ? ".jar" : (lcMime.contains(MimeType.RAR.toString()) ? ".rar" : (lcMime.contains(MimeType.TAR.toString()) ? ".tar" : (lcMime.contains(MimeType.XLS.toString()) ? ".xls" : (lcMime.contains(MimeType.XLSX.toString()) ? ".xlsx" : (lcMime.contains(MimeType.TEXT_HTML.toString()) ? ".html" : (lcMime.contains(MimeType.TEXT_CSS.toString()) ? ".css" : (lcMime.contains(MimeType.TEXT_ICS.toString()) ? ".ics" : (lcMime.contains(MimeType.TEXT_CSV.toString()) ? ".csv" : (lcMime.contains(MimeType.TEXT_XML.toString()) ? ".xml" : (lcMime.contains(MimeType.TEXT_PLAIN.toString()) ? ".txt" : (lcMime.contains(MimeType.APPLICATION_JSON.toString()) ? ".json" : (lcMime.contains(MimeType.APPLICATION_OCTET_STREAM.toString()) ? ".bin" : (lcMime.contains(MimeType.APPLICATION_XHTML_XML.toString()) ? ".xhtml" : (lcMime.contains(MimeType.PDF.toString()) ? ".pdf" : ".bin"))))))))))))))))))))))))))))))))))))))))))))))))))));
        return extension;
    }

    public static boolean isStoredLocally(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }
}

