/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.beardedhen.androidbootstrap.font.FontAwesome;
import com.beardedhen.androidbootstrap.font.IconSet;
import com.beardedhen.androidbootstrap.font.MaterialIcons;
import com.beardedhen.androidbootstrap.font.Typicon;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TypefaceProvider {
    private static final Map<CharSequence, Typeface> TYPEFACE_MAP = new HashMap<CharSequence, Typeface>();
    private static final Map<CharSequence, IconSet> REGISTERED_ICON_SETS = new HashMap<CharSequence, IconSet>();

    public static Typeface getTypeface(Context context, IconSet iconSet) {
        String path = iconSet.fontPath().toString();
        if (TYPEFACE_MAP.get(path) == null) {
            Typeface font = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)path);
            TYPEFACE_MAP.put(path, font);
        }
        return TYPEFACE_MAP.get(path);
    }

    public static void registerDefaultIconSets() {
        FontAwesome fontAwesome = new FontAwesome();
        Typicon typicon = new Typicon();
        MaterialIcons materialIcons = new MaterialIcons();
        REGISTERED_ICON_SETS.put(fontAwesome.fontPath(), fontAwesome);
        REGISTERED_ICON_SETS.put(typicon.fontPath(), typicon);
        REGISTERED_ICON_SETS.put(materialIcons.fontPath(), materialIcons);
    }

    public static void registerCustomIconSet(IconSet iconSet) {
        REGISTERED_ICON_SETS.put(iconSet.fontPath(), iconSet);
    }

    public static IconSet retrieveRegisteredIconSet(String fontPath, boolean editMode) {
        IconSet iconSet = REGISTERED_ICON_SETS.get(fontPath);
        if (iconSet == null && !editMode) {
            throw new RuntimeException(String.format("Font '%s' not properly registered, please see the README at https://github.com/Bearded-Hen/Android-Bootstrap", fontPath));
        }
        return iconSet;
    }

    public static Collection<IconSet> getRegisteredIconSets() {
        return REGISTERED_ICON_SETS.values();
    }
}

