/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.beardedhen.androidbootstrap.BootstrapGroup;
import com.beardedhen.androidbootstrap.BootstrapProgressBar;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.view.ProgressView;
import com.beardedhen.androidbootstrap.api.view.RoundableView;

public class BootstrapProgressBarGroup
extends BootstrapGroup
implements ProgressView,
RoundableView {
    private int cumulativeProgress;
    private int maxProgress;
    private final BootstrapProgressBar emptyProgressBar = new BootstrapProgressBar(this.getContext());
    private int sizeOrdinal;
    private boolean striped = false;
    private boolean isEmptyBeingAdded = false;
    private boolean rounded;
    private boolean animated;

    public BootstrapProgressBarGroup(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapProgressBarGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapProgressBarGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(attrs);
    }

    @Override
    protected void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapProgressBarGroup);
        try {
            this.maxProgress = a.getInt(R.styleable.BootstrapProgressBarGroup_bootstrapMaxProgress, 100);
            this.sizeOrdinal = a.getInt(R.styleable.BootstrapProgressBarGroup_bootstrapSize, 2);
            this.rounded = a.getBoolean(R.styleable.BootstrapProgressBarGroup_roundedCorners, false);
        }
        finally {
            a.recycle();
        }
        this.setOrientation(0);
        this.updateBootstrapGroup();
    }

    @Override
    protected void onBootstrapViewAdded() {
        this.addEmptyProgressBar();
        this.updateBootstrapGroup();
    }

    @Override
    protected void onBootstrapViewRemoved() {
        this.addEmptyProgressBar();
        this.updateBootstrapGroup();
    }

    private void addEmptyProgressBar() {
        int whereIsEmpty = -1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.retrieveChild(i) == null || !this.retrieveChild(i).equals(this.emptyProgressBar)) continue;
            whereIsEmpty = i;
        }
        if (whereIsEmpty != this.getChildCount() - 1) {
            if (whereIsEmpty != -1) {
                this.isEmptyBeingAdded = true;
                this.removeView(this.emptyProgressBar);
                this.isEmptyBeingAdded = false;
            }
            if (!this.isEmptyBeingAdded) {
                this.addView(this.emptyProgressBar);
            }
        }
    }

    @Override
    protected void updateBootstrapGroup() {
        if (this.getChildCount() == 0) {
            return;
        }
        this.cumulativeProgress = this.getCumulativeProgress();
        int numChildren = this.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            LinearLayout.LayoutParams layoutParams = this.getDefultlayoutParams();
            layoutParams.weight = this.retrieveChild(i).getProgress();
            this.retrieveChild(i).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.retrieveChild(i).setMaxProgress(this.retrieveChild(i).getProgress());
            this.retrieveChild(i).setBootstrapSize(this.sizeOrdinal);
            this.retrieveChild(i).setRounded(this.rounded);
            this.retrieveChild(i).setCornerRounding(false, false);
        }
        this.retrieveChild(0).setCornerRounding(true, false);
        this.retrieveChild(numChildren - 1).setCornerRounding(false, true);
        LinearLayout.LayoutParams layoutParams = this.getDefultlayoutParams();
        layoutParams.weight = (float)this.maxProgress - (float)this.cumulativeProgress;
        this.emptyProgressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.emptyProgressBar.setMaxProgress(this.maxProgress - this.cumulativeProgress);
        this.emptyProgressBar.setBootstrapSize(this.sizeOrdinal);
        this.setWeightSum(this.maxProgress);
    }

    private LinearLayout.LayoutParams getDefultlayoutParams() {
        int height = (int)TypedValue.applyDimension((int)1, (float)0.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(height, -2);
        return layoutParams;
    }

    public int getCumulativeProgress() {
        int numChildren = this.getChildCount();
        int total = 0;
        for (int i = 0; i < numChildren; ++i) {
            total += this.getChildProgress(i);
        }
        this.checkCumulativeSmallerThanMax(this.maxProgress, total);
        return total;
    }

    private void checkCumulativeSmallerThanMax(int max, int cumulative) {
        StringBuilder builder = new StringBuilder();
        builder.append("Max Progress Cant be smaller than cumulative progress. Max = ");
        builder.append(max);
        builder.append(", cumlative = ");
        builder.append(cumulative);
        builder.append(". \n");
        for (int i = 0; i < this.getChildCount(); ++i) {
            builder.append("Child ").append(i).append(" has progress ").append(this.getChildProgress(i));
        }
        if (max < cumulative) {
            throw new IllegalStateException(builder.toString());
        }
    }

    private int getChildProgress(int i) {
        return this.retrieveChild(i).getProgress();
    }

    private BootstrapProgressBar retrieveChild(int i) {
        View view = this.getChildAt(i);
        if (view instanceof BootstrapProgressBar) {
            return (BootstrapProgressBar)view;
        }
        throw new IllegalStateException("All child view of BootstrapProgressBarGroup must be BootstrapProgressBar");
    }

    public void onProgressChanged(BootstrapProgressBar bootstrapProgressBar) {
        this.updateBootstrapGroup();
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public void setMaxProgress(int maxProgress) {
        this.checkCumulativeSmallerThanMax(maxProgress, this.cumulativeProgress);
        this.maxProgress = maxProgress;
    }

    @Override
    public void setRounded(boolean rounded) {
        this.rounded = rounded;
        this.updateBootstrapGroup();
    }

    @Override
    public boolean isRounded() {
        return this.rounded;
    }

    @Override
    public void setProgress(int progress) {
        throw new IllegalStateException("This method not applicable for type BootstrapProgressBarGroup");
    }

    @Override
    public int getProgress() {
        throw new IllegalStateException("This method not applicable for type BootstrapProgressBarGroup");
    }

    @Override
    public void setStriped(boolean striped) {
        this.striped = striped;
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.retrieveChild(i).setStriped(striped);
        }
    }

    @Override
    public boolean isStriped() {
        return this.striped;
    }

    @Override
    public void setAnimated(boolean animated) {
        this.animated = animated;
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.retrieveChild(i).setAnimated(animated);
        }
    }

    @Override
    public boolean isAnimated() {
        return this.animated;
    }
}

