/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import com.beardedhen.androidbootstrap.BootstrapText;
import com.beardedhen.androidbootstrap.TypefaceProvider;
import com.beardedhen.androidbootstrap.font.IconSet;

class IconResolver {
    private static final String REGEX_FONT_AWESOME = "(fa_|fa-)[a-z_0-9]+";
    private static final String REGEX_TYPICONS = "(ty_|ty-)[a-z_0-9]+";
    private static final String REGEX_MATERIAL_ICONS = "(md_)[a-z_0-9]+";

    IconResolver() {
    }

    static BootstrapText resolveMarkdown(Context context, String markdown, boolean editMode) {
        if (markdown == null) {
            return null;
        }
        BootstrapText.Builder builder = new BootstrapText.Builder(context, editMode);
        int lastAddedIndex = 0;
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < markdown.length(); ++i) {
            char c = markdown.charAt(i);
            if (c == '\\') {
                i += 2;
                continue;
            }
            if (c == '{') {
                startIndex = i;
            } else if (c == '}') {
                endIndex = i;
            }
            if (startIndex == -1 || endIndex == -1) continue;
            if (startIndex >= 0 && endIndex < markdown.length()) {
                String iconCode = markdown.substring(startIndex + 1, endIndex).replaceAll("\\-", "_");
                builder.addText(markdown.substring(lastAddedIndex, startIndex));
                if (iconCode.matches(REGEX_FONT_AWESOME)) {
                    if (editMode) {
                        builder.addText("?");
                    } else {
                        builder.addIcon(iconCode, TypefaceProvider.retrieveRegisteredIconSet("fontawesome-webfont-v450.ttf", false));
                    }
                } else if (iconCode.matches(REGEX_TYPICONS)) {
                    if (editMode) {
                        builder.addText("?");
                    } else {
                        builder.addIcon(iconCode, TypefaceProvider.retrieveRegisteredIconSet("typicons-v207.ttf", false));
                    }
                } else if (iconCode.matches(REGEX_MATERIAL_ICONS)) {
                    if (editMode) {
                        builder.addText("?");
                    } else {
                        builder.addIcon(iconCode, TypefaceProvider.retrieveRegisteredIconSet("MaterialIcons-Regular.ttf", false));
                    }
                } else if (editMode) {
                    builder.addText("?");
                } else {
                    builder.addIcon(iconCode, IconResolver.resolveIconSet(iconCode));
                }
                lastAddedIndex = endIndex + 1;
            }
            startIndex = -1;
            endIndex = -1;
        }
        return builder.addText(markdown.substring(lastAddedIndex, markdown.length())).build();
    }

    private static IconSet resolveIconSet(String iconCode) {
        for (IconSet set : TypefaceProvider.getRegisteredIconSets()) {
            CharSequence unicode;
            if (set.fontPath().equals("fontawesome-webfont-v450.ttf") || set.fontPath().equals("typicons-v207.ttf") || set.fontPath().equals("MaterialIcons-Regular.ttf") || (unicode = set.unicodeForKey(iconCode)) == null) continue;
            return set;
        }
        String message = String.format("Could not find FontIcon value for '%s', please ensure that it is mapped to a valid font", iconCode);
        throw new IllegalArgumentException(message);
    }
}

