/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.beardedhen.androidbootstrap.BootstrapProgressBarGroup;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.api.view.BootstrapBrandView;
import com.beardedhen.androidbootstrap.api.view.BootstrapSizeView;
import com.beardedhen.androidbootstrap.api.view.ProgressView;
import com.beardedhen.androidbootstrap.api.view.RoundableView;
import com.beardedhen.androidbootstrap.utils.ColorUtils;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import java.io.Serializable;

public class BootstrapProgressBar
extends View
implements ProgressView,
BootstrapBrandView,
RoundableView,
BootstrapSizeView,
Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    private static final String TAG = "com.beardedhen.androidbootstrap.AwesomeTextView";
    private static final long UPDATE_ANIM_MS = 300L;
    private static final int STRIPE_ALPHA = 150;
    private static final long STRIPE_CYCLE_MS = 1500L;
    private Paint progressPaint;
    private Paint stripePaint;
    private Paint bgPaint;
    private Paint textPaint;
    private int userProgress;
    private int drawnProgress;
    private int maxProgress;
    private boolean striped;
    private boolean animated;
    private boolean rounded;
    private boolean canRoundLeft = true;
    private boolean canRoundRight = true;
    private ValueAnimator progressAnimator;
    private Paint tilePaint;
    private final float baselineHeight = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_progress_bar_height);
    private BootstrapBrand bootstrapBrand;
    private Canvas progressCanvas;
    private Bitmap progressBitmap;
    private Bitmap stripeTile;
    private float bootstrapSize;
    private boolean showPercentage;

    public BootstrapProgressBar(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(AttributeSet attrs) {
        ValueAnimator.setFrameDelay((long)15L);
        this.tilePaint = new Paint();
        this.progressPaint = new Paint();
        this.progressPaint.setStyle(Paint.Style.FILL);
        this.progressPaint.setAntiAlias(true);
        this.stripePaint = new Paint();
        this.stripePaint.setStyle(Paint.Style.FILL);
        this.stripePaint.setAntiAlias(true);
        this.textPaint = new Paint();
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setColor(ColorUtils.resolveColor(17170444, this.getContext()));
        this.textPaint.setTextSize(DimenUtils.pixelsFromSpResource(this.getContext(), R.dimen.bootstrap_progress_bar_default_font_size));
        this.bgPaint = new Paint();
        this.bgPaint.setStyle(Paint.Style.FILL);
        this.bgPaint.setColor(ColorUtils.resolveColor(R.color.bootstrap_gray_light, this.getContext()));
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapProgressBar);
        try {
            this.animated = a.getBoolean(R.styleable.BootstrapProgressBar_animated, false);
            this.rounded = a.getBoolean(R.styleable.BootstrapProgressBar_roundedCorners, false);
            this.striped = a.getBoolean(R.styleable.BootstrapProgressBar_striped, false);
            this.showPercentage = a.getBoolean(R.styleable.BootstrapProgressBar_bootstrapshowPercentage, false);
            this.userProgress = a.getInt(R.styleable.BootstrapProgressBar_bootstrapProgress, 0);
            this.maxProgress = a.getInt(R.styleable.BootstrapProgressBar_bootstrapMaxProgress, 100);
            int typeOrdinal = a.getInt(R.styleable.BootstrapProgressBar_bootstrapBrand, -1);
            int sizeOrdinal = a.getInt(R.styleable.BootstrapProgressBar_bootstrapSize, -1);
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
            this.bootstrapBrand = DefaultBootstrapBrand.fromAttributeValue(typeOrdinal);
            this.drawnProgress = this.userProgress;
        }
        finally {
            a.recycle();
        }
        this.textPaint.setColor(this.bootstrapBrand.defaultTextColor(this.getContext()));
        this.textPaint.setTextSize(DimenUtils.pixelsFromSpResource(this.getContext(), R.dimen.bootstrap_button_default_font_size) * this.bootstrapSize);
        this.updateBootstrapState();
        this.setProgress(this.userProgress);
        this.setMaxProgress(this.maxProgress);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putInt("com.beardedhen.androidbootstrap.api.view.KEY_USER_PROGRESS", this.userProgress);
        bundle.putInt("com.beardedhen.androidbootstrap.api.view.KEY_DRAWN_PROGRESS", this.drawnProgress);
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.KEY_STRIPED", this.striped);
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.KEY_ANIMATED", this.animated);
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.Roundable", this.rounded);
        bundle.putFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView", this.bootstrapSize);
        bundle.putSerializable("BootstrapBrand", (Serializable)this.bootstrapBrand);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            Serializable brand = bundle.getSerializable("BootstrapBrand");
            if (brand instanceof BootstrapBrand) {
                this.bootstrapBrand = (BootstrapBrand)brand;
            }
            this.userProgress = bundle.getInt("com.beardedhen.androidbootstrap.api.view.KEY_USER_PROGRESS");
            this.drawnProgress = bundle.getInt("com.beardedhen.androidbootstrap.api.view.KEY_DRAWN_PROGRESS");
            this.striped = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.KEY_STRIPED");
            this.animated = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.KEY_ANIMATED");
            this.rounded = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.Roundable");
            this.bootstrapSize = bundle.getFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView");
            state = bundle.getParcelable(TAG);
        }
        super.onRestoreInstanceState(state);
        this.updateBootstrapState();
        this.setProgress(this.userProgress);
    }

    private int getStripeColor(@ColorInt int color2) {
        return Color.argb((int)150, (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    private void startProgressUpdateAnimation() {
        this.clearAnimation();
        this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.drawnProgress, this.userProgress});
        this.progressAnimator.setDuration(300L);
        this.progressAnimator.setRepeatCount(0);
        this.progressAnimator.setRepeatMode(1);
        this.progressAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.progressAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.progressAnimator.addListener((Animator.AnimatorListener)this);
        this.progressAnimator.start();
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.drawnProgress = (int)((Float)animation.getAnimatedValue()).floatValue();
        this.invalidate();
    }

    public void onAnimationStart(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
        this.startStripedAnimationIfNeeded();
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationRepeat(Animator animation) {
    }

    private void startStripedAnimationIfNeeded() {
        if (!this.striped || !this.animated) {
            return;
        }
        this.clearAnimation();
        this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        this.progressAnimator.setDuration(300L);
        this.progressAnimator.setRepeatCount(-1);
        this.progressAnimator.setRepeatMode(1);
        this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BootstrapProgressBar.this.invalidate();
            }
        });
        this.progressAnimator.start();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (heightMode) {
            case 0x40000000: {
                break;
            }
            case -2147483648: {
                float desiredHeight = this.baselineHeight * this.bootstrapSize;
                height = (float)height > desiredHeight ? (int)desiredHeight : height;
                break;
            }
            default: {
                height = (int)(this.baselineHeight * this.bootstrapSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (h != oldh) {
            this.stripeTile = null;
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        float w = this.getWidth();
        float h = this.getHeight();
        if (w <= 0.0f || h <= 0.0f) {
            return;
        }
        if (this.progressBitmap == null) {
            this.progressBitmap = Bitmap.createBitmap((int)((int)w), (int)((int)h), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (this.progressCanvas == null) {
            this.progressCanvas = new Canvas(this.progressBitmap);
        }
        this.progressCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        float ratio = (float)this.drawnProgress / (float)this.maxProgress;
        int lineEnd = (int)(w * ratio);
        float offset = 0.0f;
        float offsetFactor = (float)(System.currentTimeMillis() % 1500L) / 1500.0f;
        if (this.striped && this.animated) {
            offset = h * 2.0f * offsetFactor;
        }
        if (this.striped) {
            if (this.stripeTile == null) {
                this.stripeTile = BootstrapProgressBar.createTile(h, this.stripePaint, this.progressPaint);
            }
            for (float start = 0.0f - offset; start < (float)lineEnd; start += (float)this.stripeTile.getWidth()) {
                this.progressCanvas.drawBitmap(this.stripeTile, start, 0.0f, this.tilePaint);
            }
        } else {
            this.progressCanvas.drawRect(0.0f, 0.0f, (float)lineEnd, h, this.progressPaint);
        }
        this.progressCanvas.drawRect((float)lineEnd, 0.0f, w, h, this.bgPaint);
        float corners = this.rounded ? h / 2.0f : 0.0f;
        Bitmap round = BootstrapProgressBar.createRoundedBitmap(this.progressBitmap, corners, this.canRoundRight, this.canRoundLeft);
        canvas.drawBitmap(round, 0.0f, 0.0f, this.tilePaint);
        if (this.showPercentage) {
            String percent = this.getProgress() + "%";
            int xPos = lineEnd / 2;
            int yPos = (int)((float)(canvas.getHeight() / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f);
            canvas.drawText(percent, (float)(xPos -= (int)(this.textPaint.measureText(percent) / 2.0f)), (float)yPos, this.textPaint);
        }
    }

    private static Bitmap createTile(float h, Paint stripePaint, Paint progressPaint) {
        Bitmap bm = Bitmap.createBitmap((int)((int)h * 2), (int)((int)h), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas tile = new Canvas(bm);
        float x = 0.0f;
        Path path = new Path();
        path.moveTo(x, 0.0f);
        path.lineTo(x, h);
        path.lineTo(h, h);
        tile.drawPath(path, stripePaint);
        path.reset();
        path.moveTo(x, 0.0f);
        path.lineTo(x + h, h);
        path.lineTo(x + h * 2.0f, h);
        path.lineTo(x + h, 0.0f);
        tile.drawPath(path, progressPaint);
        path.reset();
        path.moveTo(x += h, 0.0f);
        path.lineTo(x + h, 0.0f);
        path.lineTo(x + h, h);
        tile.drawPath(path, stripePaint);
        return bm;
    }

    private static Bitmap createRoundedBitmap(Bitmap bitmap, float cornerRadius, boolean roundRight, boolean roundLeft) {
        Bitmap roundedBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(roundedBitmap);
        Paint paint = new Paint();
        Rect frame = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        Rect leftRect = new Rect(0, 0, bitmap.getWidth() / 2, bitmap.getHeight());
        Rect rightRect = new Rect(bitmap.getWidth() / 2, 0, bitmap.getWidth(), bitmap.getHeight());
        paint.setAntiAlias(true);
        paint.setColor(-1);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawRoundRect(new RectF(frame), cornerRadius, cornerRadius, paint);
        if (!roundLeft) {
            canvas.drawRect(leftRect, paint);
        }
        if (!roundRight) {
            canvas.drawRect(rightRect, paint);
        }
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, frame, frame, paint);
        return roundedBitmap;
    }

    private void updateBootstrapState() {
        int color2 = this.bootstrapBrand.defaultFill(this.getContext());
        this.progressPaint.setColor(color2);
        this.stripePaint.setColor(this.getStripeColor(color2));
        this.invalidateDrawCache();
        this.invalidate();
    }

    private void invalidateDrawCache() {
        this.stripeTile = null;
        this.progressBitmap = null;
        this.progressCanvas = null;
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void setProgress(int progress) {
        if (this.getParent() instanceof BootstrapProgressBarGroup) {
            this.userProgress = 0;
            this.setMaxProgress(progress);
        } else if (progress < 0 || progress > this.maxProgress) {
            throw new IllegalArgumentException(String.format("Invalid value '%d' - progress must be an integer in the range 0-%d", progress, this.maxProgress));
        }
        this.userProgress = progress;
        if (this.animated) {
            this.startProgressUpdateAnimation();
        } else {
            this.drawnProgress = progress;
            this.invalidate();
        }
        ViewParent parent = this.getParent();
        if (parent != null && parent instanceof BootstrapProgressBarGroup) {
            BootstrapProgressBarGroup parentGroup = (BootstrapProgressBarGroup)parent;
            parentGroup.onProgressChanged(this);
        }
    }

    @Override
    public int getProgress() {
        return this.userProgress;
    }

    @Override
    public void setStriped(boolean striped) {
        this.striped = striped;
        this.invalidate();
        this.startStripedAnimationIfNeeded();
    }

    @Override
    public boolean isStriped() {
        return this.striped;
    }

    @Override
    public void setAnimated(boolean animated) {
        this.animated = animated;
        this.invalidate();
        this.startStripedAnimationIfNeeded();
    }

    @Override
    public boolean isAnimated() {
        return this.animated;
    }

    @Override
    public void setBootstrapBrand(@NonNull BootstrapBrand bootstrapBrand) {
        this.bootstrapBrand = bootstrapBrand;
        this.textPaint.setColor(bootstrapBrand.defaultTextColor(this.getContext()));
        this.updateBootstrapState();
    }

    @Override
    @NonNull
    public BootstrapBrand getBootstrapBrand() {
        return this.bootstrapBrand;
    }

    @Override
    public void setRounded(boolean rounded) {
        this.rounded = rounded;
        this.updateBootstrapState();
    }

    @Override
    public boolean isRounded() {
        return this.rounded;
    }

    @Override
    public float getBootstrapSize() {
        return this.bootstrapSize;
    }

    @Override
    public void setBootstrapSize(float bootstrapSize) {
        this.bootstrapSize = bootstrapSize;
        this.textPaint.setTextSize(DimenUtils.pixelsFromSpResource(this.getContext(), R.dimen.bootstrap_progress_bar_default_font_size) * this.bootstrapSize);
        this.requestLayout();
        this.updateBootstrapState();
    }

    @Override
    public void setBootstrapSize(DefaultBootstrapSize bootstrapSize) {
        this.setBootstrapSize(bootstrapSize.scaleFactor());
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public void setMaxProgress(int newMaxProgress) {
        if (this.getProgress() > newMaxProgress) {
            throw new IllegalArgumentException(String.format("MaxProgress cant be smaller than the current progress %d<%d", this.getProgress(), newMaxProgress));
        }
        this.maxProgress = newMaxProgress;
        this.invalidate();
        BootstrapProgressBarGroup parent = (BootstrapProgressBarGroup)this.getParent();
    }

    void setCornerRounding(boolean left, boolean right) {
        this.canRoundLeft = left;
        this.canRoundRight = right;
    }

    boolean getCornerRoundingLeft() {
        return this.canRoundLeft;
    }

    boolean getCornerRoundingRight() {
        return this.canRoundRight;
    }
}

