/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import com.beardedhen.androidbootstrap.AwesomeTextView;
import com.beardedhen.androidbootstrap.BootstrapBadge;
import com.beardedhen.androidbootstrap.BootstrapButtonGroup;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.attributes.ViewGroupPosition;
import com.beardedhen.androidbootstrap.api.defaults.ButtonMode;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.api.view.BadgeContainerView;
import com.beardedhen.androidbootstrap.api.view.BootstrapBadgeView;
import com.beardedhen.androidbootstrap.api.view.BootstrapSizeView;
import com.beardedhen.androidbootstrap.api.view.ButtonModeView;
import com.beardedhen.androidbootstrap.api.view.OutlineableView;
import com.beardedhen.androidbootstrap.api.view.RoundableView;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import com.beardedhen.androidbootstrap.utils.ViewUtils;
import java.io.Serializable;

public class BootstrapButton
extends AwesomeTextView
implements BootstrapSizeView,
OutlineableView,
RoundableView,
ButtonModeView,
BadgeContainerView,
BootstrapBadgeView {
    private static final String TAG = "com.beardedhen.androidbootstrap.BootstrapButton";
    private static final String KEY_MODE = "com.beardedhen.androidbootstrap.BootstrapButton.MODE";
    private static final String KEY_INDEX = "com.beardedhen.androidbootstrap.BootstrapButton.KEY_INDEX";
    private int parentIndex;
    private ViewGroupPosition viewGroupPosition = ViewGroupPosition.SOLO;
    private ButtonMode buttonMode = ButtonMode.REGULAR;
    private float bootstrapSize;
    private boolean roundedCorners;
    private boolean showOutline;
    private boolean mustBeSelected;
    private float baselineFontSize;
    private float baselineVertPadding;
    private float baselineHoriPadding;
    private float baselineStrokeWidth;
    private float baselineCornerRadius;
    private BootstrapBadge bootstrapBadge;
    private String badgeText;
    private OnCheckedChangedListener onCheckedChangedListener;

    public BootstrapButton(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapButton);
        this.viewGroupPosition = ViewGroupPosition.SOLO;
        try {
            this.roundedCorners = a.getBoolean(R.styleable.BootstrapButton_roundedCorners, false);
            this.showOutline = a.getBoolean(R.styleable.BootstrapButton_showOutline, false);
            this.mustBeSelected = a.getBoolean(R.styleable.BootstrapButton_checked, false);
            this.badgeText = a.getString(R.styleable.BootstrapButton_badgeText);
            int sizeOrdinal = a.getInt(R.styleable.BootstrapButton_bootstrapSize, -1);
            int modeOrdinal = a.getInt(R.styleable.BootstrapButton_buttonMode, -1);
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
            this.buttonMode = ButtonMode.fromAttributeValue(modeOrdinal);
        }
        finally {
            a.recycle();
        }
        this.baselineFontSize = DimenUtils.pixelsFromSpResource(this.getContext(), R.dimen.bootstrap_button_default_font_size);
        this.baselineVertPadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_button_default_vert_padding);
        this.baselineHoriPadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_button_default_hori_padding);
        this.baselineStrokeWidth = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_button_default_edge_width);
        this.baselineCornerRadius = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_button_default_corner_radius);
        this.updateBootstrapState();
        if (this.badgeText != null) {
            this.setBadge(new BootstrapBadge(this.getContext()));
            this.setBadgeText(this.badgeText);
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.Roundable", this.roundedCorners);
        bundle.putBoolean("Outlineable", this.showOutline);
        bundle.putInt(KEY_INDEX, this.parentIndex);
        bundle.putFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView", this.bootstrapSize);
        bundle.putSerializable(KEY_MODE, (Serializable)((Object)this.buttonMode));
        if (this.bootstrapBadge != null) {
            bundle.putString("com.beardedhen.androidbootstrap.api.view.BadgeContainerView", this.bootstrapBadge.getBadgeText());
        }
        return bundle;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Serializable m;
            Bundle bundle = (Bundle)state;
            this.roundedCorners = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.Roundable");
            this.showOutline = bundle.getBoolean("Outlineable");
            this.parentIndex = bundle.getInt(KEY_INDEX);
            this.bootstrapSize = bundle.getFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView");
            if (this.bootstrapBadge != null) {
                this.setBadgeText(bundle.getString("com.beardedhen.androidbootstrap.api.view.BadgeContainerView"));
            }
            if ((m = bundle.getSerializable(KEY_MODE)) instanceof ButtonMode) {
                this.buttonMode = (ButtonMode)((Object)m);
            }
        }
        super.onRestoreInstanceState(state);
    }

    @Override
    protected void updateBootstrapState() {
        super.updateBootstrapState();
        BootstrapBrand bootstrapBrand = this.getBootstrapBrand();
        float cornerRadius = this.baselineCornerRadius;
        float strokeWidth = this.baselineStrokeWidth;
        float fontSize = this.baselineFontSize * this.bootstrapSize;
        this.setTextSize(fontSize);
        this.setTextColor(BootstrapDrawableFactory.bootstrapButtonText(this.getContext(), this.showOutline, bootstrapBrand));
        Drawable bg = BootstrapDrawableFactory.bootstrapButton(this.getContext(), bootstrapBrand, (int)(strokeWidth *= this.bootstrapSize), (int)(cornerRadius *= this.bootstrapSize), this.viewGroupPosition, this.showOutline, this.roundedCorners);
        ViewUtils.setBackgroundDrawable((View)this, bg);
        int vert = (int)(this.baselineVertPadding * this.bootstrapSize);
        int hori = (int)(this.baselineHoriPadding * this.bootstrapSize);
        this.setPadding(hori, vert, hori, vert);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        switch (this.buttonMode) {
            case REGULAR: {
                return super.onTouchEvent(event);
            }
            case TOGGLE: {
                return this.handleToggle(event);
            }
            case CHECKBOX: {
                return this.handleToggle(event);
            }
            case RADIO: {
                return this.handleRadioEvent(event);
            }
        }
        return super.onTouchEvent(event);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.onCheckedChangedListener != null) {
            this.onCheckedChangedListener.OnCheckedChanged(this, selected);
        }
    }

    private boolean handleRadioEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 0) {
            this.setSelected(true);
            ViewParent parent = this.getParent();
            if (parent instanceof BootstrapButtonGroup) {
                ((BootstrapButtonGroup)parent).onRadioToggle(this.parentIndex);
            }
            return true;
        }
        return false;
    }

    private boolean handleToggle(@NonNull MotionEvent event) {
        if (event.getAction() == 0) {
            this.setSelected(!this.isSelected());
            return true;
        }
        return false;
    }

    void setViewGroupPosition(ViewGroupPosition viewGroupPosition, int parentIndex) {
        this.viewGroupPosition = viewGroupPosition;
        this.parentIndex = parentIndex;
        this.updateBootstrapState();
    }

    void updateFromParent(BootstrapBrand bootstrapBrand, float bootstrapSize, ButtonMode buttonMode, boolean outline, boolean rounded) {
        this.bootstrapSize = bootstrapSize;
        this.buttonMode = buttonMode;
        this.showOutline = outline;
        this.roundedCorners = rounded;
        this.setBootstrapBrand(bootstrapBrand);
        this.updateBootstrapState();
    }

    @Override
    public void displayBadgeDrawable() {
        Drawable badgeDrawable;
        if (this.bootstrapBadge != null && (badgeDrawable = this.bootstrapBadge.getBadgeDrawable()) != null) {
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, badgeDrawable, null);
            this.setCompoundDrawablePadding(DimenUtils.dpToPixels(4.0f));
        }
    }

    public boolean isMustBeSelected() {
        return this.mustBeSelected;
    }

    public void setChecked(boolean checked) {
        this.mustBeSelected = checked;
    }

    @Override
    public boolean isShowOutline() {
        return this.showOutline;
    }

    @Override
    public boolean isRounded() {
        return this.roundedCorners;
    }

    @Override
    public void setShowOutline(boolean showOutline) {
        this.showOutline = showOutline;
        this.updateBootstrapState();
    }

    @Override
    public void setRounded(boolean rounded) {
        this.roundedCorners = rounded;
        this.updateBootstrapState();
    }

    @Override
    @NonNull
    public ButtonMode getButtonMode() {
        return this.buttonMode;
    }

    @Override
    public void setButtonMode(@NonNull ButtonMode buttonMode) {
        this.buttonMode = buttonMode;
    }

    @Override
    public void setBadge(BootstrapBadge badge) {
        this.bootstrapBadge = badge;
        this.bootstrapBadge.setBootstrapBrand(this.getBootstrapBrand(), true);
        this.bootstrapBadge.setBootstrapSize(this.getBootstrapSize());
        this.displayBadgeDrawable();
    }

    @Override
    @Nullable
    public String getBadgeText() {
        return this.bootstrapBadge != null ? this.bootstrapBadge.getBadgeText() : null;
    }

    @Override
    public void setBadgeText(@Nullable String badgeText) {
        if (this.bootstrapBadge != null) {
            this.badgeText = badgeText;
            this.bootstrapBadge.setBadgeText(this.badgeText);
            this.displayBadgeDrawable();
        }
    }

    @Override
    public float getBootstrapSize() {
        return this.bootstrapSize;
    }

    @Override
    public BootstrapBadge getBootstrapBadge() {
        return this.bootstrapBadge;
    }

    @Override
    public void setBootstrapSize(DefaultBootstrapSize bootstrapSize) {
        this.setBootstrapSize(bootstrapSize.scaleFactor());
    }

    @Override
    public void setBootstrapSize(float bootstrapSize) {
        this.bootstrapSize = bootstrapSize;
        this.updateBootstrapState();
    }

    public void setOnCheckedChangedListener(OnCheckedChangedListener listener) {
        this.onCheckedChangedListener = listener;
    }

    public void setOnClickListener(View.OnClickListener l) {
        super.setOnClickListener(l);
    }

    public static interface OnCheckedChangedListener {
        public void OnCheckedChanged(BootstrapButton var1, boolean var2);
    }
}

