/*
 * Decompiled with CFR 0.152.
 */
package com.bean.logger;

import android.text.TextUtils;
import android.util.Log;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JJLogger {
    private static final char TOP_LEFT_CORNER = '\u2554';
    private static final char BOTTOM_LEFT_CORNER = '\u255a';
    private static final char HORIZONTAL_DOUBLE_LINE = '\u2551';
    private static final String DOUBLE_DIVIDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final char D = 'D';
    private static final char E = 'E';
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static int JSON_INDENT = 4;
    private static boolean isDebug = false;
    private static boolean stackTrace = true;

    public static void debug(boolean isEnable) {
        isDebug = isEnable;
    }

    public static void map(String tag, Map map) {
        if (isDebug) {
            Set set = map.entrySet();
            if (set.size() < 1) {
                JJLogger.printLog('D', tag, "[]");
                return;
            }
            int i = 0;
            String[] s = new String[set.size()];
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry aSet;
                Map.Entry entry = aSet = iterator.next();
                s[i] = "key = " + entry.getKey() + " , value = " + entry.getValue() + ",\n";
                ++i;
            }
            JJLogger.printLog('D', tag, s);
        }
    }

    public static void json(String tag, String jsonStr) {
        if (isDebug) {
            String message;
            try {
                if (jsonStr.startsWith("{")) {
                    JSONObject jsonObject = new JSONObject(jsonStr);
                    message = jsonObject.toString(JSON_INDENT);
                } else if (jsonStr.startsWith("[")) {
                    JSONArray jsonArray = new JSONArray(jsonStr);
                    message = jsonArray.toString(JSON_INDENT);
                } else {
                    message = jsonStr;
                }
            }
            catch (JSONException e) {
                message = jsonStr;
            }
            message = LINE_SEPARATOR + message;
            String[] lines = message.split(LINE_SEPARATOR);
            JJLogger.printLog('D', tag, lines);
        }
    }

    public static void logInfo(String tag, String msg) {
        if (isDebug) {
            JJLogger.printLog('D', tag, msg);
        }
    }

    public static void logError(String errorCode, String msg) {
        if (isDebug) {
            if (TextUtils.isEmpty((CharSequence)errorCode)) {
                JJLogger.printLog('E', "inner_error", "\u9519\u8bef\u4fe1\u606f : " + msg);
            } else if (stackTrace) {
                JJLogger.printLog('E', "inner_error", "\u9519\u8bef\u7801 \uff1a" + errorCode + " \u4fe1\u606f\u63cf\u8ff0 \uff1a" + msg);
            } else {
                JJLogger.printLog('E', "inner_error", "\u9519\u8bef\u7801 \uff1a" + errorCode);
            }
        }
    }

    private static void printer(char type, String tag, String msg) {
        switch (type) {
            case 'D': {
                Log.d((String)tag, (String)msg);
                break;
            }
            case 'E': {
                Log.e((String)tag, (String)msg);
            }
        }
    }

    private static void printLocation(char type, String tag, String ... msg) {
        StackTraceElement e;
        String name;
        for (String str : msg) {
            JJLogger.printer(type, tag, "\u2551   " + str);
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int i = 0;
        StackTraceElement[] stackTraceElementArray = stack;
        int str = stackTraceElementArray.length;
        for (int j = 0; j < str && !(name = (e = stackTraceElementArray[j]).getClassName()).equals(JJLogger.class.getName()); ++j) {
            ++i;
        }
        String location = stack[i += 3].toString();
        StringBuilder sb = new StringBuilder();
        sb.append('\u2551').append("   \u7ebf\u7a0b\u540d :  ").append(Thread.currentThread().getName()).append("  \u8c03\u7528\u4f4d\u7f6e:").append(location);
        JJLogger.printer(type, tag, sb.toString());
    }

    private static void printMsg(char type, String tag, String ... msg) {
        JJLogger.printer(type, tag, "\u2551   \u4fe1\u606f:");
        for (String str : msg) {
            JJLogger.printer(type, tag, "\u2551   " + str);
        }
    }

    private static void printLog(char type, String tag, String ... msg) {
        if (msg == null || msg.length == 0) {
            return;
        }
        JJLogger.printer(type, tag, TOP_BORDER);
        if (stackTrace) {
            JJLogger.printLocation(type, tag, msg);
        } else {
            JJLogger.printMsg(type, tag, msg);
        }
        JJLogger.printer(type, tag, BOTTOM_BORDER);
    }
}

