/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.maven.plugins.s3.upload;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.ObjectMetadataProvider;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="s3-upload")
public class S3UploadMojo
extends AbstractMojo {
    @Parameter(property="s3-upload.accessKey")
    private String accessKey;
    @Parameter(property="s3-upload.secretKey")
    private String secretKey;
    @Parameter(property="s3-upload.doNotUpload", defaultValue="false")
    private boolean doNotUpload;
    @Parameter(property="s3-upload.source", required=true)
    private File source;
    @Parameter(property="s3-upload.bucketName", required=true)
    private String bucketName;
    @Parameter(property="s3-upload.destination", required=true)
    private String destination;
    @Parameter(property="s3-upload.endpoint")
    private String endpoint;
    @Parameter(property="s3-upload.recursive", defaultValue="false")
    private boolean recursive;

    public void execute() throws MojoExecutionException {
        if (!this.source.exists()) {
            throw new MojoExecutionException("File/folder doesn't exist: " + this.source);
        }
        AmazonS3 s3 = S3UploadMojo.getS3Client(this.accessKey, this.secretKey);
        if (this.endpoint != null) {
            s3.setEndpoint(this.endpoint);
        }
        if (!s3.doesBucketExist(this.bucketName)) {
            throw new MojoExecutionException("Bucket doesn't exist: " + this.bucketName);
        }
        if (this.doNotUpload) {
            this.getLog().info((CharSequence)String.format("File %s would have be uploaded to s3://%s/%s (dry run)", this.source, this.bucketName, this.destination));
            return;
        }
        boolean success = this.upload(s3, this.source);
        if (!success) {
            throw new MojoExecutionException("Unable to upload file to S3.");
        }
        this.getLog().info((CharSequence)String.format("File %s uploaded to s3://%s/%s", this.source, this.bucketName, this.destination));
    }

    private static AmazonS3 getS3Client(String accessKey, String secretKey) {
        DefaultAWSCredentialsProviderChain provider;
        if (accessKey != null && secretKey != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(accessKey, secretKey);
            provider = new StaticCredentialsProvider((AWSCredentials)credentials);
        } else {
            provider = new DefaultAWSCredentialsProviderChain();
        }
        return new AmazonS3Client((AWSCredentialsProvider)provider);
    }

    private boolean upload(AmazonS3 s3, File sourceFile) throws MojoExecutionException {
        Upload transfer;
        TransferManager mgr = new TransferManager(s3);
        if (sourceFile.isFile()) {
            transfer = mgr.upload(new PutObjectRequest(this.bucketName, this.destination, sourceFile).withCannedAcl(CannedAccessControlList.BucketOwnerFullControl));
        } else if (sourceFile.isDirectory()) {
            transfer = mgr.uploadDirectory(this.bucketName, this.destination, sourceFile, this.recursive, new ObjectMetadataProvider(){

                public void provideObjectMetadata(File file, ObjectMetadata objectMetadata) {
                    objectMetadata.setHeader("x-amz-acl", (Object)CannedAccessControlList.BucketOwnerFullControl);
                }
            });
        } else {
            throw new MojoExecutionException("File is neither a regular file nor a directory " + sourceFile);
        }
        try {
            this.getLog().debug((CharSequence)("Transferring " + transfer.getProgress().getTotalBytesToTransfer() + " bytes..."));
            transfer.waitForCompletion();
            this.getLog().info((CharSequence)("Transferred " + transfer.getProgress().getBytesTransferred() + " bytes."));
        }
        catch (InterruptedException e) {
            return false;
        }
        return transfer.getState() == Transfer.TransferState.Completed;
    }
}

