/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.function;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.modifier.function.Function;
import java.util.Arrays;
import java.util.List;

public class Lists {

    public static final class sort
    extends Function.BaseFunction {
        protected Optional applyList(List argList) {
            try {
                Object[] dest = argList.toArray();
                Arrays.sort(dest);
                return Optional.of(dest);
            }
            catch (Exception ignored) {
                return Optional.empty();
            }
        }

        protected Optional applySingle(Object arg) {
            return Optional.of(arg);
        }
    }

    public static final class toList
    extends Function.BaseFunction<List> {
        @Override
        protected Optional<Object> applyList(List input) {
            return Optional.of(input);
        }

        @Override
        protected Optional<List> applySingle(Object arg) {
            return Optional.of(Arrays.asList(arg));
        }
    }

    public static final class elementAt
    extends Function.ArgDrivenListFunction<Integer> {
        @Override
        protected Optional<Object> applyList(Integer specialArg, List<Object> args) {
            if (specialArg != null && args != null && args.size() > specialArg) {
                return Optional.of(args.get(specialArg));
            }
            return Optional.empty();
        }
    }

    public static final class lastElement
    extends Function.ListFunction {
        @Override
        protected Optional applyList(List argList) {
            return argList.size() > 0 ? Optional.of(argList.get(argList.size() - 1)) : Optional.empty();
        }
    }

    public static final class firstElement
    extends Function.ListFunction {
        @Override
        protected Optional applyList(List argList) {
            return argList.size() > 0 ? Optional.of(argList.get(0)) : Optional.empty();
        }
    }
}

