/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.msgpack.core.buffer;

import com.batch.android.msgpack.core.buffer.a;
import com.batch.android.o0.p;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import sun.misc.Unsafe;

public class MessageBuffer {
    static final boolean isUniversalBuffer;
    static final Unsafe unsafe;
    static final int javaVersion;
    private static final Constructor<?> mbArrConstructor;
    private static final Constructor<?> mbBBConstructor;
    static final int ARRAY_BYTE_BASE_OFFSET;
    private static final String UNIVERSAL_MESSAGE_BUFFER = "com.batch.android.msgpack.core.buffer.MessageBufferU";
    private static final String BIGENDIAN_MESSAGE_BUFFER = "com.batch.android.msgpack.core.buffer.MessageBufferBE";
    private static final String DEFAULT_MESSAGE_BUFFER = "com.batch.android.msgpack.core.buffer.MessageBuffer";
    protected final Object base;
    protected final long address;
    protected final int size;
    protected final ByteBuffer reference;

    private static int a() {
        String string2 = System.getProperty("java.specification.version", "");
        int n2 = string2.indexOf(46);
        if (n2 != -1) {
            int n3 = Integer.parseInt(string2.substring(0, n2));
            try {
                int n4 = Integer.parseInt(string2.substring(n2 + 1));
                if (n3 <= 1) {
                    n3 = n4;
                }
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        } else {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        }
        return 6;
    }

    public static MessageBuffer allocate(int size) {
        if (size >= 0) {
            int n2;
            return MessageBuffer.wrap(new byte[n2]);
        }
        throw new IllegalArgumentException("size must not be negative");
    }

    public static MessageBuffer wrap(byte[] array) {
        return MessageBuffer.a(array, 0, array.length);
    }

    /*
     * WARNING - void declaration
     */
    public static MessageBuffer wrap(byte[] array, int offset, int length) {
        void var2_2;
        void var1_1;
        return MessageBuffer.a(array, (int)var1_1, (int)var2_2);
    }

    public static MessageBuffer wrap(ByteBuffer bb) {
        return MessageBuffer.a(bb);
    }

    /*
     * WARNING - void declaration
     */
    private static MessageBuffer a(byte[] arr, int off, int len) {
        byte[] byArray;
        void var2_3;
        void var1_1;
        p.a(arr);
        Constructor<?> constructor = mbArrConstructor;
        if (constructor != null) {
            Integer n2 = (int)var1_1;
            Integer n3 = (int)var2_3;
            return MessageBuffer.a(constructor, byArray, n2, n3);
        }
        return new MessageBuffer(byArray, (int)var1_1, (int)var2_3);
    }

    private static MessageBuffer a(ByteBuffer bb) {
        ByteBuffer byteBuffer;
        p.a(bb);
        Constructor<?> constructor = mbBBConstructor;
        if (constructor != null) {
            return MessageBuffer.a(constructor, byteBuffer);
        }
        return new MessageBuffer(byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    private static MessageBuffer a(Constructor<?> constructor, Object ... args) {
        InstantiationException instantiationException2;
        block7: {
            IllegalAccessException illegalAccessException2;
            block6: {
                try {
                    void var1_4;
                    return (MessageBuffer)constructor.newInstance((Object[])var1_4);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException2) {
                    break block6;
                }
                catch (InstantiationException instantiationException2) {
                    break block7;
                }
                if (!(invocationTargetException.getCause() instanceof RuntimeException)) {
                    if (invocationTargetException.getCause() instanceof Error) {
                        throw (Error)invocationTargetException.getCause();
                    }
                    throw new IllegalStateException(invocationTargetException.getCause());
                }
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new IllegalStateException(illegalAccessException2);
        }
        throw new IllegalStateException(instantiationException2);
    }

    public static void releaseBuffer(MessageBuffer buffer) {
        MessageBuffer messageBuffer;
        if (!isUniversalBuffer && !messageBuffer.hasArray()) {
            if (a.c((Object)messageBuffer.reference)) {
                a.a((Object)messageBuffer.reference);
            } else {
                unsafe.freeMemory(messageBuffer.address);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    MessageBuffer(byte[] arr, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessageBuffer messageBuffer = this;
        MessageBuffer messageBuffer2 = this;
        messageBuffer2.base = var1_1;
        messageBuffer2.address = ARRAY_BYTE_BASE_OFFSET + var2_2;
        messageBuffer.size = var3_3;
        messageBuffer.reference = null;
    }

    /*
     * WARNING - void declaration
     */
    MessageBuffer(ByteBuffer bb) {
        block6: {
            block5: {
                void var1_1;
                block4: {
                    if (!bb.isDirect()) break block4;
                    if (isUniversalBuffer) {
                        MessageBuffer messageBuffer = this;
                        MessageBuffer messageBuffer2 = this;
                        messageBuffer2.base = null;
                        messageBuffer2.address = 0L;
                        messageBuffer.size = var1_1.remaining();
                        messageBuffer.reference = null;
                        return;
                    }
                    this.base = null;
                    this.address = a.b(var1_1) + (long)var1_1.position();
                    this.size = var1_1.remaining();
                    this.reference = var1_1;
                    break block5;
                }
                if (!var1_1.hasArray()) break block6;
                MessageBuffer messageBuffer = this;
                MessageBuffer messageBuffer3 = this;
                messageBuffer3.base = var1_1.array();
                messageBuffer3.address = ARRAY_BYTE_BASE_OFFSET + var1_1.arrayOffset() + var1_1.position();
                messageBuffer.size = var1_1.remaining();
                messageBuffer.reference = null;
            }
            return;
        }
        throw new IllegalArgumentException("Only the array-backed ByteBuffer or DirectBuffer is supported");
    }

    /*
     * WARNING - void declaration
     */
    protected MessageBuffer(Object base, long address, int length) {
        void var4_3;
        void var2_2;
        void var1_1;
        this.base = var1_1;
        this.address = var2_2;
        this.size = var4_3;
        this.reference = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Class[] classArray;
        Class<?> clazz;
        Object object;
        block27: {
            block29: {
                Class[] classArray2;
                Class<?> clazz2;
                Throwable throwable222;
                int n2;
                Unsafe unsafe;
                boolean bl;
                block25: {
                    block26: {
                        javaVersion = MessageBuffer.a();
                        bl = false;
                        unsafe = null;
                        n2 = 16;
                        int n3 = 0;
                        try {
                            Class.forName("sun.misc.Unsafe");
                        }
                        catch (Throwable throwable222) {
                            break block25;
                        }
                        catch (Exception exception) {}
                        n3 = 1;
                        boolean bl2 = System.getProperty("java.runtime.name", "").toLowerCase(Locale.US).contains("android");
                        boolean bl3 = System.getProperty("com.google.appengine.runtime.version") != null;
                        bl = Boolean.parseBoolean(System.getProperty("msgpack.universal-buffer", "false")) || bl2 || bl3 || javaVersion < 7 || n3 == 0;
                        if (bl) break block26;
                        Field field = Unsafe.class.getDeclaredField("theUnsafe");
                        ((AccessibleObject)field).setAccessible(true);
                        unsafe = (Unsafe)field.get(null);
                        if (unsafe == null) throw new RuntimeException("Unsafe is unavailable");
                        Unsafe unsafe2 = unsafe;
                        n2 = unsafe2.arrayBaseOffset(byte[].class);
                        n3 = unsafe2.arrayIndexScale(byte[].class);
                        if (n3 == 1) break block26;
                        throw new IllegalStateException("Byte array index scale must be 1, but is " + n3);
                    }
                    MessageBuffer.unsafe = unsafe;
                    ARRAY_BYTE_BASE_OFFSET = n2;
                    isUniversalBuffer = bl;
                    Object object2 = isUniversalBuffer ? UNIVERSAL_MESSAGE_BUFFER : (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER);
                    if (!DEFAULT_MESSAGE_BUFFER.equals(object2)) {
                        Class[] classArray3;
                        Class<?> clazz3;
                        try {
                            Class<?> clazz4 = Class.forName((String)object2);
                            clazz3 = clazz4;
                            Class[] classArray4 = new Class[3];
                            classArray4[0] = byte[].class;
                            object2 = Integer.TYPE;
                            classArray4[1] = object2;
                            classArray4[2] = object2;
                            Constructor<?> constructor = clazz4.getDeclaredConstructor(classArray4);
                            ((AccessibleObject)constructor).setAccessible(true);
                            mbArrConstructor = constructor;
                            classArray3 = new Class[1];
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                            throw new RuntimeException(exception);
                        }
                        classArray3[0] = ByteBuffer.class;
                        Constructor<?> constructor = clazz3.getDeclaredConstructor(classArray3);
                        ((AccessibleObject)constructor).setAccessible(true);
                        mbBBConstructor = constructor;
                        return;
                    }
                    break block29;
                }
                MessageBuffer.unsafe = unsafe;
                ARRAY_BYTE_BASE_OFFSET = n2;
                isUniversalBuffer = bl;
                Object object3 = isUniversalBuffer ? UNIVERSAL_MESSAGE_BUFFER : (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER);
                if (DEFAULT_MESSAGE_BUFFER.equals(object3)) {
                    mbArrConstructor = null;
                    mbBBConstructor = null;
                    throw throwable222;
                }
                try {
                    Class<?> clazz5 = Class.forName((String)object3);
                    clazz2 = clazz5;
                    Class[] classArray5 = new Class[3];
                    classArray5[0] = byte[].class;
                    object3 = Integer.TYPE;
                    classArray5[1] = object3;
                    classArray5[2] = object3;
                    Constructor<?> constructor = clazz5.getDeclaredConstructor(classArray5);
                    ((AccessibleObject)constructor).setAccessible(true);
                    mbArrConstructor = constructor;
                    classArray2 = new Class[1];
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    throw new RuntimeException(exception);
                }
                classArray2[0] = ByteBuffer.class;
                Constructor<?> constructor = clazz2.getDeclaredConstructor(classArray2);
                ((AccessibleObject)constructor).setAccessible(true);
                mbBBConstructor = constructor;
                throw throwable222;
                catch (Exception exception) {}
                {
                    exception.printStackTrace(System.err);
                    MessageBuffer.unsafe = unsafe;
                    ARRAY_BYTE_BASE_OFFSET = n2;
                    isUniversalBuffer = true;
                    object = UNIVERSAL_MESSAGE_BUFFER;
                    if (!DEFAULT_MESSAGE_BUFFER.equals(object)) break block27;
                }
            }
            mbArrConstructor = null;
            mbBBConstructor = null;
            return;
        }
        try {
            Class<?> clazz6 = Class.forName((String)object);
            clazz = clazz6;
            Class[] classArray6 = new Class[3];
            classArray6[0] = byte[].class;
            object = Integer.TYPE;
            classArray6[1] = object;
            classArray6[2] = object;
            Constructor<?> constructor = clazz6.getDeclaredConstructor(classArray6);
            ((AccessibleObject)constructor).setAccessible(true);
            mbArrConstructor = constructor;
            classArray = new Class[1];
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RuntimeException(exception);
        }
        classArray[0] = ByteBuffer.class;
        Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
        ((AccessibleObject)constructor).setAccessible(true);
        mbBBConstructor = constructor;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public MessageBuffer slice(int offset, int length) {
        void var1_1;
        void var2_2;
        if (offset == 0 && var2_2 == this.size()) {
            return this;
        }
        p.a(var1_1 + var2_2 <= this.size());
        return new MessageBuffer(this.base, this.address + (long)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(int index) {
        void var1_1;
        return unsafe.getByte(this.base, this.address + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(int index) {
        void var1_1;
        return unsafe.getBoolean(this.base, this.address + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public short getShort(int index) {
        void var1_1;
        return Short.reverseBytes(unsafe.getShort(this.base, this.address + (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(int index) {
        void var1_1;
        return Integer.reverseBytes(unsafe.getInt(this.base, this.address + (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(int index) {
        void var1_1;
        return Float.intBitsToFloat(this.getInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(int index) {
        void var1_1;
        return Long.reverseBytes(unsafe.getLong(this.base, this.address + (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(int index) {
        void var1_1;
        return Double.longBitsToDouble(this.getLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void getBytes(int index, byte[] dst, int dstOffset, int length) {
        void var2_2;
        void var4_5;
        void var3_3;
        void var1_1;
        MessageBuffer messageBuffer = object;
        Object object = messageBuffer.base;
        long l2 = messageBuffer.address + (long)var1_1;
        long l3 = ARRAY_BYTE_BASE_OFFSET + var3_3;
        long l4 = (long)var4_5;
        unsafe.copyMemory(object, l2, var2_2, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public void getBytes(int index, int len, ByteBuffer dst) {
        void var2_2;
        if (dst.remaining() >= var2_2) {
            void var1_1;
            void var3_3;
            var3_3.put(this.sliceAsByteBuffer((int)var1_1, (int)var2_2));
            return;
        }
        throw new BufferOverflowException();
    }

    /*
     * WARNING - void declaration
     */
    public void putByte(int index, byte v2) {
        void var2_2;
        void var1_1;
        unsafe.putByte(this.base, this.address + (long)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putBoolean(int index, boolean v2) {
        void var2_2;
        void var1_1;
        unsafe.putBoolean(this.base, this.address + (long)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putShort(int index, short v2) {
        void var1_1;
        short s2 = Short.reverseBytes(v2);
        unsafe.putShort(this.base, this.address + (long)var1_1, s2);
    }

    /*
     * WARNING - void declaration
     */
    public void putInt(int index, int v2) {
        void var1_1;
        int n2 = Integer.reverseBytes(v2);
        unsafe.putInt(this.base, this.address + (long)var1_1, n2);
    }

    /*
     * WARNING - void declaration
     */
    public void putFloat(int index, float v2) {
        void var2_2;
        void var1_1;
        this.putInt((int)var1_1, Float.floatToRawIntBits((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void putLong(int index, long l2) {
        void var1_1;
        long l3 = Long.reverseBytes(l2);
        unsafe.putLong(this.base, this.address + (long)var1_1, l3);
    }

    /*
     * WARNING - void declaration
     */
    public void putDouble(int index, double v2) {
        void var1_1;
        void var2_2;
        long l2 = Double.doubleToRawLongBits((double)var2_2);
        this.putLong((int)var1_1, l2);
    }

    /*
     * WARNING - void declaration
     */
    public void putBytes(int index, byte[] src, int srcOffset, int length) {
        void var2_2;
        void var4_5;
        void var1_1;
        void var3_4;
        MessageBuffer messageBuffer = object;
        long l2 = ARRAY_BYTE_BASE_OFFSET + var3_4;
        Object object = messageBuffer.base;
        long l3 = messageBuffer.address + (long)var1_1;
        long l4 = (long)var4_5;
        unsafe.copyMemory(var2_2, l2, object, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public void putByteBuffer(int index, ByteBuffer src, int len) {
        void var2_4;
        if (len <= var2_4.remaining()) {
            if (!isUniversalBuffer) {
                int n2;
                void var1_1;
                Object object;
                if (var2_4.isDirect()) {
                    void v0 = var2_4;
                    MessageBuffer messageBuffer = object;
                    long l2 = a.b(var2_4) + (long)var2_4.position();
                    object = messageBuffer.base;
                    long l3 = messageBuffer.address + (long)var1_1;
                    long l4 = n2;
                    unsafe.copyMemory(null, l2, object, l3, l4);
                    v0.position(v0.position() + n2);
                } else if (var2_4.hasArray()) {
                    void v2 = var2_4;
                    MessageBuffer messageBuffer = object;
                    long l5 = ARRAY_BYTE_BASE_OFFSET + var2_4.position();
                    object = messageBuffer.base;
                    long l6 = messageBuffer.address + (long)var1_1;
                    long l7 = n2;
                    unsafe.copyMemory(v2.array(), l5, object, l6, l7);
                    v2.position(v2.position() + n2);
                } else if (((MessageBuffer)object).hasArray()) {
                    var2_4.get((byte[])((MessageBuffer)object).base, (int)var1_1, n2);
                } else {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        MessageBuffer messageBuffer = object;
                        Object object2 = messageBuffer.base;
                        long l8 = messageBuffer.address + (long)var1_1;
                        byte by = var2_4.get();
                        unsafe.putByte(object2, l8, by);
                    }
                }
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    public void putMessageBuffer(int index, MessageBuffer src, int srcOffset, int len) {
        void var4_5;
        void var1_1;
        void var3_4;
        void var2_2;
        MessageBuffer messageBuffer = object;
        void v1 = var2_2;
        Object object = v1.base;
        long l2 = v1.address + (long)var3_4;
        Object object2 = messageBuffer.base;
        long l3 = messageBuffer.address + (long)var1_1;
        long l4 = (long)var4_5;
        unsafe.copyMemory(object, l2, object2, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer sliceAsByteBuffer(int index, int length) {
        void var2_2;
        void var1_1;
        if (this.hasArray()) {
            return ByteBuffer.wrap((byte[])this.base, (int)(this.address - (long)ARRAY_BYTE_BASE_OFFSET + (long)var1_1), (int)var2_2);
        }
        if (!isUniversalBuffer) {
            return a.a(this.address, (int)var1_1, (int)var2_2, this.reference);
        }
        throw new IllegalStateException();
    }

    public ByteBuffer sliceAsByteBuffer() {
        MessageBuffer messageBuffer = this;
        return messageBuffer.sliceAsByteBuffer(0, messageBuffer.size());
    }

    public boolean hasArray() {
        return this.base != null;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        MessageBuffer messageBuffer = this;
        Object object = messageBuffer.base;
        long l2 = messageBuffer.address;
        long l3 = ARRAY_BYTE_BASE_OFFSET;
        long l4 = this.size();
        unsafe.copyMemory(object, l2, byArray, l3, l4);
        return byArray;
    }

    public byte[] array() {
        return (byte[])this.base;
    }

    public int arrayOffset() {
        return (int)this.address - ARRAY_BYTE_BASE_OFFSET;
    }

    /*
     * WARNING - void declaration
     */
    public void copyTo(int index, MessageBuffer dst, int offset, int length) {
        void var4_5;
        void var3_4;
        void var1_1;
        void var2_3;
        void v0 = var2_3;
        MessageBuffer messageBuffer = object;
        Object object = messageBuffer.base;
        long l2 = messageBuffer.address + (long)var1_1;
        Object object2 = v0.base;
        long l3 = v0.address + (long)var3_4;
        long l4 = (long)var4_5;
        unsafe.copyMemory(object, l2, object2, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public String toHexString(int offset, int length) {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (void var4_4 = var1_1; var4_4 < var2_2; ++var4_4) {
            void var1_1;
            if (var4_4 != var1_1) {
                stringBuilder2.append(" ");
            }
            Byte by = this.getByte((int)var4_4);
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by;
            stringBuilder2.append(String.format("%02x", objectArray2));
        }
        return stringBuilder2.toString();
    }
}

