/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import com.batch.android.BatchPushReceiver;
import com.batch.android.PushNotificationType;
import com.batch.android.a.a;
import com.batch.android.d.k;
import com.batch.android.d.l;
import com.batch.android.d.m;
import com.batch.android.d.q;
import com.batch.android.d.s;
import com.batch.android.d.v;
import com.batch.android.d.x;
import com.batch.android.d.y;
import com.batch.android.f.c;
import com.batch.android.j;
import com.batch.android.json.JSONException;
import java.lang.reflect.Method;
import java.util.EnumSet;

@a
public class BatchPushService
extends IntentService {
    private static final String a = "com.batch.android.push.smallicon";
    private static final String b = "com.batch.android.push.color";
    private static final int c = -100;
    private static final String d = "push_already_shown";
    private static final int e = 20;
    public static final String BATCH_BUNDLE_KEY = "com.batch";

    public BatchPushService() {
        super("BatchPushService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleIntent(Intent intent) {
        try {
            Bundle bundle = intent.getExtras();
            if (bundle != null && !bundle.isEmpty() && m.a(this.getApplicationContext(), intent)) {
                x x2 = BatchPushService._pushDataFromIntent(intent);
                if (x2 == null) {
                    return;
                }
                if (com.batch.android.f.c.n().m()) {
                    q.c("Ignoring push cause manual display is activated");
                    return;
                }
                String string = intent.getStringExtra("msg");
                String string2 = intent.getStringExtra("title");
                if (string != null && !x2.b()) {
                    BatchPushService._handleNotificationPush((Context)this, bundle, string2, string, x2);
                }
            }
        }
        catch (Exception exception) {
            q.a("Error while handing notification", exception);
        }
        finally {
            BatchPushReceiver.completeWakefulIntent(intent);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void _handleNotificationPush(Context context, Bundle extras, String title, String alert, x batchData) throws JSONException {
        Object object;
        Integer n2;
        Object object2;
        Object object3;
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (!BatchPushService._isPushValid(context, batchData)) {
            return;
        }
        String string = batchData.f();
        int n3 = BatchPushService.a(context);
        if (n3 == -100) {
            q.c(false, "Batch.Push : Not showing notifications since notification type is NONE or does not contain ALERT");
            return;
        }
        if (title == null || title.length() == 0) {
            try {
                title = context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            catch (Exception exception) {
                q.a(false, "Batch.Push : Unable to find label of the application. Did you correctly set your application label in the manifest?");
                return;
            }
        }
        int n4 = applicationInfo.icon;
        Integer n5 = BatchPushService.c(context);
        if (n5 != null) {
            n4 = n5;
        } else {
            int n6 = com.batch.android.f.c.n().a();
            if (n6 != 0) {
                n4 = n6;
            }
        }
        if (n4 == 0) {
            q.a(false, "Batch.Push : Unable to find icon of the application. Did you correctly set your application icon in the manifest?");
            return;
        }
        Bitmap bitmap = com.batch.android.f.c.n().i();
        if (batchData.h()) {
            try {
                object3 = y.a(batchData.i());
                object2 = y.a(context, (String)object3);
                if (object2 == null && (object2 = new j(context, batchData.i(), batchData.j()).a()) != null) {
                    y.a(context, (String)object3, object2);
                }
                if (object2 != null) {
                    bitmap = BatchPushService.a(context, object2);
                } else {
                    q.a("Unable to download custom big image, fallback on default");
                    q.a(false, "Batch.Push : Unable to download large icon image sent via payload, fallback on default");
                }
            }
            catch (Exception exception) {
                q.a("Error while downloading custom big icon image", exception);
                q.a(false, "Batch.Push : Unable to download large icon image sent via payload, fallback on default");
            }
        }
        object3 = null;
        try {
            if (Build.VERSION.SDK_INT >= 16 && batchData.k()) {
                object2 = y.a(batchData.l());
                n2 = y.a(context, (String)object2);
                if (n2 == null && (n2 = new j(context, batchData.l(), batchData.m()).a()) != null) {
                    y.a(context, (String)object2, (Bitmap)n2);
                }
                if (n2 != null) {
                    object3 = n2;
                } else {
                    q.a("Unable to download custom big picture, fallback on default");
                    q.a(false, "Batch.Push : Unable to download large big picture image sent via payload, fallback on default");
                }
            }
        }
        catch (Exception exception) {
            q.a("Error while downloading custom big picture image", exception);
            q.a(false, "Batch.Push : Unable to download big picture image sent via payload, fallback on default");
        }
        int n7 = -1;
        n2 = BatchPushService.d(context);
        n7 = n2 != null ? n2.intValue() : com.batch.android.f.c.n().l();
        Intent intent = null;
        if (!batchData.c()) {
            intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        } else {
            try {
                if (batchData.d()) {
                    throw new NullPointerException("Received scheme is empty");
                }
                intent = new Intent("android.intent.action.VIEW", Uri.parse((String)batchData.e()));
            }
            catch (Exception exception) {
                q.a("Error while parsing custom scheme", exception);
                intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            }
        }
        BatchPushService._putPushExtraToIntent(extras, batchData, intent);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        int n8 = (int)(Math.random() * 2.147483647E9);
        Notification notification = null;
        if (l.a("android.support.v4.app.NotificationCompat")) {
            object = new NotificationCompat.Builder(context);
            object.setDefaults(n3);
            object.setWhen(System.currentTimeMillis());
            object.setTicker((CharSequence)alert);
            object.setContentTitle((CharSequence)title);
            object.setContentText((CharSequence)alert);
            object.setSmallIcon(n4);
            object.setContentIntent(pendingIntent);
            object.setOnlyAlertOnce(true);
            object.setAutoCancel(true);
            if (n7 != -1 && l.a(object, "setColor")) {
                object.setColor(n7);
            }
            if (bitmap != null) {
                object.setLargeIcon(bitmap);
            }
            if (object3 != null) {
                NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle((NotificationCompat.Builder)object);
                bigPictureStyle.bigPicture((Bitmap)object3);
                bigPictureStyle.setSummaryText((CharSequence)alert);
            } else {
                NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle((NotificationCompat.Builder)object);
                bigTextStyle.bigText((CharSequence)alert);
            }
            notification = object.build();
        } else if (Build.VERSION.SDK_INT >= 11) {
            object = new Notification.Builder(context);
            object.setWhen(System.currentTimeMillis());
            object.setDefaults(n3);
            object.setTicker((CharSequence)alert);
            object.setContentTitle((CharSequence)title);
            object.setContentText((CharSequence)alert);
            object.setSmallIcon(n4);
            object.setContentIntent(pendingIntent);
            object.setOnlyAlertOnce(true);
            object.setAutoCancel(true);
            if (bitmap != null) {
                object.setLargeIcon(bitmap);
            }
            if (n7 != -1 && Build.VERSION.SDK_INT >= 21) {
                object.setColor(n7);
            }
            if (Build.VERSION.SDK_INT >= 16) {
                if (object3 != null) {
                    Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle((Notification.Builder)object);
                    bigPictureStyle.bigPicture((Bitmap)object3);
                    bigPictureStyle.setSummaryText((CharSequence)alert);
                } else {
                    Notification.BigTextStyle bigTextStyle = new Notification.BigTextStyle((Notification.Builder)object);
                    bigTextStyle.bigText((CharSequence)alert);
                }
                notification = object.build();
            } else {
                notification = object.getNotification();
            }
        } else {
            q.b(false, "Batch.Push : Android support library is not available, fallback on deprecated notifications. More info at : https://batch.com/");
            notification = new Notification(n4, (CharSequence)alert, System.currentTimeMillis());
            try {
                object = notification.getClass().getMethod("setLatestEventInfo", Context.class, CharSequence.class, CharSequence.class, PendingIntent.class);
                ((Method)object).invoke((Object)notification, context, title, alert, pendingIntent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (l.a("android.support.v4.app.NotificationManagerCompat")) {
            object = NotificationManagerCompat.from((Context)context);
            object.notify(n8, notification);
        } else {
            object = (NotificationManager)context.getSystemService("notification");
            object.notify(n8, notification);
        }
        BatchPushService._markPushIdAsShown(context, string);
    }

    public static boolean _isPushValid(Context context, x batchData) {
        String string = batchData.f();
        if (string != null && BatchPushService.a(context, string)) {
            q.b("Already shown notification[" + string + "], aborting");
            return false;
        }
        String string2 = batchData.g();
        if (string2 != null && !BatchPushService.b(context, string2)) {
            q.b("Received notification[" + string + "] for another install id[" + string2 + "], aborting");
            return false;
        }
        return true;
    }

    @TargetApi(value=11)
    private static Bitmap a(Context context, Bitmap bitmap) {
        int n2 = 0;
        int n3 = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            Resources resources = context.getResources();
            n2 = (int)resources.getDimension(17104902);
            n3 = (int)resources.getDimension(0x1050005);
        } else {
            n2 = l.b(24, context);
            n3 = l.b(24, context);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n3, (int)n2, (boolean)false);
    }

    private static int a(Context context) {
        int n2 = 0;
        String string = v.a(context).a("push.notiftype");
        if (string != null) {
            try {
                EnumSet<PushNotificationType> enumSet = PushNotificationType.fromValue(Integer.parseInt(string));
                if (enumSet.size() == 1 && enumSet.contains((Object)PushNotificationType.NONE) || !enumSet.contains((Object)PushNotificationType.ALERT)) {
                    return -100;
                }
                if (enumSet.contains((Object)PushNotificationType.VIBRATE)) {
                    n2 |= 2;
                }
                if (enumSet.contains((Object)PushNotificationType.SOUND)) {
                    n2 |= 1;
                }
                if (enumSet.contains((Object)PushNotificationType.LIGHTS)) {
                    n2 |= 4;
                }
            }
            catch (Exception exception) {
                q.a("Error while reading notification types. Fallback on ALL", exception);
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static boolean a(Context context, String string) {
        return BatchPushService.b(context).contains(string);
    }

    public static void _markPushIdAsShown(Context context, String pushId) {
        k<String> k2 = BatchPushService.b(context);
        k2.add(pushId);
        if (!s.a(context).a(d, k2)) {
            q.a("Error while saving already shown push ids");
        }
    }

    private static k<String> b(Context context) {
        k k2 = null;
        try {
            Object object = s.a(context).b(d);
            if (object != null) {
                k2 = (k)object;
            }
        }
        catch (Exception exception) {
            q.a("Error while reading stored ids", exception);
        }
        if (k2 == null) {
            k2 = new k(20);
        }
        return k2;
    }

    private static boolean b(Context context, String string) {
        String string2 = new com.batch.android.k(context).a();
        return string.equals(string2);
    }

    private static Integer c(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(a);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            q.a("Error while parsing small icon meta data", exception);
        }
        return null;
    }

    private static Integer d(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(b);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            q.a("Error while parsing small icon meta data", exception);
        }
        return null;
    }

    public static void _putPushExtraToIntent(Bundle fullPayload, x batchData, Intent launchIntent) {
        launchIntent.putExtra("fromPush", true);
        if (fullPayload != null && !fullPayload.isEmpty()) {
            launchIntent.putExtra("batchPushPayload", fullPayload);
        }
        if (batchData.f() != null) {
            launchIntent.putExtra("pushId", batchData.f());
        }
    }

    public static x _pushDataFromIntent(Intent intent) {
        String string;
        Bundle bundle = intent.getExtras();
        if (bundle != null && !bundle.isEmpty() && (string = bundle.getString(BATCH_BUNDLE_KEY)) != null) {
            return new x(string);
        }
        return null;
    }
}

