/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.batch.android.R;
import com.batch.android.o;

public class RoundedImageView
extends ImageView {
    private static final int b = -2;
    private static final int c = 0;
    private static final int d = 1;
    private static final int e = 2;
    public static final String TAG = "RoundedImageView";
    public static final float DEFAULT_RADIUS = 0.0f;
    public static final float DEFAULT_BORDER_WIDTH = 0.0f;
    public static final Shader.TileMode DEFAULT_TILE_MODE = Shader.TileMode.CLAMP;
    private static final ImageView.ScaleType[] f = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private float g = 0.0f;
    private float h = 0.0f;
    private ColorStateList i = ColorStateList.valueOf((int)-16777216);
    private boolean j = false;
    private boolean k = false;
    private Shader.TileMode l = DEFAULT_TILE_MODE;
    private Shader.TileMode m = DEFAULT_TILE_MODE;
    private int n;
    private Drawable o;
    private Drawable p;
    private ImageView.ScaleType q;

    public RoundedImageView(Context context) {
        super(context);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int n2;
        int n3;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ba_RoundedImageView, defStyle, 0);
        int n4 = typedArray.getInt(R.styleable.ba_RoundedImageView_android_scaleType, -1);
        if (n4 >= 0) {
            this.setScaleType(f[n4]);
        } else {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        this.g = typedArray.getDimensionPixelSize(R.styleable.ba_RoundedImageView_riv_corner_radius, -1);
        this.h = typedArray.getDimensionPixelSize(R.styleable.ba_RoundedImageView_riv_border_width, -1);
        if (this.g < 0.0f) {
            this.g = 0.0f;
        }
        if (this.h < 0.0f) {
            this.h = 0.0f;
        }
        this.i = typedArray.getColorStateList(R.styleable.ba_RoundedImageView_riv_border_color);
        if (this.i == null) {
            this.i = ColorStateList.valueOf((int)-16777216);
        }
        this.k = typedArray.getBoolean(R.styleable.ba_RoundedImageView_riv_mutate_background, false);
        this.j = typedArray.getBoolean(R.styleable.ba_RoundedImageView_riv_oval, false);
        int n5 = typedArray.getInt(R.styleable.ba_RoundedImageView_riv_tile_mode, -2);
        if (n5 != -2) {
            this.setTileModeX(RoundedImageView.a(n5));
            this.setTileModeY(RoundedImageView.a(n5));
        }
        if ((n3 = typedArray.getInt(R.styleable.ba_RoundedImageView_riv_tile_mode_x, -2)) != -2) {
            this.setTileModeX(RoundedImageView.a(n3));
        }
        if ((n2 = typedArray.getInt(R.styleable.ba_RoundedImageView_riv_tile_mode_y, -2)) != -2) {
            this.setTileModeY(RoundedImageView.a(n2));
        }
        this.b();
        this.a(true);
        typedArray.recycle();
    }

    private static Shader.TileMode a(int n2) {
        switch (n2) {
            case 0: {
                return Shader.TileMode.CLAMP;
            }
            case 1: {
                return Shader.TileMode.REPEAT;
            }
            case 2: {
                return Shader.TileMode.MIRROR;
            }
        }
        return null;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public ImageView.ScaleType getScaleType() {
        return this.q;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        assert (scaleType != null);
        if (this.q != scaleType) {
            this.q = scaleType;
            switch (scaleType) {
                case CENTER: 
                case CENTER_CROP: 
                case CENTER_INSIDE: 
                case FIT_CENTER: 
                case FIT_START: 
                case FIT_END: 
                case FIT_XY: {
                    super.setScaleType(ImageView.ScaleType.FIT_XY);
                    break;
                }
                default: {
                    super.setScaleType(scaleType);
                }
            }
            this.b();
            this.a(false);
            this.invalidate();
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        this.n = 0;
        this.o = com.batch.android.o.a(drawable2);
        this.b();
        super.setImageDrawable(this.o);
    }

    public void setImageBitmap(Bitmap bm) {
        this.n = 0;
        this.o = com.batch.android.o.a(bm);
        this.b();
        super.setImageDrawable(this.o);
    }

    public void setImageResource(int resId) {
        if (this.n != resId) {
            this.n = resId;
            this.o = this.a();
            this.b();
            super.setImageDrawable(this.o);
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.setImageDrawable(this.getDrawable());
    }

    private Drawable a() {
        Resources resources = this.getResources();
        if (resources == null) {
            return null;
        }
        Drawable drawable2 = null;
        if (this.n != 0) {
            try {
                drawable2 = resources.getDrawable(this.n);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)("Unable to find resource: " + this.n), (Throwable)exception);
                this.n = 0;
            }
        }
        return com.batch.android.o.a(drawable2);
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    private void b() {
        this.a(this.o);
    }

    private void a(boolean bl) {
        if (this.k) {
            if (bl) {
                this.p = com.batch.android.o.a(this.p);
            }
            this.a(this.p);
        }
    }

    private void a(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        if (drawable2 instanceof o) {
            ((o)drawable2).a(this.q).a(this.g).b(this.h).a(this.i).a(this.j).a(this.l).b(this.m);
        } else if (drawable2 instanceof LayerDrawable) {
            LayerDrawable layerDrawable = (LayerDrawable)drawable2;
            int n2 = layerDrawable.getNumberOfLayers();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.a(layerDrawable.getDrawable(i2));
            }
        }
    }

    @Deprecated
    public void setBackgroundDrawable(Drawable background) {
        this.p = background;
        this.a(true);
        super.setBackgroundDrawable(this.p);
    }

    public float getCornerRadius() {
        return this.g;
    }

    public void setCornerRadius(int resId) {
        this.setCornerRadius(this.getResources().getDimension(resId));
    }

    public void setCornerRadius(float radius) {
        if (this.g == radius) {
            return;
        }
        this.g = radius;
        this.b();
        this.a(false);
    }

    public float getBorderWidth() {
        return this.h;
    }

    public void setBorderWidth(int resId) {
        this.setBorderWidth(this.getResources().getDimension(resId));
    }

    public void setBorderWidth(float width) {
        if (this.h == width) {
            return;
        }
        this.h = width;
        this.b();
        this.a(false);
        this.invalidate();
    }

    public int getBorderColor() {
        return this.i.getDefaultColor();
    }

    public void setBorderColor(int color) {
        this.setBorderColor(ColorStateList.valueOf((int)color));
    }

    public ColorStateList getBorderColors() {
        return this.i;
    }

    public void setBorderColor(ColorStateList colors) {
        if (this.i.equals(colors)) {
            return;
        }
        this.i = colors != null ? colors : ColorStateList.valueOf((int)-16777216);
        this.b();
        this.a(false);
        if (this.h > 0.0f) {
            this.invalidate();
        }
    }

    public boolean isOval() {
        return this.j;
    }

    public void setOval(boolean oval) {
        this.j = oval;
        this.b();
        this.a(false);
        this.invalidate();
    }

    public Shader.TileMode getTileModeX() {
        return this.l;
    }

    public void setTileModeX(Shader.TileMode tileModeX) {
        if (this.l == tileModeX) {
            return;
        }
        this.l = tileModeX;
        this.b();
        this.a(false);
        this.invalidate();
    }

    public Shader.TileMode getTileModeY() {
        return this.m;
    }

    public void setTileModeY(Shader.TileMode tileModeY) {
        if (this.m == tileModeY) {
            return;
        }
        this.m = tileModeY;
        this.b();
        this.a(false);
        this.invalidate();
    }

    public boolean mutatesBackground() {
        return this.k;
    }

    public void mutateBackground(boolean mutate) {
        if (this.k == mutate) {
            return;
        }
        this.k = mutate;
        this.a(true);
        this.invalidate();
    }
}

