/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import com.batch.android.BatchPushReceiver;
import com.batch.android.PushNotificationType;
import com.batch.android.b.a;
import com.batch.android.e.k;
import com.batch.android.e.l;
import com.batch.android.e.m;
import com.batch.android.e.q;
import com.batch.android.e.s;
import com.batch.android.e.v;
import com.batch.android.e.x;
import com.batch.android.e.y;
import com.batch.android.g.d;
import com.batch.android.h;
import com.batch.android.j;
import java.util.EnumSet;
import org.json.JSONException;

@a
public class BatchPushService
extends IntentService {
    private static final String a = "com.batch.android.push.smallicon";
    private static final int b = -100;
    private static final String c = "push_already_shown";
    private static final int d = 20;
    private static final String e = "com.batch";

    public BatchPushService() {
        super("BatchPushService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleIntent(Intent intent) {
        try {
            Bundle bundle = intent.getExtras();
            if (bundle != null && !bundle.isEmpty() && m.a(this.getApplicationContext(), intent)) {
                x x2 = BatchPushService._pushDataFromIntent(intent);
                if (x2 == null) {
                    return;
                }
                if (com.batch.android.g.d.n().m()) {
                    q.c("Ignoring push cause manual display is activated");
                    return;
                }
                String string = intent.getStringExtra("msg");
                String string2 = intent.getStringExtra("title");
                if (string != null && !x2.b()) {
                    BatchPushService._handleNotificationPush((Context)this, string2, string, x2);
                }
            }
        }
        catch (Exception exception) {
            q.a("Error while handing notification", exception);
        }
        finally {
            BatchPushReceiver.completeWakefulIntent(intent);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void _handleNotificationPush(Context context, String title, String alert, x batchData) throws JSONException {
        NotificationCompat.Builder builder;
        Bitmap bitmap;
        Object object;
        String string;
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (!BatchPushService._isPushValid(context, batchData)) {
            return;
        }
        String string2 = batchData.f();
        int n2 = BatchPushService.a(context);
        if (n2 == -100) {
            q.c(false, "Batch.Push : Not showing notifications since notification type is NONE or does not contain ALERT");
            return;
        }
        if (title == null || title.length() == 0) {
            try {
                title = context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            catch (Exception exception) {
                q.a(false, "Batch.Push : Unable to find label of the application. Did you correctly set your application label in the manifest?");
                return;
            }
        }
        int n3 = applicationInfo.icon;
        Integer n4 = BatchPushService.c(context);
        if (n4 != null) {
            n3 = n4;
        } else {
            int n5 = com.batch.android.g.d.n().a();
            if (n5 != 0) {
                n3 = n5;
            }
        }
        if (n3 == 0) {
            q.a(false, "Batch.Push : Unable to find icon of the application. Did you correctly set your application icon in the manifest?");
            return;
        }
        Bitmap bitmap2 = com.batch.android.g.d.n().h();
        if (batchData.h()) {
            try {
                string = y.a(batchData.i());
                object = y.a(context, string);
                if (object == null && (object = new h(context, batchData.i(), batchData.j()).b()) != null) {
                    y.a(context, string, object);
                }
                if (object != null) {
                    bitmap2 = BatchPushService.a(context, object);
                } else {
                    q.a("Unable to download custom big image, fallback on default");
                    q.a(false, "Batch.Push : Unable to download large icon image sent via payload, fallback on default");
                }
            }
            catch (Exception exception) {
                q.a("Error while downloading custom big icon image", exception);
                q.a(false, "Batch.Push : Unable to download large icon image sent via payload, fallback on default");
            }
        }
        string = null;
        try {
            if (Build.VERSION.SDK_INT >= 16 && batchData.k()) {
                object = y.a(batchData.l());
                bitmap = y.a(context, (String)object);
                if (bitmap == null && (bitmap = new h(context, batchData.l(), batchData.m()).b()) != null) {
                    y.a(context, (String)object, bitmap);
                }
                if (bitmap != null) {
                    string = bitmap;
                } else {
                    q.a("Unable to download custom big picture, fallback on default");
                    q.a(false, "Batch.Push : Unable to download large big picture image sent via payload, fallback on default");
                }
            }
        }
        catch (Exception exception) {
            q.a("Error while downloading custom big picture image", exception);
            q.a(false, "Batch.Push : Unable to download big picture image sent via payload, fallback on default");
        }
        int n6 = com.batch.android.g.d.n().l();
        bitmap = null;
        if (!batchData.c()) {
            bitmap = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        } else {
            try {
                if (batchData.d()) {
                    throw new NullPointerException("Received scheme is empty");
                }
                bitmap = new Intent("android.intent.action.VIEW", Uri.parse((String)batchData.e()));
            }
            catch (Exception exception) {
                q.a("Error while parsing custom scheme", exception);
                bitmap = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            }
        }
        BatchPushService._putPushExtraToIntent(batchData, (Intent)bitmap);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)bitmap, (int)0);
        int n7 = (int)(Math.random() * 2.147483647E9);
        Notification notification = null;
        if (l.a("android.support.v4.app.NotificationCompat")) {
            builder = new NotificationCompat.Builder(context);
            builder.setDefaults(n2);
            builder.setWhen(System.currentTimeMillis());
            builder.setTicker((CharSequence)alert);
            builder.setContentTitle((CharSequence)title);
            builder.setContentText((CharSequence)alert);
            builder.setSmallIcon(n3);
            builder.setContentIntent(pendingIntent);
            builder.setOnlyAlertOnce(true);
            builder.setAutoCancel(true);
            if (n6 != -1 && l.a(builder, "setColor")) {
                builder.setColor(n6);
            }
            if (bitmap2 != null) {
                builder.setLargeIcon(bitmap2);
            }
            if (string != null) {
                NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle(builder);
                bigPictureStyle.bigPicture((Bitmap)string);
                bigPictureStyle.setSummaryText((CharSequence)alert);
            } else {
                NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle(builder);
                bigTextStyle.bigText((CharSequence)alert);
            }
            notification = builder.build();
        } else if (Build.VERSION.SDK_INT >= 11) {
            builder = new Notification.Builder(context);
            builder.setWhen(System.currentTimeMillis());
            builder.setDefaults(n2);
            builder.setTicker((CharSequence)alert);
            builder.setContentTitle((CharSequence)title);
            builder.setContentText((CharSequence)alert);
            builder.setSmallIcon(n3);
            builder.setContentIntent(pendingIntent);
            builder.setOnlyAlertOnce(true);
            builder.setAutoCancel(true);
            if (bitmap2 != null) {
                builder.setLargeIcon(bitmap2);
            }
            if (n6 != -1 && Build.VERSION.SDK_INT >= 21) {
                builder.setColor(n6);
            }
            if (Build.VERSION.SDK_INT >= 16) {
                if (string != null) {
                    Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle((Notification.Builder)builder);
                    bigPictureStyle.bigPicture((Bitmap)string);
                    bigPictureStyle.setSummaryText((CharSequence)alert);
                } else {
                    Notification.BigTextStyle bigTextStyle = new Notification.BigTextStyle((Notification.Builder)builder);
                    bigTextStyle.bigText((CharSequence)alert);
                }
                notification = builder.build();
            } else {
                notification = builder.getNotification();
            }
        } else {
            q.b(false, "Batch.Push : Android support library is not available, fallback on deprecated notifications. More info at : https://batch.com/");
            notification = new Notification(n3, (CharSequence)alert, System.currentTimeMillis());
            notification.setLatestEventInfo(context, (CharSequence)title, (CharSequence)alert, pendingIntent);
        }
        if (l.a("android.support.v4.app.NotificationManagerCompat")) {
            builder = NotificationManagerCompat.from((Context)context);
            builder.notify(n7, notification);
        } else {
            builder = (NotificationManager)context.getSystemService("notification");
            builder.notify(n7, notification);
        }
        BatchPushService._markPushIdAsShown(context, string2);
    }

    public static boolean _isPushValid(Context context, x batchData) {
        String string = batchData.f();
        if (string != null && BatchPushService.a(context, string)) {
            q.b("Already shown notification[" + string + "], aborting");
            return false;
        }
        String string2 = batchData.g();
        if (string2 != null && !BatchPushService.b(context, string2)) {
            q.b("Received notification[" + string + "] for another install id[" + string2 + "], aborting");
            return false;
        }
        return true;
    }

    @TargetApi(value=11)
    private static Bitmap a(Context context, Bitmap bitmap) {
        int n2 = 0;
        int n3 = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            Resources resources = context.getResources();
            n2 = (int)resources.getDimension(17104902);
            n3 = (int)resources.getDimension(0x1050005);
        } else {
            n2 = l.b(24, context);
            n3 = l.b(24, context);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n3, (int)n2, (boolean)false);
    }

    private static int a(Context context) {
        int n2 = 0;
        String string = v.a(context).a("push.notiftype");
        if (string != null) {
            try {
                EnumSet<PushNotificationType> enumSet = PushNotificationType.fromValue(Integer.parseInt(string));
                if (enumSet.size() == 1 && enumSet.contains((Object)PushNotificationType.NONE) || !enumSet.contains((Object)PushNotificationType.ALERT)) {
                    return -100;
                }
                if (enumSet.contains((Object)PushNotificationType.VIBRATE)) {
                    n2 |= 2;
                }
                if (enumSet.contains((Object)PushNotificationType.SOUND)) {
                    n2 |= 1;
                }
                if (enumSet.contains((Object)PushNotificationType.LIGHTS)) {
                    n2 |= 4;
                }
            }
            catch (Exception exception) {
                q.a("Error while reading notification types. Fallback on ALL", exception);
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static boolean a(Context context, String string) {
        return BatchPushService.b(context).contains(string);
    }

    public static void _markPushIdAsShown(Context context, String pushId) {
        k<String> k2 = BatchPushService.b(context);
        k2.add(pushId);
        if (!s.a(context).a(c, k2)) {
            q.a("Error while saving already shown push ids");
        }
    }

    private static k<String> b(Context context) {
        k k2 = null;
        try {
            Object object = s.a(context).b(c);
            if (object != null) {
                k2 = (k)object;
            }
        }
        catch (Exception exception) {
            q.a("Error while reading stored ids", exception);
        }
        if (k2 == null) {
            k2 = new k(20);
        }
        return k2;
    }

    private static boolean b(Context context, String string) {
        String string2 = new j(context).a();
        return string.equals(string2);
    }

    private static Integer c(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(a);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            q.a("Error while parsing small icon meta data", exception);
        }
        return null;
    }

    public static void _putPushExtraToIntent(x batchData, Intent launchIntent) {
        launchIntent.putExtra("fromPush", true);
        launchIntent.putExtra("batchPushData", batchData.a());
        if (batchData.f() != null) {
            launchIntent.putExtra("pushId", batchData.f());
        }
    }

    public static x _pushDataFromIntent(Intent intent) {
        String string;
        Bundle bundle = intent.getExtras();
        if (bundle != null && !bundle.isEmpty() && (string = bundle.getString(e)) != null) {
            return new x(string);
        }
        return null;
    }
}

