/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import androidx.annotation.Keep;
import com.batch.android.json.JSONArray;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;

@Keep
public class JSONTokener {
    private final String in;
    private int pos;

    public JSONTokener(String in) {
        String string2;
        if (in != null && string2.startsWith("\ufeff")) {
            string2 = string2.substring(1);
        }
        this.in = string2;
    }

    private int nextCleanInternal() throws JSONException {
        while (this.pos < this.in.length()) {
            int n2 = this.pos;
            this.pos = n2 + 1;
            char c2 = this.in.charAt(n2);
            n2 = c2;
            if (c2 == '\t' || n2 == 10 || n2 == 13 || n2 == 32) continue;
            if (n2 != 35) {
                if (n2 != 47) {
                    return n2;
                }
                if (this.pos == this.in.length()) {
                    return n2;
                }
                char c3 = this.in.charAt(this.pos);
                if (c3 != '*') {
                    if (c3 != '/') {
                        return n2;
                    }
                    JSONTokener jSONTokener = this;
                    ++jSONTokener.pos;
                    jSONTokener.skipToEndOfLine();
                    continue;
                }
                JSONTokener jSONTokener = this;
                jSONTokener.pos = n2 = jSONTokener.pos + 1;
                if ((n2 = jSONTokener.in.indexOf("*/", n2)) != -1) {
                    this.pos = n2 + 2;
                    continue;
                }
                throw this.syntaxError("Unterminated comment");
            }
            this.skipToEndOfLine();
        }
        return -1;
    }

    private void skipToEndOfLine() {
        while (this.pos < this.in.length()) {
            char c2 = this.in.charAt(this.pos);
            if (c2 != '\r' && c2 != '\n') {
                ++this.pos;
                continue;
            }
            ++this.pos;
            break;
        }
    }

    private char readEscapeCharacter() throws JSONException {
        int c2 = this.pos;
        this.pos = c2 + 1;
        char string2 = this.in.charAt(c2);
        if (string2 != 'b') {
            if (string2 != 'f') {
                if (string2 != 'n') {
                    if (string2 != 'r') {
                        if (string2 != 't') {
                            if (string2 != 'u') {
                                return string2;
                            }
                            if (this.pos + 4 <= this.in.length()) {
                                int n2 = this.pos;
                                String string3 = this.in.substring(n2, n2 + 4);
                                this.pos += 4;
                                try {
                                    return (char)Integer.parseInt(string3, 16);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw this.syntaxError("Invalid escape sequence: " + string3);
                                }
                            }
                            throw this.syntaxError("Unterminated escape sequence");
                        }
                        return '\t';
                    }
                    return '\r';
                }
                return '\n';
            }
            return '\f';
        }
        return '\b';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readLiteral() throws JSONException {
        String string2 = this.nextToInternal("{}[]/\\:,=;# \t\f");
        if (string2.length() == 0) throw this.syntaxError("Expected literal value");
        if ("null".equalsIgnoreCase(string2)) {
            return JSONObject.NULL;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return Boolean.FALSE;
        }
        if (string2.indexOf(46) == -1) {
            long l2;
            int n2;
            String string3;
            int n3 = 10;
            if (!string2.startsWith("0x") && !string2.startsWith("0X")) {
                if (string2.startsWith("0") && string2.length() > 1) {
                    string3 = string2.substring(1);
                    n2 = 8;
                } else {
                    n2 = n3;
                    string3 = string2;
                }
            } else {
                string3 = string2.substring(2);
                n2 = 16;
            }
            try {
                l2 = Long.parseLong(string3, n2);
                if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) return l2;
            }
            catch (NumberFormatException numberFormatException) {}
            return (int)l2;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return new String(string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String nextToInternal(String excluded) {
        int n2 = this.pos;
        while (this.pos < this.in.length()) {
            void var1_1;
            char c2 = this.in.charAt(this.pos);
            if (c2 != '\r' && c2 != '\n' && var1_1.indexOf(c2) == -1) {
                ++this.pos;
                continue;
            }
            return this.in.substring(n2, this.pos);
        }
        return this.in.substring(n2);
    }

    private JSONObject readObject() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        int n2 = this.nextCleanInternal();
        if (n2 == 125) {
            return jSONObject2;
        }
        if (n2 != -1) {
            --this.pos;
        }
        do {
            Object object;
            if (!((object = this.nextValue()) instanceof String)) {
                if (object == null) {
                    throw this.syntaxError("Names cannot be null");
                }
                throw this.syntaxError("Names must be strings, but " + object + " is of type " + object.getClass().getName());
            }
            int n3 = this.nextCleanInternal();
            if (n3 != 58 && n3 != 61) {
                throw this.syntaxError("Expected ':' after " + object);
            }
            if (this.pos < this.in.length() && this.in.charAt(this.pos) == '>') {
                ++this.pos;
            }
            object = (String)object;
            jSONObject2.put((String)object, this.nextValue());
        } while ((n2 = this.nextCleanInternal()) == 44 || n2 == 59);
        if (n2 == 125) {
            return jSONObject2;
        }
        throw this.syntaxError("Unterminated object");
    }

    private JSONArray readArray() throws JSONException {
        int n2;
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        int n3 = 0;
        while ((n2 = this.nextCleanInternal()) != -1) {
            if (n2 != 44 && n2 != 59) {
                if (n2 != 93) {
                    JSONTokener jSONTokener = this;
                    --jSONTokener.pos;
                    jSONArray2.put(jSONTokener.nextValue());
                    n3 = this.nextCleanInternal();
                    if (n3 != 44 && n3 != 59) {
                        if (n3 == 93) {
                            return jSONArray2;
                        }
                        throw this.syntaxError("Unterminated array");
                    }
                    n3 = 1;
                    continue;
                }
                if (n3 != 0) {
                    jSONArray2.put(null);
                }
                return jSONArray2;
            }
            jSONArray2.put(null);
            n3 = 1;
        }
        throw this.syntaxError("Unterminated array");
    }

    public static int dehexchar(char hex) {
        char c2;
        if (hex >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return -1;
    }

    public Object nextValue() throws JSONException {
        int n2 = this.nextCleanInternal();
        if (n2 != -1) {
            if (n2 != 34 && n2 != 39) {
                if (n2 != 91) {
                    if (n2 != 123) {
                        JSONTokener jSONTokener = this;
                        --jSONTokener.pos;
                        return jSONTokener.readLiteral();
                    }
                    return this.readObject();
                }
                return this.readArray();
            }
            return this.nextString((char)n2);
        }
        throw this.syntaxError("End of input");
    }

    /*
     * WARNING - void declaration
     */
    public String nextString(char quote) throws JSONException {
        StringBuilder stringBuilder = null;
        int n2 = this.pos;
        while (this.pos < this.in.length()) {
            void var1_1;
            int n3 = this.pos;
            this.pos = n3 + 1;
            char c2 = this.in.charAt(n3);
            n3 = c2;
            if (c2 == var1_1) {
                if (stringBuilder == null) {
                    return new String(this.in.substring(n2, this.pos - 1));
                }
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.append(this.in, n2, this.pos - 1);
                return stringBuilder2.toString();
            }
            if (n3 != 92) continue;
            if (this.pos != this.in.length()) {
                if (stringBuilder == null) {
                    StringBuilder stringBuilder3;
                    stringBuilder = stringBuilder3;
                    stringBuilder3 = new StringBuilder();
                }
                stringBuilder.append(this.in, n2, this.pos - 1);
                stringBuilder.append(this.readEscapeCharacter());
                n2 = this.pos;
                continue;
            }
            throw this.syntaxError("Unterminated escape sequence");
        }
        throw this.syntaxError("Unterminated string");
    }

    /*
     * WARNING - void declaration
     */
    public JSONException syntaxError(String message) {
        void var1_1;
        return new JSONException((String)var1_1 + this);
    }

    public String toString() {
        return " at character " + this.pos + " of " + this.in;
    }

    public boolean more() {
        return this.pos < this.in.length();
    }

    public char next() {
        char c2;
        if (this.pos < this.in.length()) {
            int n2 = this.pos;
            this.pos = n2 + 1;
            c2 = this.in.charAt(n2);
        } else {
            c2 = '\u0000';
        }
        return c2;
    }

    /*
     * WARNING - void declaration
     */
    public char next(char c2) throws JSONException {
        void var1_1;
        char c3 = this.next();
        if (c3 == var1_1) {
            return c3;
        }
        throw this.syntaxError("Expected " + (char)var1_1 + " but was " + c3);
    }

    public char nextClean() throws JSONException {
        int n2 = this.nextCleanInternal();
        return n2 == -1 ? (char)'\u0000' : (char)n2;
    }

    /*
     * WARNING - void declaration
     */
    public String next(int length) throws JSONException {
        void var1_1;
        if (this.pos + var1_1 <= this.in.length()) {
            int n2 = this.pos;
            this.pos += var1_1;
            return this.in.substring(n2, n2 + var1_1);
        }
        throw this.syntaxError((int)var1_1 + " is out of bounds");
    }

    /*
     * WARNING - void declaration
     */
    public String nextTo(String excluded) {
        if (excluded != null) {
            void var1_1;
            return this.nextToInternal((String)var1_1).trim();
        }
        throw new NullPointerException("excluded == null");
    }

    /*
     * WARNING - void declaration
     */
    public String nextTo(char excluded) {
        void var1_1;
        return this.nextToInternal(String.valueOf((char)var1_1)).trim();
    }

    /*
     * WARNING - void declaration
     */
    public void skipPast(String thru) {
        void var1_1;
        int n2 = this.in.indexOf((String)var1_1, this.pos);
        int n3 = n2 == -1 ? this.in.length() : n2 + var1_1.length();
        this.pos = n3;
    }

    /*
     * WARNING - void declaration
     */
    public char skipTo(char to) {
        void var1_1;
        int n2 = this.in.indexOf((int)var1_1, this.pos);
        if (n2 != -1) {
            this.pos = n2;
            return (char)var1_1;
        }
        return '\u0000';
    }

    public void back() {
        if (--this.pos == -1) {
            this.pos = 0;
        }
    }
}

