/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import androidx.annotation.Keep;
import com.batch.android.json.JSON;
import com.batch.android.json.JSONArray;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONStringer;
import com.batch.android.json.JSONTokener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@Keep
public class JSONObject
implements Serializable {
    private static final Double NEGATIVE_ZERO = -0.0;
    public static final Object NULL = new Object(){

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o2) {
            void var1_1;
            return o2 == this || var1_1 == null;
        }

        public String toString() {
            return "null";
        }
    };
    private LinkedHashMap<String, Object> nameValuePairs;

    public JSONObject() {
        LinkedHashMap linkedHashMap;
        Serializable this_ = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1.nameValuePairs = this_;
    }

    public JSONObject(Map copyFrom) {
        this();
        for (Map.Entry entry : copyFrom.entrySet()) {
            String string2 = (String)entry.getKey();
            if (string2 != null) {
                ((AbstractMap)this.nameValuePairs).put(string2, JSONObject.wrap(entry.getValue()));
                continue;
            }
            throw new NullPointerException("key == null");
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(JSONTokener readFrom) throws JSONException {
        void var1_1;
        JSONObject jSONObject = this;
        jSONObject.readFromTokener((JSONTokener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(String json) throws JSONException {
        void var1_1;
        JSONTokener jSONTokener;
        JSONObject jSONObject = this_;
        JSONTokener this_ = jSONTokener;
        jSONTokener = new JSONTokener((String)var1_1);
        jSONObject(this_);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(JSONObject copyFrom, String[] names) throws JSONException {
        this();
        int n2 = names.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            void var2_2;
            void var5_5 = var2_2[i2];
            Object object = var1_1.opt((String)var5_5);
            if (object == null) continue;
            ((AbstractMap)this.nameValuePairs).put((String)var5_5, object);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(JSONObject copyFrom) throws JSONException {
        this();
        for (String string2 : copyFrom.keySet()) {
            void var1_1;
            Object object = var1_1.opt(string2);
            if (object == null) continue;
            ((AbstractMap)this.nameValuePairs).put(string2, object);
        }
    }

    private void readFromTokener(JSONTokener readFrom) throws JSONException {
        Object object = readFrom.nextValue();
        if (object instanceof JSONObject) {
            this.nameValuePairs = ((JSONObject)object).nameValuePairs;
            return;
        }
        throw JSON.typeMismatch(object, "JSONObject");
    }

    public static String numberToString(Number number) throws JSONException {
        if (number != null) {
            Number number2;
            Number number3 = number2;
            double d2 = number3.doubleValue();
            JSON.checkDouble(d2);
            if (number3.equals(NEGATIVE_ZERO)) {
                return "-0";
            }
            long l2 = number2.longValue();
            if (d2 == (double)l2) {
                return Long.toString(l2);
            }
            return number2.toString();
        }
        throw new JSONException("Number must be non-null");
    }

    public static String quote(String data) {
        JSONStringer jSONStringer;
        JSONStringer jSONStringer2;
        String string2;
        Object object;
        if (data == null) {
            return "\"\"";
        }
        try {
            string2 = object;
            jSONStringer = jSONStringer2;
            jSONStringer2 = new JSONStringer();
            object = JSONStringer.a.f;
        }
        catch (JSONException jSONException) {
            throw new AssertionError();
        }
        jSONStringer.open((JSONStringer.a)((Object)object), "");
        jSONStringer2.value(string2);
        Object object2 = object;
        jSONStringer2.close((JSONStringer.a)((Object)object2), (JSONStringer.a)((Object)object2), "");
        return jSONStringer2.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object wrap(Object o2) {
        Object object;
        if (o2 == null) {
            return NULL;
        }
        if (object instanceof JSONArray) return object;
        if (object instanceof JSONObject) {
            return object;
        }
        if (object.equals(NULL)) {
            return object;
        }
        try {
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            if (object instanceof Boolean) return object;
            if (object instanceof Byte) return object;
            if (object instanceof Character) return object;
            if (object instanceof Double) return object;
            if (object instanceof Float) return object;
            if (object instanceof Integer) return object;
            if (object instanceof Long) return object;
            if (object instanceof Short) return object;
            if (object instanceof String) {
                return object;
            }
            if (!object.getClass().getPackage().getName().startsWith("java.")) return null;
            return object.toString();
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        if ((this = ((JSONObject)this).toString()) != null) {
            void var1_1;
            var1_1.writeObject(this);
            return;
        }
        throw new IOException("Error while serializing JSONObject: NULL JSON string");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (object instanceof String) {
            try {
                this.readFromTokener(new JSONTokener((String)object));
                return;
            }
            catch (JSONException jSONException) {
                throw new IOException("Error while deserializing JSONObject: Bad JSON string", jSONException);
            }
        }
        throw new IOException("Error while deserializing JSONObject: unable to find JSON string");
    }

    public int length() {
        return ((AbstractMap)this.nameValuePairs).size();
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String name, boolean value) throws JSONException {
        void var2_2;
        void var1_1;
        JSONObject jSONObject = this_;
        String this_ = ((JSONObject)((Object)this_)).checkName((String)var1_1);
        ((AbstractMap)jSONObject.nameValuePairs).put(this_, (boolean)var2_2);
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String name, double value) throws JSONException {
        void var2_2;
        void var1_1;
        JSONObject jSONObject = this;
        ((AbstractMap)jSONObject.nameValuePairs).put(this.checkName((String)var1_1), JSON.checkDouble((double)var2_2));
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String name, int value) throws JSONException {
        void var2_2;
        void var1_1;
        JSONObject jSONObject = this_;
        String this_ = ((JSONObject)((Object)this_)).checkName((String)var1_1);
        ((AbstractMap)jSONObject.nameValuePairs).put(this_, (int)var2_2);
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String name, long value) throws JSONException {
        void var2_2;
        void var1_1;
        JSONObject jSONObject = this_;
        String this_ = ((JSONObject)((Object)this_)).checkName((String)var1_1);
        ((AbstractMap)jSONObject.nameValuePairs).put(this_, (long)var2_2);
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String name, Object value) throws JSONException {
        void var2_2;
        void var1_1;
        if (value == null) {
            JSONObject jSONObject = this;
            ((AbstractMap)jSONObject.nameValuePairs).remove(var1_1);
            return jSONObject;
        }
        if (var2_2 instanceof Number) {
            JSON.checkDouble(((Number)var2_2).doubleValue());
        }
        JSONObject jSONObject = this;
        ((AbstractMap)jSONObject.nameValuePairs).put(this.checkName((String)var1_1), var2_2);
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject putOpt(String name, Object value) throws JSONException {
        void var2_2;
        if (name != null && var2_2 != null) {
            void var1_1;
            return this.put((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject accumulate(String name, Object value) throws JSONException {
        void var2_2;
        void var1_1;
        Object object = this.nameValuePairs.get(this.checkName((String)var1_1));
        if (object == null) {
            return this.put((String)var1_1, var2_2);
        }
        if (object instanceof JSONArray) {
            ((JSONArray)object).checkedPut(var2_2);
        } else {
            JSONArray jSONArray;
            JSONArray jSONArray2 = jSONArray;
            jSONArray2();
            jSONArray2.checkedPut(object);
            jSONArray.checkedPut(var2_2);
            ((AbstractMap)this.nameValuePairs).put((String)var1_1, jSONArray2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject append(String name, Object value) throws JSONException {
        Object object;
        block4: {
            void var2_2;
            block3: {
                JSONArray jSONArray;
                Object object2;
                block2: {
                    object2 = this.nameValuePairs.get(this.checkName((String)object));
                    if (!(object2 instanceof JSONArray)) break block2;
                    object = (JSONArray)object2;
                    break block3;
                }
                if (object2 != null) break block4;
                object2 = jSONArray;
                jSONArray = new JSONArray();
                ((AbstractMap)this.nameValuePairs).put((String)object, object2);
                object = object2;
            }
            ((JSONArray)object).checkedPut(var2_2);
            return this;
        }
        throw new JSONException("Key " + (String)object + " is not a JSONArray");
    }

    /*
     * WARNING - void declaration
     */
    String checkName(String name) throws JSONException {
        if (name != null) {
            void var1_1;
            return var1_1;
        }
        throw new JSONException("Names must be non-null");
    }

    /*
     * WARNING - void declaration
     */
    public Object remove(String name) {
        void var1_1;
        return ((AbstractMap)this.nameValuePairs).remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNull(String name) {
        void var1_1;
        Object this_ = ((JSONObject)this_).nameValuePairs.get(var1_1);
        return this_ == null || this_ == NULL;
    }

    /*
     * WARNING - void declaration
     */
    public boolean has(String name) {
        void var1_1;
        return ((AbstractMap)this.nameValuePairs).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasNonNull(String name) {
        void var1_1;
        return this.has((String)var1_1) && !this.isNull((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object get(String name) throws JSONException {
        void var1_1;
        Object this_ = ((JSONObject)this_).nameValuePairs.get(var1_1);
        if (this_ != null) {
            return this_;
        }
        throw new JSONException("No value for " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object opt(String name) {
        void var1_1;
        return this.nameValuePairs.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(String name) throws JSONException {
        void var1_1;
        Boolean bl = JSON.toBoolean(this = ((JSONObject)this).get((String)var1_1));
        if (bl != null) {
            return bl;
        }
        throw JSON.typeMismatch(var1_1, this, "boolean");
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(String name) {
        void var1_1;
        return this.optBoolean((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(String name, boolean fallback) {
        boolean bl;
        void var1_1;
        if ((this = JSON.toBoolean(((JSONObject)this).opt((String)var1_1))) != null) {
            bl = (Boolean)this;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Boolean reallyOptBoolean(String name, Boolean fallback) {
        Object object;
        void var1_1;
        if ((this = (this = ((JSONObject)this).opt((String)var1_1)) != NULL ? JSON.toBoolean(this) : null) != null) {
            object = this;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(String name) throws JSONException {
        void var1_1;
        Double d2 = JSON.toDouble(this = ((JSONObject)this).get((String)var1_1));
        if (d2 != null) {
            return d2;
        }
        throw JSON.typeMismatch(var1_1, this, "double");
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(String name) {
        void var1_1;
        return this.optDouble((String)var1_1, Double.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(String name, double fallback) {
        double d2;
        void var1_1;
        if ((this = JSON.toDouble(((JSONObject)this).opt((String)var1_1))) != null) {
            d2 = (Double)this;
        }
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public Double reallyOptDouble(String name, Double fallback) {
        Object object;
        void var1_1;
        if ((this = (this = ((JSONObject)this).opt((String)var1_1)) != NULL ? JSON.toDouble(this) : null) != null) {
            object = this;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(String name) throws JSONException {
        void var1_1;
        Integer n2 = JSON.toInteger(this = ((JSONObject)this).get((String)var1_1));
        if (n2 != null) {
            return n2;
        }
        throw JSON.typeMismatch(var1_1, this, "int");
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(String name) {
        void var1_1;
        return this.optInt((String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(String name, int fallback) {
        int n2;
        void var1_1;
        if ((this = JSON.toInteger(((JSONObject)this).opt((String)var1_1))) != null) {
            n2 = (Integer)this;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public Integer reallyOptInteger(String name, Integer fallback) {
        Object object;
        void var1_1;
        if ((this = (this = ((JSONObject)this).opt((String)var1_1)) != NULL ? JSON.toInteger(this) : null) != null) {
            object = this;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(String name) throws JSONException {
        void var1_1;
        Long l2 = JSON.toLong(this = ((JSONObject)this).get((String)var1_1));
        if (l2 != null) {
            return l2;
        }
        throw JSON.typeMismatch(var1_1, this, "long");
    }

    /*
     * WARNING - void declaration
     */
    public Long reallyOptLong(String name, Long fallback) {
        Object object;
        void var1_1;
        if ((this = (this = ((JSONObject)this).opt((String)var1_1)) != NULL ? JSON.toLong(this) : null) != null) {
            object = this;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(String name) {
        void var1_1;
        return this.optLong((String)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(String name, long fallback) {
        long l2;
        void var1_1;
        if ((this = JSON.toLong(((JSONObject)this).opt((String)var1_1))) != null) {
            l2 = (Long)this;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public String getString(String name) throws JSONException {
        void var1_1;
        String string2 = JSON.toString(this = ((JSONObject)this).get((String)var1_1));
        if (string2 != null) {
            return string2;
        }
        throw JSON.typeMismatch(var1_1, this, "String");
    }

    /*
     * WARNING - void declaration
     */
    public String optString(String name) {
        void var1_1;
        return this.optString((String)var1_1, "");
    }

    /*
     * WARNING - void declaration
     */
    public String optString(String name, String fallback) {
        Object object;
        void var1_1;
        if ((this = JSON.toString(((JSONObject)this).opt((String)var1_1))) != null) {
            object = this;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public String reallyOptString(String name, String fallback) {
        Object object;
        void var1_1;
        if ((this = (this = ((JSONObject)this).opt((String)var1_1)) != NULL ? JSON.toString(this) : null) != null) {
            object = this;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray getJSONArray(String name) throws JSONException {
        void var1_1;
        if ((this = ((JSONObject)this).get((String)var1_1)) instanceof JSONArray) {
            return (JSONArray)this;
        }
        throw JSON.typeMismatch(var1_1, this, "JSONArray");
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray optJSONArray(String name) {
        void var1_1;
        return (this = ((JSONObject)this).opt((String)var1_1)) instanceof JSONArray ? (JSONArray)this : null;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getJSONObject(String name) throws JSONException {
        void var1_1;
        if ((this = ((JSONObject)this).get((String)var1_1)) instanceof JSONObject) {
            return (JSONObject)this;
        }
        throw JSON.typeMismatch(var1_1, this, "JSONObject");
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject optJSONObject(String name) {
        void var1_1;
        return (this = ((JSONObject)this).opt((String)var1_1)) instanceof JSONObject ? (JSONObject)this : null;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        void var1_1;
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (names == null) {
            return null;
        }
        int n2 = var1_1.length();
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            jSONArray2.put(this.opt(JSON.toString(var1_1.opt(i2))));
        }
        return jSONArray2;
    }

    public Iterator<String> keys() {
        return this.nameValuePairs.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.nameValuePairs.keySet();
    }

    public JSONArray names() {
        Object this_;
        if (((AbstractMap)((JSONObject)this_).nameValuePairs).isEmpty()) {
            this_ = null;
        } else {
            JSONArray jSONArray;
            JSONArray jSONArray2 = jSONArray;
            jSONArray = new JSONArray(new ArrayList<String>(((JSONObject)this_).nameValuePairs.keySet()));
            this_ = jSONArray2;
        }
        return this_;
    }

    public String toString() {
        JSONStringer jSONStringer;
        JSONObject jSONObject;
        try {
            jSONObject = this_;
        }
        catch (JSONException jSONException) {
            return null;
        }
        JSONStringer this_ = jSONStringer;
        jSONObject.writeTo(new JSONStringer());
        return this_.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int indentSpaces) throws JSONException {
        void var1_1;
        JSONStringer jSONStringer;
        JSONObject jSONObject = this_;
        JSONStringer this_ = jSONStringer;
        jSONObject.writeTo(new JSONStringer((int)var1_1));
        return this_.toString();
    }

    /*
     * WARNING - void declaration
     */
    void writeTo(JSONStringer stringer) throws JSONException {
        void var1_1;
        var1_1.object();
        for (Map.Entry entry : ((JSONObject)this).nameValuePairs.entrySet()) {
            var1_1.key((String)entry.getKey()).value(entry.getValue());
        }
        var1_1.endObject();
    }
}

