/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class FixedRatioRelativeLayout
extends RelativeLayout {
    private FixedType a = FixedType.HEIGHT;
    private double b = 1.0;

    public FixedRatioRelativeLayout(Context context) {
        super(context);
    }

    public FixedRatioRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FixedRatioRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setRatioType(FixedType type) {
        if (type == null) {
            throw new NullPointerException("type==null");
        }
        this.a = type;
    }

    public void setRatio(double ratio) {
        this.b = ratio;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int n3 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.a == FixedType.HEIGHT) {
            if (n2 < (int)((double)n3 * this.b)) {
                n3 = (int)((double)n3 * ((double)n2 / ((double)n3 * this.b)));
            } else {
                n2 = (int)((double)n3 * this.b);
            }
        } else if (n3 < (int)((double)n2 * this.b)) {
            n2 = (int)((double)n2 * ((double)n3 / ((double)n2 * this.b)));
        } else {
            n3 = (int)((double)n2 * this.b);
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.width = n2;
        layoutParams.height = n3;
        this.setLayoutParams(layoutParams);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n2, (int)View.MeasureSpec.getMode((int)widthMeasureSpec)), View.MeasureSpec.makeMeasureSpec((int)n3, (int)View.MeasureSpec.getMode((int)heightMeasureSpec)));
    }

    public static enum FixedType {
        HEIGHT,
        WIDTH;

    }
}

