/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import androidx.annotation.Keep;
import com.batch.android.json.JSON;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import com.batch.android.json.JSONStringer;
import com.batch.android.json.JSONTokener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@Keep
public class JSONArray {
    private final List<Object> values;

    public JSONArray() {
        ArrayList arrayList;
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        v1.values = this_;
    }

    public JSONArray(Collection copyFrom) {
        this();
        if (copyFrom != null) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                this.put(JSONObject.wrap(iterator.next()));
            }
        }
    }

    public JSONArray(JSONTokener readFrom) throws JSONException {
        Object object = readFrom.nextValue();
        if (object instanceof JSONArray) {
            this.values = ((JSONArray)object).values;
            return;
        }
        throw JSON.typeMismatch(object, "JSONArray");
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(String json) throws JSONException {
        void var1_1;
        JSONTokener jSONTokener;
        JSONArray jSONArray = this_;
        JSONTokener this_ = jSONTokener;
        jSONTokener = new JSONTokener((String)var1_1);
        jSONArray(this_);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(Object array) throws JSONException {
        void var1_1;
        if (array.getClass().isArray()) {
            ArrayList<Object> arrayList;
            int n2 = Array.getLength(var1_1);
            ArrayList<Object> arrayList2 = arrayList;
            arrayList = new ArrayList<Object>(n2);
            this.values = arrayList2;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.put(JSONObject.wrap(Array.get(var1_1, i2)));
            }
            return;
        }
        throw new JSONException("Not a primitive array: " + var1_1.getClass());
    }

    public int length() {
        return this.values.size();
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(boolean value) {
        void var1_1;
        JSONArray jSONArray = this;
        jSONArray.values.add((boolean)var1_1);
        return jSONArray;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(double value) throws JSONException {
        void var1_1;
        JSONArray jSONArray = this;
        jSONArray.values.add(JSON.checkDouble((double)var1_1));
        return jSONArray;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int value) {
        void var1_1;
        JSONArray jSONArray = this;
        jSONArray.values.add((int)var1_1);
        return jSONArray;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(long value) {
        void var1_1;
        JSONArray jSONArray = this;
        jSONArray.values.add((long)var1_1);
        return jSONArray;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(Object value) {
        void var1_1;
        JSONArray jSONArray = this;
        jSONArray.values.add(var1_1);
        return jSONArray;
    }

    /*
     * WARNING - void declaration
     */
    void checkedPut(Object value) throws JSONException {
        void var1_1;
        if (value instanceof Number) {
            JSON.checkDouble(((Number)var1_1).doubleValue());
        }
        this.put(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, boolean value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, (Object)((boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, double value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, (Object)((double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, int value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, (Object)((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, long value) throws JSONException {
        void var2_2;
        void var1_1;
        return this.put((int)var1_1, (Object)((long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, Object value) throws JSONException {
        void var1_1;
        void var2_2;
        if (value instanceof Number) {
            JSON.checkDouble(((Number)var2_2).doubleValue());
        }
        while (this.values.size() <= var1_1) {
            this.values.add(null);
        }
        JSONArray jSONArray = this;
        jSONArray.values.set((int)var1_1, var2_2);
        return jSONArray;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNull(int index) {
        void var1_1;
        return (this = ((JSONArray)this).opt((int)var1_1)) == null || this == JSONObject.NULL;
    }

    /*
     * WARNING - void declaration
     */
    public Object get(int index) throws JSONException {
        void var1_1;
        block3: {
            try {
                Object object = this.values.get((int)var1_1);
                if (object == null) break block3;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new JSONException("Index " + (int)var1_1 + " out of range [0.." + this.values.size() + ")");
            }
        }
        throw new JSONException("Value at " + (int)var1_1 + " is null.");
    }

    /*
     * WARNING - void declaration
     */
    public Object opt(int index) {
        void var1_1;
        if (index >= 0 && var1_1 < this.values.size()) {
            return this.values.get((int)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object remove(int index) {
        void var1_1;
        if (index >= 0 && var1_1 < this.values.size()) {
            return this.values.remove((int)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(int index) throws JSONException {
        void var1_1;
        Boolean bl = JSON.toBoolean(this = ((JSONArray)this).get((int)var1_1));
        if (bl != null) {
            return bl;
        }
        throw JSON.typeMismatch((int)var1_1, this, "boolean");
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(int index) {
        void var1_1;
        return this.optBoolean((int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(int index, boolean fallback) {
        boolean bl;
        void var1_1;
        if ((this = JSON.toBoolean(((JSONArray)this).opt((int)var1_1))) != null) {
            bl = (Boolean)this;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(int index) throws JSONException {
        void var1_1;
        Double d2 = JSON.toDouble(this = ((JSONArray)this).get((int)var1_1));
        if (d2 != null) {
            return d2;
        }
        throw JSON.typeMismatch((int)var1_1, this, "double");
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(int index) {
        void var1_1;
        return this.optDouble((int)var1_1, Double.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(int index, double fallback) {
        double d2;
        void var1_1;
        if ((this = JSON.toDouble(((JSONArray)this).opt((int)var1_1))) != null) {
            d2 = (Double)this;
        }
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(int index) throws JSONException {
        void var1_1;
        Integer n2 = JSON.toInteger(this = ((JSONArray)this).get((int)var1_1));
        if (n2 != null) {
            return n2;
        }
        throw JSON.typeMismatch((int)var1_1, this, "int");
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(int index) {
        void var1_1;
        return this.optInt((int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(int index, int fallback) {
        int n2;
        void var1_1;
        if ((this = JSON.toInteger(((JSONArray)this).opt((int)var1_1))) != null) {
            n2 = (Integer)this;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(int index) throws JSONException {
        void var1_1;
        Long l2 = JSON.toLong(this = ((JSONArray)this).get((int)var1_1));
        if (l2 != null) {
            return l2;
        }
        throw JSON.typeMismatch((int)var1_1, this, "long");
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(int index) {
        void var1_1;
        return this.optLong((int)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(int index, long fallback) {
        long l2;
        void var1_1;
        if ((this = JSON.toLong(((JSONArray)this).opt((int)var1_1))) != null) {
            l2 = (Long)this;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public String getString(int index) throws JSONException {
        void var1_1;
        String string2 = JSON.toString(this = ((JSONArray)this).get((int)var1_1));
        if (string2 != null) {
            return string2;
        }
        throw JSON.typeMismatch((int)var1_1, this, "String");
    }

    /*
     * WARNING - void declaration
     */
    public String optString(int index) {
        void var1_1;
        return this.optString((int)var1_1, "");
    }

    /*
     * WARNING - void declaration
     */
    public String optString(int index, String fallback) {
        void var1_1;
        if ((this_ = JSON.toString(((JSONArray)this_).opt((int)var1_1))) == null) {
            void var2_2;
            Object this_ = var2_2;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray getJSONArray(int index) throws JSONException {
        void var1_1;
        if ((this = ((JSONArray)this).get((int)var1_1)) instanceof JSONArray) {
            return (JSONArray)this;
        }
        throw JSON.typeMismatch((int)var1_1, this, "JSONArray");
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray optJSONArray(int index) {
        void var1_1;
        return (this = ((JSONArray)this).opt((int)var1_1)) instanceof JSONArray ? (JSONArray)this : null;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getJSONObject(int index) throws JSONException {
        void var1_1;
        if ((this = ((JSONArray)this).get((int)var1_1)) instanceof JSONObject) {
            return (JSONObject)this;
        }
        throw JSON.typeMismatch((int)var1_1, this, "JSONObject");
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject optJSONObject(int index) {
        void var1_1;
        return (this = ((JSONArray)this).opt((int)var1_1)) instanceof JSONObject ? (JSONObject)this : null;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        int n2 = Math.min(names.length(), this.values.size());
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            String string2 = JSON.toString(var1_1.opt(i2));
            jSONObject2.put(string2, this.opt(i2));
        }
        return jSONObject2;
    }

    /*
     * WARNING - void declaration
     */
    public String join(String separator) throws JSONException {
        JSONStringer jSONStringer;
        JSONStringer jSONStringer2 = jSONStringer;
        new JSONStringer().open(JSONStringer.a.f, "");
        int n2 = this.values.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                void var1_1;
                jSONStringer2.out.append((String)var1_1);
            }
            jSONStringer2.value(this.values.get(i2));
        }
        JSONStringer jSONStringer3 = jSONStringer2;
        JSONStringer.a a2 = JSONStringer.a.f;
        jSONStringer3.close(a2, a2, "");
        return jSONStringer3.out.toString();
    }

    public String toString() {
        JSONStringer jSONStringer;
        JSONArray jSONArray;
        try {
            jSONArray = this_;
        }
        catch (JSONException jSONException) {
            return null;
        }
        JSONStringer this_ = jSONStringer;
        jSONArray.writeTo(new JSONStringer());
        return this_.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int indentSpaces) throws JSONException {
        void var1_1;
        JSONStringer jSONStringer;
        JSONArray jSONArray = this_;
        JSONStringer this_ = jSONStringer;
        jSONArray.writeTo(new JSONStringer((int)var1_1));
        return this_.toString();
    }

    /*
     * WARNING - void declaration
     */
    void writeTo(JSONStringer stringer) throws JSONException {
        void var1_1;
        var1_1.array();
        Iterator<Object> this_ = ((JSONArray)((Object)this_)).values.iterator();
        while (this_.hasNext()) {
            var1_1.value(this_.next());
        }
        var1_1.endArray();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o2) {
        void var1_1;
        return o2 instanceof JSONArray && ((JSONArray)var1_1).values.equals(this.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

