/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.batch.android.BatchActionActivity;
import com.batch.android.BatchActionService;
import com.batch.android.BatchPushPayload;
import com.batch.android.i.a;
import com.batch.android.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@com.batch.android.a.a
public class BatchNotificationAction {
    public String label = "";
    public String drawableName;
    public String actionIdentifier = "";
    public JSONObject actionArguments;
    public boolean hasUserInterface = true;
    public boolean shouldDismissNotification = true;

    @NonNull
    public static List<NotificationCompat.Action> getSupportActions(@NonNull Context context, @NonNull List<BatchNotificationAction> batchActions, @Nullable BatchPushPayload pushPayload, @Nullable Integer notificationId) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        ArrayList<NotificationCompat.Action> arrayList = new ArrayList<NotificationCompat.Action>();
        if (batchActions == null || batchActions.size() == 0) {
            return arrayList;
        }
        int n2 = 0;
        for (BatchNotificationAction batchNotificationAction : batchActions) {
            PendingIntent pendingIntent;
            ++n2;
            Intent intent = new Intent(context, batchNotificationAction.hasUserInterface ? BatchActionActivity.class : BatchActionService.class);
            intent.setAction("com.batch.android.action.exec");
            intent.putExtra("actionID", batchNotificationAction.actionIdentifier);
            intent.putExtra("args", batchNotificationAction.actionArguments.toString());
            if (batchNotificationAction.shouldDismissNotification && notificationId != null) {
                intent.putExtra("dismissNotificationID", (Serializable)notificationId);
            }
            if (pushPayload != null) {
                pushPayload.writeToIntentExtras(intent);
            }
            if (batchNotificationAction.hasUserInterface) {
                intent.addFlags(0x10000000);
                pendingIntent = PendingIntent.getActivity((Context)context, (int)(n2 * (int)System.currentTimeMillis()), (Intent)intent, (int)0x40000000);
            } else {
                pendingIntent = PendingIntent.getService((Context)context, (int)(n2 * (int)System.currentTimeMillis()), (Intent)intent, (int)0x40000000);
            }
            arrayList.add(new NotificationCompat.Action.Builder(a.a(context, batchNotificationAction.drawableName), (CharSequence)batchNotificationAction.label, pendingIntent).build());
        }
        return arrayList;
    }
}

