/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.widget.RemoteViews;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.batch.android.Batch;
import com.batch.android.BatchActionActivity;
import com.batch.android.BatchLandingMessage;
import com.batch.android.BatchMessage;
import com.batch.android.BatchNotificationAction;
import com.batch.android.BatchNotificationChannelsManager;
import com.batch.android.BatchNotificationInterceptor;
import com.batch.android.BatchPushMessageDismissReceiver;
import com.batch.android.BatchPushPayload;
import com.batch.android.PushNotificationType;
import com.batch.android.c.aa;
import com.batch.android.c.ac;
import com.batch.android.c.aj;
import com.batch.android.c.f;
import com.batch.android.c.n;
import com.batch.android.c.r;
import com.batch.android.c.t;
import com.batch.android.c.x;
import com.batch.android.eventdispatcher.b;
import com.batch.android.i.h;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import com.batch.android.k.a.a;
import com.batch.android.messaging.c;
import com.batch.android.messaging.d;
import com.batch.android.p;
import com.batch.android.q;
import java.util.EnumSet;
import java.util.List;

public class g {
    private static final String a = "BatchPushNotificationPresenter";
    private static final String b = "com.batch.android.push.smallicon";
    private static final String c = "com.google.firebase.messaging.default_notification_icon";
    private static final String d = "com.batch.android.push.color";
    private static final int e = -100;

    static void a(Context context, Bundle bundle) throws com.batch.android.t {
        if (bundle != null && !bundle.isEmpty()) {
            BatchPushPayload batchPushPayload;
            try {
                batchPushPayload = BatchPushPayload.payloadFromReceiverExtras(bundle);
            }
            catch (BatchPushPayload.ParsingException | IllegalArgumentException exception) {
                return;
            }
            if (batchPushPayload == null) {
                return;
            }
            n n2 = batchPushPayload.a();
            if (n2 == null) {
                return;
            }
            h h2 = h.t();
            if (com.batch.android.i.g.a().a(context)) {
                r.b(a, "Ignoring push as Batch has been Opted Out from");
                return;
            }
            if (h2.q()) {
                r.e(a, "Ignoring push cause manual display is activated");
                return;
            }
            g.a(context, bundle, batchPushPayload, h2.l());
        }
    }

    private static void a(Context context) {
        Context context2 = context.getApplicationContext();
        try {
            aj.a(context2).a(new q(context2, new com.batch.android.p.a.a.c()));
        }
        catch (Exception exception) {
            r.d(a, "Can't refresh local campaigns. " + exception.toString());
        }
    }

    public static void a(Context context, Bundle bundle, BatchPushPayload batchPushPayload, BatchNotificationInterceptor batchNotificationInterceptor) throws com.batch.android.t {
        boolean bl;
        Notification notification;
        Object object;
        Object object2;
        Integer n2;
        Uri uri;
        Integer n3;
        Object object3;
        Object object4;
        String string2 = bundle.getString("msg");
        String string3 = bundle.getString("title");
        if (string2 == null) {
            r.e(a, "Not presenting a notification since it has no value for Batch.Push.ALERT_KEY");
            return;
        }
        n n4 = batchPushPayload.a();
        if (n4 == null) {
            r.e(a, "Not presenting a notification since we could not read batch's internal data");
            return;
        }
        if (n4.b()) {
            r.e(a, "Not presenting a notification since it is marked as silent");
            return;
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (!com.batch.android.f.a(context, n4)) {
            return;
        }
        if (g.a(context, bundle, n4)) {
            return;
        }
        Bundle bundle2 = null;
        if (batchNotificationInterceptor != null) {
            bundle2 = new Bundle(bundle);
        }
        String string4 = n4.g();
        int n5 = g.b(context);
        if (n5 == -100) {
            r.e(a, "Not showing notifications since notification type is NONE or does not contain ALERT");
            return;
        }
        if (string3 == null || string3.length() == 0) {
            try {
                string3 = context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            catch (Exception exception) {
                r.d(a, "Unable to find label of the application. Did you correctly set your application label in the manifest?");
                return;
            }
        }
        BatchNotificationChannelsManager batchNotificationChannelsManager = h.t().k();
        String string5 = batchNotificationChannelsManager.a(batchPushPayload);
        batchNotificationChannelsManager.a(context);
        int n6 = applicationInfo.icon;
        Integer n7 = g.c(context);
        if (n7 != null) {
            n6 = n7;
        } else {
            int n8 = h.t().a();
            if (n8 != 0) {
                n6 = n8;
            }
        }
        if (n6 == 0) {
            r.d(a, "Unable to find icon of the application. Did you correctly set your application icon in the manifest?");
            return;
        }
        Bitmap bitmap = h.t().j();
        if (n4.k()) {
            try {
                object4 = aa.a(n4.l());
                object3 = aa.a(context, (String)object4);
                if (object3 == null && (object3 = new com.batch.android.n(context, n4.l(), n4.m()).a()) != null) {
                    aa.a(context, (String)object4, object3);
                }
                if (object3 != null) {
                    bitmap = g.a(context, object3);
                } else {
                    r.d(a, "Unable to download large icon image sent via payload, fallback on default");
                }
            }
            catch (Exception exception) {
                r.e(a, "Error while downloading custom big icon image", exception);
                r.d(a, "Unable to download large icon image sent via payload, fallback on default");
            }
        }
        object4 = null;
        try {
            if (Build.VERSION.SDK_INT >= 16 && n4.n()) {
                object3 = aa.a(n4.o());
                n3 = aa.a(context, (String)object3);
                if (n3 == null && (n3 = new com.batch.android.n(context, n4.o(), n4.p()).a()) != null) {
                    aa.a(context, (String)object3, (Bitmap)n3);
                }
                if (n3 != null) {
                    object4 = n3;
                } else {
                    r.d(a, "Unable to download large big picture image sent via payload, fallback on default");
                }
            }
        }
        catch (Exception exception) {
            r.e(a, "Error while downloading custom big picture image", exception);
            r.d(a, "Unable to download big picture image sent via payload, fallback on default");
        }
        n3 = g.e(context);
        int n9 = n3 != null ? n3.intValue() : h.t().o();
        if (Build.VERSION.SDK_INT >= 21 && n9 == -1) {
            n9 = g.d(context);
        }
        if ((uri = h.t().p()) != null) {
            if ((n5 & 1) != 0) {
                n5 &= 0xFFFFFFFE;
            } else {
                uri = null;
            }
        }
        Intent intent = null;
        if (n4.d()) {
            try {
                if (n4.e()) {
                    throw new NullPointerException("Received scheme is empty");
                }
                intent = new Intent(context, BatchActionActivity.class);
                intent.addFlags(0x10000000);
                intent.putExtra("deeplink", n4.f());
                intent.setAction("batch_" + Long.toString(System.currentTimeMillis()));
            }
            catch (Exception exception) {
                r.d(a, "Error while parsing custom scheme", exception);
                intent = null;
            }
        }
        if (intent == null) {
            intent = f.a(context);
            if (intent == null) {
                r.d(a, "Batch could not detect the launch intent for the current package. Not displaying notification.");
                return;
            }
            n2 = h.t().b();
            if (n2 != null) {
                intent.addFlags(n2.intValue());
            }
        }
        p.a(bundle, n4, intent);
        n2 = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        int n10 = (int)(Math.random() * 2.147483647E9);
        if (batchNotificationInterceptor != null) {
            n10 = batchNotificationInterceptor.getPushNotificationId(context, n10, bundle2);
        }
        Intent intent2 = new Intent(context, BatchPushMessageDismissReceiver.class);
        p.a(bundle, n4, intent2);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context.getApplicationContext(), (int)n10, (Intent)intent2, (int)0);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setDefaults(n5);
        builder.setWhen(System.currentTimeMillis());
        builder.setTicker((CharSequence)string2);
        builder.setContentTitle((CharSequence)string3);
        builder.setContentText((CharSequence)string2);
        builder.setSmallIcon(n6);
        builder.setContentIntent((PendingIntent)n2);
        builder.setDeleteIntent(pendingIntent);
        builder.setOnlyAlertOnce(true);
        builder.setAutoCancel(true);
        builder.setVisibility(n4.w());
        if (uri != null) {
            builder.setSound(uri);
        }
        builder.setShowWhen(true);
        builder.setChannelId(string5);
        if (n9 != -1) {
            builder.setColor(n9);
        }
        n.a a2 = n4.x();
        a a3 = null;
        if (a2 == n.a.b) {
            if (com.batch.android.k.a.b.b()) {
                a3 = new com.batch.android.k.a.b(string3, string2, bitmap, (Bitmap)object4);
                r.e(a, "Using news format");
                if (!ac.a(builder)) {
                    r.e(a, "Cannot opt out of Smart Reply");
                }
            } else {
                r.e(a, "News format has been requested but is unsupported");
            }
        }
        if (a3 == null) {
            a3 = new com.batch.android.k.a.d(string3, string2, bitmap, (Bitmap)object4, n4.z());
        }
        g.a(context, a3, builder);
        List<BatchNotificationAction> list = batchPushPayload.getActions();
        if (list != null && list.size() > 0) {
            object2 = BatchNotificationAction.getSupportActions(context, list, batchPushPayload, n10);
            object = object2.iterator();
            while (object.hasNext()) {
                notification = (NotificationCompat.Action)object.next();
                builder.addAction((NotificationCompat.Action)notification);
            }
        }
        if ((object2 = n4.r()) != null && object2 != n.b.a) {
            builder.setPriority(((n.b)((Object)object2)).b());
        }
        if ((object = n4.u()) != null) {
            builder.setGroup((String)object);
            builder.setGroupSummary(n4.v());
        }
        if (batchNotificationInterceptor != null) {
            r.b(a, "Calling developer's Notification Interceptor implementation");
            try {
                builder = batchNotificationInterceptor.getPushNotificationCompatBuilder(context, builder, bundle2, n10);
                if (builder == null) {
                    r.b(a, "Aborting notification display: The push interceptor returned a null builder");
                    return;
                }
            }
            catch (RuntimeException runtimeException) {
                r.d(a, "Interceptor has thrown a runtime exception. Aborting notification display by rethrowing", runtimeException);
                throw new com.batch.android.t(runtimeException);
            }
        }
        notification = builder.build();
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context);
        notificationManagerCompat.notify("batch", n10, notification);
        String string6 = null;
        if (Build.VERSION.SDK_INT >= 26) {
            string6 = notification.getChannelId();
        }
        if (bl = t.a(context, string6)) {
            com.batch.android.i.d.b().a(context);
            b b2 = new b(batchPushPayload);
            com.batch.android.i.d.b().a(Batch.EventDispatcher.Type.NOTIFICATION_DISPLAY, b2);
        } else {
            r.b("Batch.Push: notification can't be displayed, skipping event dispatcher...");
        }
        com.batch.android.f.a(context, string4);
    }

    private static boolean a(Context context, Bundle bundle, n n2) {
        if (!com.batch.android.i.f.a().b()) {
            return false;
        }
        if (!com.batch.android.i.f.a().d(true)) {
            return false;
        }
        if (!com.batch.android.i.f.a().j()) {
            return false;
        }
        if (!com.batch.android.m.c.p().l()) {
            r.e(a, "Application is in background, not sending landing");
            return false;
        }
        JSONObject jSONObject = n2.j();
        if (jSONObject == null) {
            return false;
        }
        try {
            com.batch.android.messaging.d.g g2 = com.batch.android.messaging.c.b(jSONObject);
            if (g2 != null) {
                if (g2 instanceof com.batch.android.messaging.d.c) {
                    Activity activity = com.batch.android.m.c.p().c();
                    if (activity != null) {
                        context = activity;
                    } else {
                        return false;
                    }
                }
                com.batch.android.i.f.a().a(context, (BatchMessage)new BatchLandingMessage(bundle, jSONObject), false);
                com.batch.android.f.a(context, n2.g());
                return true;
            }
        }
        catch (JSONException | d exception) {
            r.d(a, "Error while parsing the messaging payload. Not forwarding to foreground.", exception);
        }
        return false;
    }

    private static Bitmap a(Context context, Bitmap bitmap) {
        int n2 = 0;
        int n3 = 0;
        Resources resources = context.getResources();
        n2 = (int)resources.getDimension(17104902);
        n3 = (int)resources.getDimension(0x1050005);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n3, (int)n2, (boolean)false);
    }

    private static int b(Context context) {
        int n2 = 0;
        String string2 = x.a(context).a("push.notiftype");
        if (string2 != null) {
            try {
                EnumSet<PushNotificationType> enumSet = PushNotificationType.fromValue(Integer.parseInt(string2));
                if (enumSet.size() == 1 && enumSet.contains((Object)PushNotificationType.NONE) || !enumSet.contains((Object)PushNotificationType.ALERT)) {
                    return -100;
                }
                if (enumSet.contains((Object)PushNotificationType.VIBRATE)) {
                    n2 |= 2;
                }
                if (enumSet.contains((Object)PushNotificationType.SOUND)) {
                    n2 |= 1;
                }
                if (enumSet.contains((Object)PushNotificationType.LIGHTS)) {
                    n2 |= 4;
                }
            }
            catch (Exception exception) {
                r.d(a, "Error while reading notification types. Fallback on ALL", exception);
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static Integer c(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(b);
                if (n2 != 0) {
                    return n2;
                }
                n2 = applicationInfo.metaData.getInt(c);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            r.d(a, "Error while parsing small icon meta data", exception);
        }
        return null;
    }

    @RequiresApi(api=21)
    private static int d(Context context) {
        TypedValue typedValue = new TypedValue();
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(context, context.getApplicationInfo().theme);
        Resources.Theme theme = contextThemeWrapper.getTheme();
        if (theme != null && theme.resolveAttribute(16843827, typedValue, true)) {
            return typedValue.data;
        }
        return -1;
    }

    private static Integer e(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(d);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            r.d(a, "Error while parsing small icon meta data", exception);
        }
        return null;
    }

    private static void a(@NonNull Context context, @NonNull com.batch.android.k.a.c c2, @NonNull NotificationCompat.Builder builder) {
        RemoteViews remoteViews;
        String string2 = context.getPackageName();
        try {
            remoteViews = c2.a(string2);
            if (remoteViews != null) {
                builder.setCustomContentView(remoteViews);
            }
            if ((remoteViews = c2.b(string2)) != null) {
                builder.setCustomBigContentView(remoteViews);
            }
        }
        catch (Exception exception) {
            r.d(a, "Tried to instantiate remote views for format, but failed", exception);
        }
        remoteViews = c2.a();
        if (remoteViews != null) {
            builder.setStyle((NotificationCompat.Style)remoteViews);
        }
        c2.a(builder);
    }
}

