/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import com.batch.android.BatchPushJobService;
import com.batch.android.BatchPushService;
import com.batch.android.a.a;
import com.batch.android.b.b;
import com.batch.android.c.o;
import com.batch.android.c.r;

@a
public class BatchPushMessageReceiver
extends b {
    public void onReceive(Context context, Intent intent) {
        block11: {
            if (intent == null) {
                r.a("BatchPushReceiver: null intent");
                return;
            }
            String string = intent.getStringExtra("message_type");
            if (string == null || "gcm".equalsIgnoreCase(string)) {
                if (Build.VERSION.SDK_INT >= 26) {
                    try {
                        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
                        if (jobScheduler == null) {
                            r.a("Could not get Job Scheduler system service");
                            return;
                        }
                        Bundle bundle = intent.getExtras();
                        if (bundle == null || bundle.isEmpty()) {
                            r.a("BatchPushReceiver: Intent extras were empty, not scheduling push notification presenter job");
                            return;
                        }
                        Bundle bundle2 = new Bundle();
                        bundle2.putBundle("com.batch.push_data", bundle);
                        JobInfo jobInfo = new JobInfo.Builder(o.a(context, jobScheduler), new ComponentName(context, BatchPushJobService.class)).setOverrideDeadline(3600000L).setTransientExtras(bundle2).build();
                        if (jobScheduler.schedule(jobInfo) == 0) {
                            r.a("Failed to schedule the push notification presenter job");
                            break block11;
                        }
                        r.c("Successfully scheduled the push notification presenter job");
                    }
                    catch (o.a a2) {
                        r.a("Could not find a suitable job ID", a2);
                    }
                    catch (Exception exception) {
                        r.a("Could schedule Batch push presentation job", exception);
                    }
                } else {
                    ComponentName componentName = new ComponentName(context.getPackageName(), BatchPushService.class.getName());
                    BatchPushMessageReceiver.startWakefulService(context, intent.setComponent(componentName));
                }
            } else {
                r.c("BatchPushReceiver: Intent was not a push message.");
            }
        }
    }
}

