/*
 * Decompiled with CFR 0.152.
 */
package com.bartoszlipinski.viewpropertyobjectanimator;

import android.animation.ValueAnimator;
import android.view.View;
import com.bartoszlipinski.viewpropertyobjectanimator.ChangeUpdateListener;

class ScrollChangeListener
extends ChangeUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    private ChangeUpdateListener.IntValues mScrollX;
    private ChangeUpdateListener.IntValues mScrollY;

    ScrollChangeListener(View view) {
        super(view);
    }

    private int currentScrollX() {
        return this.hasView() ? ((View)this.mView.get()).getScrollX() : 0;
    }

    private int currentScrollY() {
        return this.hasView() ? ((View)this.mView.get()).getScrollY() : 0;
    }

    public void scrollX(int scrollX) {
        this.mScrollX = new ChangeUpdateListener.IntValues(this, this.currentScrollX(), scrollX);
    }

    public void scrollXBy(int scrollXBy) {
        this.mScrollX = new ChangeUpdateListener.IntValues(this, this.currentScrollX(), this.currentScrollX() + scrollXBy);
    }

    public void scrollY(int scrollY) {
        this.mScrollY = new ChangeUpdateListener.IntValues(this, this.currentScrollY(), scrollY);
    }

    public void scrollYBy(int scrollYBy) {
        this.mScrollY = new ChangeUpdateListener.IntValues(this, this.currentScrollY(), this.currentScrollY() + scrollYBy);
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        if (this.hasView()) {
            float animatedFraction = valueAnimator.getAnimatedFraction();
            int scrollX = this.currentScrollX();
            int scrollY = this.currentScrollY();
            if (this.mScrollX != null) {
                scrollX = (int)this.calculateAnimatedValue(this.mScrollX.mFrom, this.mScrollX.mTo, animatedFraction);
            }
            if (this.mScrollY != null) {
                scrollY = (int)this.calculateAnimatedValue(this.mScrollY.mFrom, this.mScrollY.mTo, animatedFraction);
            }
            ((View)this.mView.get()).scrollTo(scrollX, scrollY);
        }
    }
}

