/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.type;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import java.util.HashMap;
import java.util.Map;

public class TypeRegistry {
    private final GlobalConfig globalConfig;
    private final Map<Integer, IColumnType> typeMap = new HashMap<Integer, IColumnType>();

    public TypeRegistry(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        this.typeMap.put(-2, DbColumnType.BYTE_ARRAY);
        this.typeMap.put(2004, DbColumnType.BYTE_ARRAY);
        this.typeMap.put(-4, DbColumnType.BYTE_ARRAY);
        this.typeMap.put(-3, DbColumnType.BYTE_ARRAY);
        this.typeMap.put(-6, DbColumnType.BYTE);
        this.typeMap.put(-5, DbColumnType.LONG);
        this.typeMap.put(-7, DbColumnType.BOOLEAN);
        this.typeMap.put(16, DbColumnType.BOOLEAN);
        this.typeMap.put(5, DbColumnType.SHORT);
        this.typeMap.put(1, DbColumnType.STRING);
        this.typeMap.put(2005, DbColumnType.STRING);
        this.typeMap.put(12, DbColumnType.STRING);
        this.typeMap.put(-1, DbColumnType.STRING);
        this.typeMap.put(-16, DbColumnType.STRING);
        this.typeMap.put(-15, DbColumnType.STRING);
        this.typeMap.put(2011, DbColumnType.STRING);
        this.typeMap.put(-9, DbColumnType.STRING);
        this.typeMap.put(91, DbColumnType.DATE);
        this.typeMap.put(93, DbColumnType.TIMESTAMP);
        this.typeMap.put(2014, DbColumnType.TIMESTAMP);
        this.typeMap.put(6, DbColumnType.DOUBLE);
        this.typeMap.put(7, DbColumnType.DOUBLE);
        this.typeMap.put(8, DbColumnType.DOUBLE);
        this.typeMap.put(4, DbColumnType.INTEGER);
        this.typeMap.put(2, DbColumnType.BIG_DECIMAL);
        this.typeMap.put(3, DbColumnType.BIG_DECIMAL);
    }

    public IColumnType getColumnType(TableField.MetaInfo metaInfo, DbColumnType defaultType) {
        int typeCode = metaInfo.getJdbcType().TYPE_CODE;
        switch (typeCode) {
            case -7: {
                return this.getBitType(metaInfo);
            }
            case 91: {
                return this.getDateType(metaInfo);
            }
            case 92: {
                return this.getTimeType(metaInfo);
            }
            case 2: 
            case 3: {
                return this.getNumber(metaInfo);
            }
            case 93: {
                return this.getTimestampType(metaInfo);
            }
        }
        return this.typeMap.getOrDefault(typeCode, defaultType);
    }

    public IColumnType getColumnType(TableField.MetaInfo metaInfo) {
        return this.getColumnType(metaInfo, DbColumnType.OBJECT);
    }

    private IColumnType getBitType(TableField.MetaInfo metaInfo) {
        if (metaInfo.getLength() > 1) {
            return DbColumnType.BYTE_ARRAY;
        }
        return DbColumnType.BOOLEAN;
    }

    private IColumnType getNumber(TableField.MetaInfo metaInfo) {
        if (metaInfo.getScale() > 0 || metaInfo.getLength() > 18) {
            return this.typeMap.get(metaInfo.getJdbcType().TYPE_CODE);
        }
        if (metaInfo.getLength() > 9) {
            return DbColumnType.LONG;
        }
        if (metaInfo.getLength() > 4) {
            return DbColumnType.INTEGER;
        }
        return DbColumnType.SHORT;
    }

    private IColumnType getDateType(TableField.MetaInfo metaInfo) {
        DbColumnType dbColumnType;
        DateType dateType = this.globalConfig.getDateType();
        switch (dateType) {
            case SQL_PACK: {
                dbColumnType = DbColumnType.DATE_SQL;
                break;
            }
            case TIME_PACK: {
                dbColumnType = DbColumnType.LOCAL_DATE;
                break;
            }
            default: {
                dbColumnType = DbColumnType.DATE;
            }
        }
        return dbColumnType;
    }

    private IColumnType getTimeType(TableField.MetaInfo metaInfo) {
        DateType dateType = this.globalConfig.getDateType();
        DbColumnType dbColumnType = dateType == DateType.TIME_PACK ? DbColumnType.LOCAL_TIME : DbColumnType.TIME;
        return dbColumnType;
    }

    private IColumnType getTimestampType(TableField.MetaInfo metaInfo) {
        DateType dateType = this.globalConfig.getDateType();
        DbColumnType dbColumnType = dateType == DateType.TIME_PACK ? DbColumnType.LOCAL_DATE_TIME : (dateType == DateType.ONLY_DATE ? DbColumnType.DATE : DbColumnType.TIMESTAMP);
        return dbColumnType;
    }
}

