/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.query;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.jdbc.DatabaseMetaDataWrapper;
import com.baomidou.mybatisplus.generator.query.AbstractDatabaseQuery;
import com.baomidou.mybatisplus.generator.type.ITypeConvertHandler;
import com.baomidou.mybatisplus.generator.type.TypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultQuery
extends AbstractDatabaseQuery {
    private final TypeRegistry typeRegistry;
    protected final DatabaseMetaDataWrapper databaseMetaDataWrapper;

    public DefaultQuery(@NotNull ConfigBuilder configBuilder) {
        super(configBuilder);
        this.typeRegistry = new TypeRegistry(configBuilder.getGlobalConfig());
        this.databaseMetaDataWrapper = new DatabaseMetaDataWrapper(this.dataSourceConfig.getConn(), this.dataSourceConfig.getSchemaName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TableInfo> queryTables() {
        try {
            boolean isInclude = !this.strategyConfig.getInclude().isEmpty();
            boolean isExclude = !this.strategyConfig.getExclude().isEmpty();
            ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
            List<DatabaseMetaDataWrapper.Table> tables = this.getTables();
            ArrayList<TableInfo> includeTableList = new ArrayList<TableInfo>();
            ArrayList<TableInfo> excludeTableList = new ArrayList<TableInfo>();
            tables.forEach(table -> {
                String tableName = table.getName();
                if (StringUtils.isNotBlank((CharSequence)tableName)) {
                    TableInfo tableInfo = new TableInfo(this.configBuilder, tableName);
                    tableInfo.setComment(table.getRemarks());
                    if (isInclude && this.strategyConfig.matchIncludeTable(tableName)) {
                        includeTableList.add(tableInfo);
                    } else if (isExclude && this.strategyConfig.matchExcludeTable(tableName)) {
                        excludeTableList.add(tableInfo);
                    }
                    tableList.add(tableInfo);
                }
            });
            this.filter(tableList, includeTableList, excludeTableList);
            tableList.forEach(this::convertTableFields);
            ArrayList<TableInfo> arrayList = tableList;
            return arrayList;
        }
        finally {
            this.databaseMetaDataWrapper.closeConnection();
        }
    }

    protected List<DatabaseMetaDataWrapper.Table> getTables() {
        String[] stringArray;
        boolean skipView = this.strategyConfig.isSkipView();
        String tableNamePattern = null;
        if (this.strategyConfig.getLikeTable() != null) {
            tableNamePattern = this.strategyConfig.getLikeTable().getValue();
        }
        if (this.strategyConfig.getNotLikeTable() != null) {
            this.LOGGER.warn("Unsupported 'notLikeTable' configuration");
        }
        if (skipView) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "TABLE";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "TABLE";
            stringArray = stringArray3;
            stringArray3[1] = "VIEW";
        }
        return this.databaseMetaDataWrapper.getTables(tableNamePattern, stringArray);
    }

    protected void convertTableFields(@NotNull TableInfo tableInfo) {
        String tableName = tableInfo.getName();
        Map<String, DatabaseMetaDataWrapper.Column> columnsInfoMap = this.getColumnsInfo(tableName);
        Entity entity = this.strategyConfig.entity();
        columnsInfoMap.forEach((k, columnInfo) -> {
            String columnName = columnInfo.getName();
            TableField field = new TableField(this.configBuilder, columnName);
            if (columnInfo.isPrimaryKey()) {
                field.primaryKey(columnInfo.isAutoIncrement());
                tableInfo.setHavePrimaryKey(true);
                if (field.isKeyIdentityFlag() && entity.getIdType() != null) {
                    this.LOGGER.warn("The primary key of the current table [{}] is configured as auto-incrementing, which will override the global primary key ID type strategy.", (Object)tableName);
                }
            }
            field.setColumnName(columnName).setComment(columnInfo.getRemarks());
            String propertyName = entity.getNameConvert().propertyNameConvert(field);
            TableField.MetaInfo metaInfo = new TableField.MetaInfo((DatabaseMetaDataWrapper.Column)columnInfo, tableInfo);
            ITypeConvertHandler typeConvertHandler = this.dataSourceConfig.getTypeConvertHandler();
            IColumnType columnType = typeConvertHandler != null ? typeConvertHandler.convert(this.globalConfig, this.typeRegistry, metaInfo) : this.typeRegistry.getColumnType(metaInfo);
            field.setPropertyName(propertyName, columnType);
            field.setMetaInfo(metaInfo);
            tableInfo.addField(field);
        });
        tableInfo.setIndexList(this.getIndex(tableName));
        tableInfo.processTable();
    }

    protected Map<String, DatabaseMetaDataWrapper.Column> getColumnsInfo(String tableName) {
        return this.databaseMetaDataWrapper.getColumnsInfo(tableName, true);
    }

    protected List<DatabaseMetaDataWrapper.Index> getIndex(String tableName) {
        return this.databaseMetaDataWrapper.getIndex(tableName);
    }
}

