/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.model;

import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.model.AnnotationAttributes;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ClassAnnotationAttributes
extends AnnotationAttributes {
    private Function<TableInfo, String> displayNameFunction;

    public ClassAnnotationAttributes(@NotNull Class<?> annotationClass) {
        super(annotationClass);
    }

    public ClassAnnotationAttributes(@NotNull Class<?> annotationClass, @NotNull Function<TableInfo, String> displayNameFunction, String ... extraPkg) {
        super(annotationClass);
        this.displayNameFunction = displayNameFunction;
        if (extraPkg != null && extraPkg.length > 0) {
            super.getImportPackages().addAll(Arrays.asList(extraPkg));
        }
    }

    public ClassAnnotationAttributes(@NotNull Class<?> annotationClass, @NotNull String displayName, String ... extraPkg) {
        super(annotationClass, displayName, extraPkg);
    }

    public ClassAnnotationAttributes(@NotNull String displayName, String ... importPackages) {
        super(displayName, importPackages);
    }

    public ClassAnnotationAttributes(@NotNull String importPackage, @NotNull Function<TableInfo, String> displayNameFunction) {
        super.getImportPackages().add(importPackage);
        this.displayNameFunction = displayNameFunction;
    }

    public ClassAnnotationAttributes(@NotNull Set<String> importPackages, @NotNull Function<TableInfo, String> displayNameFunction) {
        super.getImportPackages().addAll(importPackages);
        this.displayNameFunction = displayNameFunction;
    }

    public void handleDisplayName(TableInfo tableInfo) {
        if (this.displayNameFunction != null) {
            super.setDisplayName(this.displayNameFunction.apply(tableInfo));
        }
    }

    public void setDisplayNameFunction(Function<TableInfo, String> displayNameFunction) {
        this.displayNameFunction = displayNameFunction;
    }

    public Function<TableInfo, String> getDisplayNameFunction() {
        return this.displayNameFunction;
    }

    @Override
    public String toString() {
        return "ClassAnnotationAttributes(displayNameFunction=" + this.getDisplayNameFunction() + ")";
    }

    public ClassAnnotationAttributes() {
    }
}

