/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.handlers.AnnotationHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.DefaultTableAnnotationHandler;
import com.baomidou.mybatisplus.generator.DefaultTableFieldAnnotationHandler;
import com.baomidou.mybatisplus.generator.IFill;
import com.baomidou.mybatisplus.generator.ITableAnnotationHandler;
import com.baomidou.mybatisplus.generator.ITableFieldAnnotationHandler;
import com.baomidou.mybatisplus.generator.ITemplate;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.BaseBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.function.ConverterFileName;
import com.baomidou.mybatisplus.generator.model.AnnotationAttributes;
import com.baomidou.mybatisplus.generator.model.ClassAnnotationAttributes;
import com.baomidou.mybatisplus.generator.util.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entity
implements ITemplate {
    private final AnnotationHandler annotationHandler = new AnnotationHandler(){};
    private static final Logger LOGGER = LoggerFactory.getLogger(Entity.class);
    private String javaTemplate = "/templates/entity.java";
    private String kotlinTemplate = "/templates/entity.kt";
    private INameConvert nameConvert;
    private String superClass;
    private final Set<String> superEntityColumns = new HashSet<String>();
    private final Set<String> ignoreColumns = new HashSet<String>();
    private boolean serialVersionUID = true;
    private boolean serialAnnotation;
    private boolean columnConstant;
    private boolean chain;
    private boolean lombok;
    private boolean booleanColumnRemoveIsPrefix;
    private boolean tableFieldAnnotationEnable;
    private String versionColumnName;
    private String versionPropertyName;
    private String logicDeleteColumnName;
    private String logicDeletePropertyName;
    private final List<IFill> tableFillList = new ArrayList<IFill>();
    private NamingStrategy naming = NamingStrategy.underline_to_camel;
    private NamingStrategy columnNaming = null;
    private boolean activeRecord;
    private IdType idType;
    private ConverterFileName converterFileName = entityName -> entityName;
    private boolean fileOverride;
    private boolean generate = true;
    private boolean defaultLombok = true;
    private boolean toString = true;
    private boolean fieldUseJavaDoc = true;
    private final List<ClassAnnotationAttributes> classAnnotations = new ArrayList<ClassAnnotationAttributes>();
    private ITableAnnotationHandler tableAnnotationHandler = new DefaultTableAnnotationHandler();
    private ITableFieldAnnotationHandler tableFieldAnnotationHandler = new DefaultTableFieldAnnotationHandler();
    private Function<Set<String>, List<String>> importPackageFunction;
    private Function<List<? extends AnnotationAttributes>, List<AnnotationAttributes>> annotationAttributesFunction;

    private Entity() {
    }

    public void convertSuperEntityColumns(Class<?> clazz) {
        List fields = TableInfoHelper.getAllFields(clazz, (AnnotationHandler)this.annotationHandler);
        this.superEntityColumns.addAll(fields.stream().map(field -> {
            TableId tableId = (TableId)this.annotationHandler.getAnnotation(field, TableId.class);
            if (tableId != null && StringUtils.isNotBlank((CharSequence)tableId.value())) {
                return tableId.value();
            }
            TableField tableField = (TableField)this.annotationHandler.getAnnotation(field, TableField.class);
            if (tableField != null && StringUtils.isNotBlank((CharSequence)tableField.value())) {
                return tableField.value();
            }
            if (null == this.columnNaming || this.columnNaming == NamingStrategy.no_change) {
                return field.getName();
            }
            return StringUtils.camelToUnderline((String)field.getName());
        }).collect(Collectors.toSet()));
    }

    @NotNull
    public NamingStrategy getColumnNaming() {
        return Optional.ofNullable(this.columnNaming).orElse(this.naming);
    }

    public boolean matchSuperEntityColumns(String fieldName) {
        return this.superEntityColumns.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName));
    }

    public boolean matchIgnoreColumns(String fieldName) {
        return this.ignoreColumns.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName));
    }

    @NotNull
    public INameConvert getNameConvert() {
        return this.nameConvert;
    }

    @Nullable
    public String getSuperClass() {
        return this.superClass;
    }

    @Nullable
    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    @Nullable
    public String getVersionPropertyName() {
        return this.versionPropertyName;
    }

    @Nullable
    public String getLogicDeleteColumnName() {
        return this.logicDeleteColumnName;
    }

    @Nullable
    public String getLogicDeletePropertyName() {
        return this.logicDeletePropertyName;
    }

    @NotNull
    public List<IFill> getTableFillList() {
        return this.tableFillList;
    }

    @NotNull
    public NamingStrategy getNaming() {
        return this.naming;
    }

    @Nullable
    public IdType getIdType() {
        return this.idType;
    }

    @NotNull
    public ConverterFileName getConverterFileName() {
        return this.converterFileName;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull TableInfo tableInfo) {
        List<ClassAnnotationAttributes> classAnnotationAttributesList;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("idType", this.idType == null ? null : this.idType.toString());
        data.put("logicDeleteFieldName", this.logicDeleteColumnName);
        data.put("versionFieldName", this.versionColumnName);
        data.put("activeRecord", this.activeRecord);
        data.put("entitySerialVersionUID", this.serialVersionUID);
        data.put("entitySerialAnnotation", this.serialAnnotation);
        data.put("entityColumnConstant", this.columnConstant);
        data.put("entityBuilderModel", this.chain);
        data.put("chainModel", this.chain);
        data.put("entityLombokModel", this.lombok);
        data.put("entityBooleanColumnRemoveIsPrefix", this.booleanColumnRemoveIsPrefix);
        data.put("superEntityClass", ClassUtils.getSimpleName(this.superClass));
        HashSet<String> importPackages = new HashSet<String>(tableInfo.getImportPackages());
        ArrayList<ClassAnnotationAttributes> classAnnotationAttributes = new ArrayList<ClassAnnotationAttributes>(this.getClassAnnotations());
        if (this.tableAnnotationHandler != null && (classAnnotationAttributesList = this.tableAnnotationHandler.handle(tableInfo, this)) != null && !classAnnotationAttributesList.isEmpty()) {
            classAnnotationAttributes.addAll(classAnnotationAttributesList);
        }
        classAnnotationAttributes.forEach(attributes -> {
            attributes.handleDisplayName(tableInfo);
            importPackages.addAll(attributes.getImportPackages());
        });
        if (this.tableFieldAnnotationHandler != null) {
            tableInfo.getFields().forEach(tableField -> {
                List<AnnotationAttributes> annotationAttributes = this.tableFieldAnnotationHandler.handle(tableInfo, (com.baomidou.mybatisplus.generator.config.po.TableField)tableField);
                if (annotationAttributes != null && !annotationAttributes.isEmpty()) {
                    tableField.addAnnotationAttributesList(annotationAttributes, this.annotationAttributesFunction);
                    annotationAttributes.forEach(attributes -> importPackages.addAll(attributes.getImportPackages()));
                }
            });
        }
        data.put("entityFieldUseJavaDoc", this.fieldUseJavaDoc);
        data.put("entityClassAnnotations", this.annotationAttributesFunction != null ? this.annotationAttributesFunction.apply(classAnnotationAttributes) : classAnnotationAttributes.stream().sorted(Comparator.comparingInt(s -> s.getDisplayName().length())).collect(Collectors.toList()));
        data.put("importEntityPackages", this.importPackageFunction != null ? this.importPackageFunction.apply(importPackages) : importPackages.stream().sorted().collect(Collectors.toList()));
        Set javaPackages = importPackages.stream().filter(pkg -> pkg.startsWith("java")).collect(Collectors.toSet());
        data.put("importEntityJavaPackages", this.importPackageFunction != null ? this.importPackageFunction.apply(javaPackages) : javaPackages.stream().sorted().collect(Collectors.toList()));
        Set frameworkPackages = importPackages.stream().filter(pkg -> !pkg.startsWith("java")).collect(Collectors.toSet());
        data.put("importEntityFrameworkPackages", this.importPackageFunction != null ? this.importPackageFunction.apply(frameworkPackages) : frameworkPackages.stream().sorted().collect(Collectors.toList()));
        data.put("entityToString", this.toString);
        return data;
    }

    public String getJavaTemplate() {
        return this.javaTemplate;
    }

    public String getKotlinTemplate() {
        return this.kotlinTemplate;
    }

    public Set<String> getSuperEntityColumns() {
        return this.superEntityColumns;
    }

    public boolean isSerialVersionUID() {
        return this.serialVersionUID;
    }

    public boolean isSerialAnnotation() {
        return this.serialAnnotation;
    }

    public boolean isColumnConstant() {
        return this.columnConstant;
    }

    public boolean isChain() {
        return this.chain;
    }

    public boolean isLombok() {
        return this.lombok;
    }

    public boolean isBooleanColumnRemoveIsPrefix() {
        return this.booleanColumnRemoveIsPrefix;
    }

    public boolean isTableFieldAnnotationEnable() {
        return this.tableFieldAnnotationEnable;
    }

    public boolean isActiveRecord() {
        return this.activeRecord;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    public boolean isGenerate() {
        return this.generate;
    }

    public boolean isDefaultLombok() {
        return this.defaultLombok;
    }

    public boolean isToString() {
        return this.toString;
    }

    public boolean isFieldUseJavaDoc() {
        return this.fieldUseJavaDoc;
    }

    public List<ClassAnnotationAttributes> getClassAnnotations() {
        return this.classAnnotations;
    }

    public static class Builder
    extends BaseBuilder {
        private final Entity entity = new Entity();

        public Builder(StrategyConfig strategyConfig) {
            super(strategyConfig);
            this.entity.nameConvert = new INameConvert.DefaultNameConvert(strategyConfig);
        }

        public Builder nameConvert(INameConvert nameConvert) {
            this.entity.nameConvert = nameConvert;
            return this;
        }

        public Builder superClass(@NotNull Class<?> clazz) {
            return this.superClass(clazz.getName());
        }

        public Builder superClass(String superEntityClass) {
            this.entity.superClass = superEntityClass;
            return this;
        }

        public Builder disableSerialVersionUID() {
            this.entity.serialVersionUID = false;
            return this;
        }

        public Builder enableSerialAnnotation() {
            this.entity.serialAnnotation = true;
            return this;
        }

        public Builder enableColumnConstant() {
            this.entity.columnConstant = true;
            return this;
        }

        public Builder enableChainModel() {
            this.entity.chain = true;
            return this;
        }

        public Builder enableLombok() {
            this.entity.lombok = true;
            return this;
        }

        public Builder enableLombok(ClassAnnotationAttributes ... attributes) {
            this.entity.lombok = true;
            this.entity.defaultLombok = false;
            for (ClassAnnotationAttributes attribute : attributes) {
                this.addClassAnnotation(attribute);
            }
            return this;
        }

        public Builder enableRemoveIsPrefix() {
            this.entity.booleanColumnRemoveIsPrefix = true;
            return this;
        }

        public Builder enableTableFieldAnnotation() {
            this.entity.tableFieldAnnotationEnable = true;
            return this;
        }

        public Builder enableActiveRecord() {
            this.entity.activeRecord = true;
            return this;
        }

        public Builder versionColumnName(String versionColumnName) {
            this.entity.versionColumnName = versionColumnName;
            return this;
        }

        public Builder versionPropertyName(String versionPropertyName) {
            this.entity.versionPropertyName = versionPropertyName;
            return this;
        }

        public Builder logicDeleteColumnName(String logicDeleteColumnName) {
            this.entity.logicDeleteColumnName = logicDeleteColumnName;
            return this;
        }

        public Builder logicDeletePropertyName(String logicDeletePropertyName) {
            this.entity.logicDeletePropertyName = logicDeletePropertyName;
            return this;
        }

        public Builder naming(NamingStrategy namingStrategy) {
            this.entity.naming = namingStrategy;
            return this;
        }

        public Builder columnNaming(NamingStrategy namingStrategy) {
            this.entity.columnNaming = namingStrategy;
            return this;
        }

        public Builder addSuperEntityColumns(String ... superEntityColumns) {
            return this.addSuperEntityColumns(Arrays.asList(superEntityColumns));
        }

        public Builder addSuperEntityColumns(@NotNull List<String> superEntityColumnList) {
            this.entity.superEntityColumns.addAll(superEntityColumnList);
            return this;
        }

        public Builder addIgnoreColumns(String ... ignoreColumns) {
            return this.addIgnoreColumns(Arrays.asList(ignoreColumns));
        }

        public Builder addIgnoreColumns(@NotNull List<String> ignoreColumnList) {
            this.entity.ignoreColumns.addAll(ignoreColumnList);
            return this;
        }

        public Builder addTableFills(IFill ... tableFills) {
            return this.addTableFills(Arrays.asList(tableFills));
        }

        public Builder addTableFills(@NotNull List<IFill> tableFillList) {
            this.entity.tableFillList.addAll(tableFillList);
            return this;
        }

        public Builder idType(IdType idType) {
            this.entity.idType = idType;
            return this;
        }

        public Builder convertFileName(@NotNull ConverterFileName converter) {
            this.entity.converterFileName = converter;
            return this;
        }

        public Builder formatFileName(String format) {
            return this.convertFileName(entityName -> String.format(format, entityName));
        }

        @Deprecated
        public Builder fileOverride() {
            LOGGER.warn("fileOverride\u65b9\u6cd5\u540e\u7eed\u4f1a\u5220\u9664\uff0c\u66ff\u4ee3\u65b9\u6cd5\u4e3aenableFileOverride\u65b9\u6cd5");
            this.entity.fileOverride = true;
            return this;
        }

        public Builder enableFileOverride() {
            this.entity.fileOverride = true;
            return this;
        }

        public Builder javaTemplate(String template) {
            this.entity.javaTemplate = template;
            return this;
        }

        public Builder kotlinTemplatePath(String template) {
            this.entity.kotlinTemplate = template;
            return this;
        }

        public Builder disable() {
            this.entity.generate = false;
            return this;
        }

        public Builder addClassAnnotation(@NotNull ClassAnnotationAttributes attributes) {
            this.entity.classAnnotations.add(attributes);
            return this;
        }

        public Builder tableFieldAnnotationHandler(@NotNull ITableFieldAnnotationHandler tableFieldAnnotationHandler) {
            this.entity.tableFieldAnnotationHandler = tableFieldAnnotationHandler;
            return this;
        }

        public Builder tableAnnotationHandler(@NotNull ITableAnnotationHandler tableAnnotationHandler) {
            this.entity.tableAnnotationHandler = tableAnnotationHandler;
            return this;
        }

        public Builder toString(boolean toString) {
            this.entity.toString = toString;
            return this;
        }

        public Builder fieldUseJavaDoc(boolean fieldUseJavaDoc) {
            this.entity.fieldUseJavaDoc = fieldUseJavaDoc;
            return this;
        }

        public Builder importPackageFunction(Function<Set<String>, List<String>> importPackageFunction) {
            this.entity.importPackageFunction = importPackageFunction;
            return this;
        }

        public Builder annotationAttributesFunction(Function<List<? extends AnnotationAttributes>, List<AnnotationAttributes>> annotationAttributesFunction) {
            this.entity.annotationAttributesFunction = annotationAttributesFunction;
            return this;
        }

        public Entity get() {
            String superClass = this.entity.superClass;
            if (StringUtils.isNotBlank((CharSequence)superClass)) {
                this.tryLoadClass(superClass).ifPresent(this.entity::convertSuperEntityColumns);
            } else if (!this.entity.superEntityColumns.isEmpty()) {
                LOGGER.warn("Forgot to set entity supper class ?");
            }
            return this.entity;
        }

        private Optional<Class<?>> tryLoadClass(String className) {
            try {
                return Optional.of(ClassUtils.toClassConfident(className));
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
    }
}

