/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.ITableAnnotationHandler;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.model.ClassAnnotationAttributes;
import java.util.ArrayList;
import java.util.List;

public class DefaultTableAnnotationHandler
implements ITableAnnotationHandler {
    @Override
    public List<ClassAnnotationAttributes> handle(TableInfo tableInfo, Entity entity) {
        String displayName;
        boolean kotlin;
        ArrayList<ClassAnnotationAttributes> annotationAttributesList = new ArrayList<ClassAnnotationAttributes>();
        GlobalConfig globalConfig = tableInfo.getGlobalConfig();
        String comment = tableInfo.getComment();
        if (StringUtils.isBlank((CharSequence)comment)) {
            comment = "";
        }
        if (!(kotlin = globalConfig.isKotlin())) {
            if (entity.isChain() && entity.isLombok()) {
                annotationAttributesList.add(new ClassAnnotationAttributes("@Accessors(chain = true)", "lombok.experimental.Accessors"));
            }
            if (entity.isLombok() && entity.isDefaultLombok()) {
                annotationAttributesList.add(new ClassAnnotationAttributes("@Getter", "lombok.Getter"));
                annotationAttributesList.add(new ClassAnnotationAttributes("@Setter", "lombok.Setter"));
                if (entity.isToString()) {
                    annotationAttributesList.add(new ClassAnnotationAttributes("@ToString", "lombok.ToString"));
                }
            }
        }
        if (tableInfo.isConvert()) {
            String schemaName = tableInfo.getSchemaName();
            schemaName = StringUtils.isBlank((CharSequence)schemaName) ? "" : schemaName + ".";
            String displayName2 = String.format("@TableName(\"%s%s\")", schemaName, tableInfo.getName());
            annotationAttributesList.add(new ClassAnnotationAttributes(TableName.class, displayName2, new String[0]));
        }
        if (globalConfig.isSwagger()) {
            displayName = String.format("@ApiModel(value = \"%s\u5bf9\u8c61\", description = \"%s\")", tableInfo.getEntityName(), comment);
            annotationAttributesList.add(new ClassAnnotationAttributes(displayName, "io.swagger.annotations.ApiModel", "io.swagger.annotations.ApiModelProperty"));
        }
        if (globalConfig.isSpringdoc()) {
            displayName = String.format("@Schema(name = \"%s\", description = \"%s\")", tableInfo.getEntityName(), comment);
            annotationAttributesList.add(new ClassAnnotationAttributes(displayName, "io.swagger.v3.oas.annotations.media.Schema"));
        }
        return annotationAttributesList;
    }
}

