/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.mapper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.ibatis.session.ResultHandler;

public interface BaseMapper<T>
extends Mapper<T> {
    public int insert(T var1);

    public int deleteById(Serializable var1);

    public int deleteById(T var1);

    default public int deleteByMap(Map<String, Object> columnMap) {
        QueryWrapper qw = Wrappers.query();
        return this.delete((Wrapper)qw.allEq(columnMap));
    }

    public int delete(@Param(value="ew") Wrapper<T> var1);

    public int deleteBatchIds(@Param(value="coll") Collection<?> var1);

    public int updateById(@Param(value="et") T var1);

    public int update(@Param(value="et") T var1, @Param(value="ew") Wrapper<T> var2);

    default public int update(@Param(value="ew") Wrapper<T> updateWrapper) {
        return this.update(null, updateWrapper);
    }

    public T selectById(Serializable var1);

    public List<T> selectBatchIds(@Param(value="coll") Collection<? extends Serializable> var1);

    public void selectBatchIds(@Param(value="coll") Collection<? extends Serializable> var1, ResultHandler<T> var2);

    default public List<T> selectByMap(Map<String, Object> columnMap) {
        QueryWrapper qw = Wrappers.query();
        return this.selectList((Wrapper)qw.allEq(columnMap));
    }

    default public void selectByMap(Map<String, Object> columnMap, ResultHandler<T> resultHandler) {
        this.selectList((Wrapper)Wrappers.query().allEq(columnMap), resultHandler);
    }

    default public T selectOne(@Param(value="ew") Wrapper<T> queryWrapper) {
        return this.selectOne(queryWrapper, true);
    }

    default public T selectOne(@Param(value="ew") Wrapper<T> queryWrapper, boolean throwEx) {
        ArrayList list = new ArrayList();
        this.selectList(queryWrapper, resultContext -> {
            Object resultObject = resultContext.getResultObject();
            list.add(resultObject);
            if (!throwEx || resultContext.getResultCount() > 1) {
                resultContext.stop();
            }
        });
        int size = list.size();
        if (size == 1) {
            return (T)list.get(0);
        }
        if (size > 1) {
            if (throwEx) {
                throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found multiple records");
            }
            return (T)list.get(0);
        }
        return null;
    }

    default public boolean exists(Wrapper<T> queryWrapper) {
        Long count = this.selectCount(queryWrapper);
        return null != count && count > 0L;
    }

    public Long selectCount(@Param(value="ew") Wrapper<T> var1);

    public List<T> selectList(@Param(value="ew") Wrapper<T> var1);

    public void selectList(@Param(value="ew") Wrapper<T> var1, ResultHandler<T> var2);

    public List<T> selectList(IPage<T> var1, @Param(value="ew") Wrapper<T> var2);

    public void selectList(IPage<T> var1, @Param(value="ew") Wrapper<T> var2, ResultHandler<T> var3);

    public List<Map<String, Object>> selectMaps(@Param(value="ew") Wrapper<T> var1);

    public void selectMaps(@Param(value="ew") Wrapper<T> var1, ResultHandler<Map<String, Object>> var2);

    public List<Map<String, Object>> selectMaps(IPage<? extends Map<String, Object>> var1, @Param(value="ew") Wrapper<T> var2);

    public void selectMaps(IPage<? extends Map<String, Object>> var1, @Param(value="ew") Wrapper<T> var2, ResultHandler<Map<String, Object>> var3);

    public <E> List<E> selectObjs(@Param(value="ew") Wrapper<T> var1);

    public <E> void selectObjs(@Param(value="ew") Wrapper<T> var1, ResultHandler<E> var2);

    default public <P extends IPage<T>> P selectPage(P page, @Param(value="ew") Wrapper<T> queryWrapper) {
        List<T> list = this.selectList(page, queryWrapper);
        page.setRecords(list);
        return page;
    }

    default public <P extends IPage<Map<String, Object>>> P selectMapsPage(P page, @Param(value="ew") Wrapper<T> queryWrapper) {
        List<Map<String, Object>> list = this.selectMaps(page, queryWrapper);
        page.setRecords(list);
        return page;
    }
}

