/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.assist;

import com.baomidou.mybatisplus.core.assist.ISqlRunner;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ibatis.parsing.GenericTokenParser;

public abstract class AbstractSqlRunner
implements ISqlRunner {
    private static final GenericTokenParser DEFAULT_TOKEN_PARSER = new GenericTokenParser("{", "}", content -> "#{" + content + "}");
    private static final Pattern INDEX_PATTERN = Pattern.compile("^\\d+$");
    private static final String ARG0 = "arg0";

    protected String parse(String sql, Object ... args) {
        if (args != null && args.length == 1) {
            Object arg = args[0];
            Class<?> clazz = arg.getClass();
            return new GenericTokenParser("{", "}", content -> {
                if (INDEX_PATTERN.matcher(content).matches()) {
                    if (arg instanceof Collection || clazz.isArray()) {
                        return "#{arg0[" + content + "]" + "}";
                    }
                    return "#{" + content + "}";
                }
                return "#{arg0." + content + "}";
            }).parse(sql);
        }
        return DEFAULT_TOKEN_PARSER.parse(sql);
    }

    protected Map<String, Object> getParams(Object ... args) {
        if (args != null && args.length > 0) {
            HashMap<String, Object> params = CollectionUtils.newHashMapWithExpectedSize(args.length);
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (i == 0) {
                    params.put(ARG0, arg);
                }
                params.put(String.valueOf(i), arg);
            }
            return params;
        }
        return new HashMap<String, Object>();
    }

    protected Map<String, Object> sqlMap(String sql, Object ... args) {
        Map<String, Object> sqlMap = this.getParams(args);
        sqlMap.put("sql", this.parse(sql, args));
        return sqlMap;
    }

    protected Map<String, Object> sqlMap(String sql, IPage<?> page, Object ... args) {
        Map<String, Object> sqlMap = this.getParams(args);
        sqlMap.put("page", page);
        sqlMap.put("sql", this.parse(sql, args));
        return sqlMap;
    }
}

