/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.lock;

import com.baomidou.lock.LockInfo;
import com.baomidou.lock.exception.LockException;
import com.baomidou.lock.executor.LockExecutor;
import com.baomidou.lock.spring.boot.autoconfigure.Lock4jProperties;
import com.baomidou.lock.util.LockUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class LockTemplate
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(LockTemplate.class);
    private final Map<Class<? extends LockExecutor>, LockExecutor> executorMap = new LinkedHashMap<Class<? extends LockExecutor>, LockExecutor>();
    private Lock4jProperties properties;
    private List<LockExecutor> executors;
    private LockExecutor primaryExecutor;

    public LockInfo lock(String key) {
        return this.lock(key, 0L, -1L);
    }

    public LockInfo lock(String key, long expire, long acquireTimeout) {
        return this.lock(key, expire, acquireTimeout, null);
    }

    public LockInfo lock(String key, long expire, long acquireTimeout, Class<? extends LockExecutor> executor) {
        acquireTimeout = acquireTimeout < 0L ? this.properties.getAcquireTimeout() : acquireTimeout;
        long retryInterval = this.properties.getRetryInterval();
        LockExecutor lockExecutor = this.obtainExecutor(executor);
        log.debug(String.format("use lock class: %s", lockExecutor.getClass()));
        expire = !lockExecutor.renewal() && expire <= 0L ? this.properties.getExpire() : expire;
        int acquireCount = 0;
        String value = LockUtil.simpleUUID();
        long start = System.currentTimeMillis();
        try {
            do {
                ++acquireCount;
                Object lockInstance = lockExecutor.acquire(key, value, expire, acquireTimeout);
                if (null != lockInstance) {
                    return new LockInfo(key, value, expire, acquireTimeout, acquireCount, lockInstance, lockExecutor);
                }
                TimeUnit.MILLISECONDS.sleep(retryInterval);
            } while (System.currentTimeMillis() - start < acquireTimeout);
        }
        catch (InterruptedException e) {
            log.error("lock error", (Throwable)e);
            throw new LockException();
        }
        return null;
    }

    public boolean releaseLock(LockInfo lockInfo) {
        if (null == lockInfo) {
            return false;
        }
        return lockInfo.getLockExecutor().releaseLock(lockInfo.getLockKey(), lockInfo.getLockValue(), lockInfo.getLockInstance());
    }

    protected LockExecutor obtainExecutor(Class<? extends LockExecutor> clazz) {
        if (null == clazz || clazz == LockExecutor.class) {
            return this.primaryExecutor;
        }
        LockExecutor lockExecutor = this.executorMap.get(clazz);
        Assert.notNull((Object)lockExecutor, (String)String.format("can not get bean type of %s", clazz));
        return lockExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.properties.getAcquireTimeout() >= 0L ? 1 : 0) != 0, (String)"tryTimeout must least 0");
        Assert.isTrue((this.properties.getExpire() >= -1L ? 1 : 0) != 0, (String)"expireTime must lease -1");
        Assert.isTrue((this.properties.getRetryInterval() >= 0L ? 1 : 0) != 0, (String)"retryInterval must more than 0");
        Assert.hasText((String)this.properties.getLockKeyPrefix(), (String)"lock key prefix must be not blank");
        Assert.notEmpty(this.executors, (String)"executors must have at least one");
        for (LockExecutor executor : this.executors) {
            this.executorMap.put(executor.getClass(), executor);
        }
        Class<? extends LockExecutor> primaryExecutor = this.properties.getPrimaryExecutor();
        if (null == primaryExecutor) {
            this.primaryExecutor = this.executors.get(0);
        } else {
            this.primaryExecutor = this.executorMap.get(primaryExecutor);
            Assert.notNull((Object)this.primaryExecutor, (String)"primaryExecutor must be not null");
        }
    }

    public void setProperties(Lock4jProperties properties) {
        this.properties = properties;
    }

    public void setExecutors(List<LockExecutor> executors) {
        this.executors = executors;
    }
}

