/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.service;

import com.baomidou.kisso.SSOCache;
import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.SSOPlugin;
import com.baomidou.kisso.common.Browser;
import com.baomidou.kisso.common.CookieHelper;
import com.baomidou.kisso.common.IpHelper;
import com.baomidou.kisso.common.SSOConstants;
import com.baomidou.kisso.enums.TokenFlag;
import com.baomidou.kisso.exception.KissoException;
import com.baomidou.kisso.security.token.SSOToken;
import com.baomidou.kisso.security.token.Token;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KissoServiceSupport {
    private static final Logger log = LoggerFactory.getLogger(KissoServiceSupport.class);
    protected SSOConfig config;

    public <T extends SSOToken> T attrSSOToken(HttpServletRequest request) {
        return (T)((SSOToken)request.getAttribute("kissoTokenAttr"));
    }

    protected SSOToken cacheSSOToken(HttpServletRequest request, SSOCache cache) {
        if (cache != null) {
            SSOToken cookieSSOToken = this.getSSOTokenFromCookie(request);
            if (cookieSSOToken == null) {
                return null;
            }
            SSOToken cacheSSOToken = cache.get(cookieSSOToken.toCacheKey(), this.config.getCacheExpires());
            if (cacheSSOToken == null) {
                log.debug("cacheSSOToken SSOToken is null.");
                return null;
            }
            if (cacheSSOToken.getFlag() != TokenFlag.CACHE_SHUT) {
                if (cookieSSOToken.getTime() / SSOConstants.JWT_TIMESTAMP_CUT == cacheSSOToken.getTime() / SSOConstants.JWT_TIMESTAMP_CUT) {
                    return cacheSSOToken;
                }
                log.debug("Login time is not consistent or kicked out.");
                request.setAttribute("kissoKickFlag", (Object)"kissoKickUser");
                return null;
            }
        }
        return this.getSSOToken(request, this.config.getCookieName());
    }

    protected SSOToken getSSOToken(HttpServletRequest request, String cookieName) {
        String accessToken = request.getHeader(this.config.getAccessTokenName());
        if (null == accessToken || "".equals(accessToken)) {
            Cookie uid = CookieHelper.findCookieByName(request, cookieName);
            if (null == uid) {
                log.debug("Unauthorized login request, ip=" + IpHelper.getIpAddr(request));
                return null;
            }
            return SSOToken.parser(uid.getValue(), false);
        }
        return SSOToken.parser(accessToken, true);
    }

    protected SSOToken checkIpBrowser(HttpServletRequest request, SSOToken ssoToken) {
        if (null == ssoToken) {
            return null;
        }
        if (this.config.isCookieBrowser() && !Browser.isLegalUserAgent(request, ssoToken.getUserAgent())) {
            log.info("The request browser is inconsistent.");
            return null;
        }
        if (this.config.isCookieCheckIp()) {
            String ip = IpHelper.getIpAddr(request);
            if (ssoToken != null && ip != null && !ip.equals(ssoToken.getIp())) {
                log.info(String.format("ip inconsistent! return SSOToken null, SSOToken userIp:%s, reqIp:%s", ssoToken.getIp(), ip));
                return null;
            }
        }
        return ssoToken;
    }

    public SSOToken getSSOTokenFromCookie(HttpServletRequest request) {
        Object tk = this.attrSSOToken(request);
        if (tk == null) {
            tk = this.getSSOToken(request, this.config.getCookieName());
        }
        return tk;
    }

    protected Cookie generateCookie(HttpServletRequest request, Token token) {
        try {
            Cookie cookie = new Cookie(this.config.getCookieName(), token.getToken());
            cookie.setPath(this.config.getCookiePath());
            cookie.setSecure(this.config.isCookieSecure());
            String domain = this.config.getCookieDomain();
            if (null != domain) {
                cookie.setDomain(domain);
                if ("".equals(domain) || domain.contains("localhost")) {
                    log.warn("if you can't login, please enter normal domain. instead:" + domain);
                }
            }
            int maxAge = this.config.getCookieMaxAge();
            Integer attrMaxAge = (Integer)request.getAttribute("kisso_cookie_maxage");
            if (attrMaxAge != null) {
                maxAge = attrMaxAge;
            }
            if (maxAge >= 0) {
                cookie.setMaxAge(maxAge);
            }
            return cookie;
        }
        catch (Exception e) {
            throw new KissoException("Generate sso cookie exception ", e);
        }
    }

    protected boolean logout(HttpServletRequest request, HttpServletResponse response, SSOCache cache) {
        List<SSOPlugin> pluginList;
        boolean rlt;
        SSOToken tk;
        if (cache != null && !"kissoKickUser".equals(request.getAttribute("kissoKickFlag")) && (tk = this.getSSOTokenFromCookie(request)) != null && !(rlt = cache.delete(tk.toCacheKey()))) {
            cache.delete(tk.toCacheKey());
        }
        if ((pluginList = this.config.getPluginList()) != null) {
            for (SSOPlugin plugin : pluginList) {
                boolean logout = plugin.logout(request, response);
                if (logout) continue;
                plugin.logout(request, response);
            }
        }
        return CookieHelper.clearCookieByName(request, response, this.config.getCookieName(), this.config.getCookieDomain(), this.config.getCookiePath());
    }
}

