/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.security;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.RsaKeyHelper;
import com.baomidou.kisso.exception.KissoException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.core.io.ClassPathResource;

public class JwtHelper {
    private static Key RSA_KEY;
    private static PublicKey RSA_PUBLICKEY;

    public static String getHS512SecretKey() {
        return JwtHelper.getSecretKey(SignatureAlgorithm.HS512);
    }

    public static String getSecretKey(SignatureAlgorithm signatureAlgorithm) {
        SecretKey key = Keys.secretKeyFor((SignatureAlgorithm)signatureAlgorithm);
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static SecretKey getSecretKey(String signKey, SignatureAlgorithm signatureAlgorithm) {
        return new SecretKeySpec(signKey.getBytes(), signatureAlgorithm.getJcaName());
    }

    public static String signCompact(JwtBuilder jwtBuilder) {
        SSOConfig config = SSOConfig.getInstance();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)config.getSignAlgorithm());
        if ("RSA".equals(signatureAlgorithm.getFamilyName())) {
            try {
                if (null == RSA_KEY) {
                    ClassPathResource resource = new ClassPathResource(config.getRsaJksStore());
                    KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keystore.load(resource.getInputStream(), config.getRsaStorepass().toCharArray());
                    RSA_KEY = keystore.getKey(config.getRsaAlias(), config.getRsaKeypass().toCharArray());
                }
                return jwtBuilder.signWith(RSA_KEY, signatureAlgorithm).compact();
            }
            catch (Exception e) {
                throw new KissoException("signCompact error.", e);
            }
        }
        SecretKey secretKey = JwtHelper.getSecretKey(config.getSignKey(), signatureAlgorithm);
        return jwtBuilder.signWith((Key)secretKey, signatureAlgorithm).compact();
    }

    public static JwtParser verifyParser() {
        try {
            SSOConfig config = SSOConfig.getInstance();
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)config.getSignAlgorithm());
            if ("RSA".equals(signatureAlgorithm.getFamilyName())) {
                if (null == RSA_PUBLICKEY) {
                    ClassPathResource resource = new ClassPathResource(config.getRsaCertStore());
                    RSA_PUBLICKEY = RsaKeyHelper.getRsaPublicKey(resource.getInputStream());
                }
                return Jwts.parserBuilder().setSigningKey((Key)RSA_PUBLICKEY).build();
            }
            SecretKey secretKey = JwtHelper.getSecretKey(config.getSignKey(), signatureAlgorithm);
            return Jwts.parserBuilder().setSigningKey((Key)secretKey).build();
        }
        catch (Exception e) {
            throw new KissoException("verifyParser error.", e);
        }
    }
}

