/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.signature;

import com.baomidou.kisso.common.signature.IVerify;
import com.baomidou.kisso.common.signature.ShaAlgorithm;
import com.baomidou.kisso.common.signature.Signature;
import com.baomidou.kisso.common.signature.VerifyAsymmetric;
import com.baomidou.kisso.common.signature.VerifySymmetric;
import com.baomidou.kisso.exception.UnsupportedAlgorithmException;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;

public class Verifier {
    private final IVerify verify;
    private final Signature signature;
    private final ShaAlgorithm shaAlgorithm;
    private final Provider provider;

    public Verifier(Key key, Signature signature) {
        this(key, signature, null);
    }

    public Verifier(Key key, Signature signature, Provider provider) {
        Objects.requireNonNull(key, "Key cannot be null");
        this.signature = Objects.requireNonNull(signature, "Signature cannot be null");
        this.shaAlgorithm = signature.getShaAlgorithm();
        this.provider = provider;
        if (java.security.Signature.class.equals((Object)this.shaAlgorithm.getType())) {
            this.verify = new VerifyAsymmetric((PublicKey)PublicKey.class.cast(key));
        } else if (Mac.class.equals((Object)this.shaAlgorithm.getType())) {
            this.verify = new VerifySymmetric(key);
        } else {
            throw new UnsupportedAlgorithmException(String.format("Unknown Algorithm type %s %s", this.shaAlgorithm.getPortableName(), this.shaAlgorithm.getType().getName()));
        }
        try {
            this.verify.verify(provider, this.shaAlgorithm, "validation".getBytes(), signature.getSignature());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't initialise the Signer using the provided algorithm and key", e);
        }
    }

    public boolean verify(String method, String uri, Map<String, String> headers) throws IOException, NoSuchAlgorithmException, SignatureException {
        String signingString = this.createSigningString(method, uri, headers);
        return this.verify.verify(this.provider, this.shaAlgorithm, signingString.getBytes(), this.signature.getSignature());
    }

    public String createSigningString(String method, String uri, Map<String, String> headers) throws IOException {
        return Signature.createSigningString(this.signature.getHeaders(), method, uri, headers);
    }
}

