/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.signature;

import com.baomidou.kisso.exception.UnsupportedAlgorithmException;
import java.security.Signature;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;

public enum ShaAlgorithm {
    HMAC_SHA1("HmacSHA1", "hmac-sha1", Mac.class),
    HMAC_SHA224("HmacSHA224", "hmac-sha224", Mac.class),
    HMAC_SHA256("HmacSHA256", "hmac-sha256", Mac.class),
    HMAC_SHA384("HmacSHA384", "hmac-sha384", Mac.class),
    HMAC_SHA512("HmacSHA512", "hmac-sha512", Mac.class),
    RSA_SHA1("SHA1withRSA", "rsa-sha1", Signature.class),
    RSA_SHA256("SHA256withRSA", "rsa-sha256", Signature.class),
    RSA_SHA384("SHA384withRSA", "rsa-sha384", Signature.class),
    RSA_SHA512("SHA512withRSA", "rsa-sha512", Signature.class),
    DSA_SHA1("SHA1withDSA", "dsa-sha1", Signature.class),
    DSA_SHA224("SHA224withDSA", "dsa-sha224", Signature.class),
    DSA_SHA256("SHA256withDSA", "dsa-sha256", Signature.class),
    ECDSA_SHA1("SHA1withECDSA", "ecdsa-sha1", Signature.class),
    ECDSA_SHA256("SHA256withECDSA", "ecdsa-sha256", Signature.class),
    ECDSA_SHA384("SHA384withECDSA", "ecdsa-sha384", Signature.class),
    ECDSA_SHA512("SHA512withECDSA", "ecdsa-sha512", Signature.class);

    private static final Map<String, ShaAlgorithm> aliases;
    private final String portableName;
    private final String jmvName;
    private final Class type;

    private ShaAlgorithm(String jmvName, String portableName, Class type) {
        this.portableName = portableName;
        this.jmvName = jmvName;
        this.type = type;
    }

    public String getPortableName() {
        return this.portableName;
    }

    public String getJmvName() {
        return this.jmvName;
    }

    public Class getType() {
        return this.type;
    }

    public static String toPortableName(String name) {
        return ShaAlgorithm.get(name).getPortableName();
    }

    public static String toJvmName(String name) {
        return ShaAlgorithm.get(name).getJmvName();
    }

    public static ShaAlgorithm get(String name) {
        ShaAlgorithm algorithm = aliases.get(ShaAlgorithm.normalize(name));
        if (algorithm != null) {
            return algorithm;
        }
        throw new UnsupportedAlgorithmException(name);
    }

    private static String normalize(String algorithm) {
        return algorithm.replaceAll("[^A-Za-z0-9]+", "").toLowerCase();
    }

    public String toString() {
        return this.getPortableName();
    }

    static {
        aliases = new HashMap<String, ShaAlgorithm>();
        for (ShaAlgorithm algorithm : ShaAlgorithm.values()) {
            aliases.put(ShaAlgorithm.normalize(algorithm.getJmvName()), algorithm);
            aliases.put(ShaAlgorithm.normalize(algorithm.getPortableName()), algorithm);
        }
    }
}

