/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.encrypt.Byte2Hex;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5 {
    private static final Logger log = LoggerFactory.getLogger(MD5.class);
    public static final String ALGORITHM = "MD5";

    public static String toMD5(String plainText) {
        StringBuffer rlt = new StringBuffer();
        try {
            rlt.append(MD5.md5String(plainText.getBytes(SSOConfig.getSSOEncoding())));
        }
        catch (UnsupportedEncodingException e) {
            log.error(" CipherHelper toMD5 exception.");
            e.printStackTrace();
        }
        return rlt.toString();
    }

    public static String getSignature(HashMap<String, String> params, String secret) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(params);
        Set entrys = sortedParams.entrySet();
        StringBuilder basestring = new StringBuilder();
        for (Map.Entry param : entrys) {
            basestring.append((String)param.getKey()).append("=").append((String)param.getValue());
        }
        return MD5.getSignature(basestring.toString(), secret);
    }

    public static String getSignature(String sigstr, String secret) {
        StringBuilder text = new StringBuilder(sigstr);
        text.append("#");
        text.append(MD5.toMD5(secret));
        return MD5.toMD5(text.toString());
    }

    public static byte[] md5Raw(byte[] data) {
        byte[] md5buf = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance(ALGORITHM);
            md5buf = md5.digest(data);
        }
        catch (Exception e) {
            md5buf = null;
            log.error("md5Raw error.", (Throwable)e);
        }
        return md5buf;
    }

    public static String md5String(byte[] data) {
        String md5Str = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance(ALGORITHM);
            byte[] buf = md5.digest(data);
            for (int i = 0; i < buf.length; ++i) {
                md5Str = md5Str + Byte2Hex.byte2Hex(buf[i]);
            }
        }
        catch (Exception e) {
            md5Str = null;
            log.error("md5String error.", (Throwable)e);
        }
        return md5Str;
    }
}

