/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

public enum Algorithm {
    DES("DES", "DES encrypt"),
    AES("AES", "AES encrypt"),
    BLOWFISH("BLOWFISH", "Blowfish encrypt"),
    HMACSHA1("HmacSHA1", "HmacSHA1 encrypt"),
    HMACSHA256("HmacSHA256", "HmacSHA256 encrypt"),
    RC2("RC2", "RC2 encrypt"),
    RC4("RC4", "RC4 encrypt");

    private final String key;
    private final String desc;

    private Algorithm(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Algorithm convert(String encryptAlgorithm) {
        Algorithm algorithm = RC4;
        if (null != encryptAlgorithm) {
            Algorithm[] algs;
            for (Algorithm alg : algs = Algorithm.values()) {
                if (!alg.getKey().equals(encryptAlgorithm)) continue;
                algorithm = alg;
                break;
            }
        }
        return algorithm;
    }
}

