/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.widgets

import android.os.CountDownTimer

/**
 * A composite of Hideable Widgets
 */
class WidgetHidingCoordinator : HideableWidget {

    override var hidingTimer: CountDownTimer? = null

    private var hideableWidgets = mutableListOf<HideableWidget>()

    /**
     * Add the widgets you want to behave at the same time
     * @property hideAfterMillis millis to wait before hiding the widgets added
     * @param widgets the widgets that should be bound together
     */
    fun addWidgets(hideAfterMillis: Long, vararg widgets: HideableWidget) {
        hideableWidgets.forEach { it.disableAutoHide() }
        hideableWidgets.clear()
        autoHide(hideAfterMillis)
        widgets.forEach {
            it.hidingTimer = hidingTimer
        }
        hideableWidgets.addAll(widgets)
    }

    /**
     * Remove the specified widget from hiding logic.
     * @param widget the widget to be removed.
     */
    fun removeWidget(widget: HideableWidget) {
        widget.disableAutoHide()
        hideableWidgets.remove(widget)
    }

    override fun disableAutoHide() {
        hideableWidgets.forEach { it.disableAutoHide() }
    }

    override fun onHidingTimerFinished() {
        hideableWidgets.forEach { it.onHidingTimerFinished() }
    }
}