/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.whiteboard.layout

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.ImageView
import android.widget.ProgressBar
import androidx.cardview.widget.CardView
import com.airbnb.paris.annotations.Styleable
import com.airbnb.paris.annotations.StyleableChild
import com.bandyer.sdk_design.R
import com.bandyer.sdk_design.R2
import com.bandyer.sdk_design.extensions.StyleCompat
import com.bandyer.sdk_design.extensions.dp2px
import com.bandyer.sdk_design.textviews.BandyerTextView
import kotlinx.android.synthetic.main.bandyer_progress_view_layout.view.*

/**
 *
 * @property style BandyerWhiteboardUploadProgressLayoutState
 * @property progressTitle BandyerTextView?
 * @property progressSubtitle BandyerTextView?
 * @property progressText BandyerTextView?
 * @property progressBar ProgressBar?
 * @property errorImage ImageView?
 * @constructor
 */
@Styleable("BandyerSDKDesign_Whiteboard_UploadProgress_Layout")
class BandyerWhiteboardUploadProgressLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : CardView(context, attrs, defStyleAttr) {

    /**
     * Enum class representing the two possible status and changing the style accordingly
     * @property styleRes Int style to be used
     * @constructor
     */
    enum class BandyerWhiteboardUploadProgressLayoutState(var styleRes: Int) {
        /**
         * Uploading status
         */
        UPLOADING(R.style.BandyerSDKDesign_Whiteboard_UploadProgress_Layout_Uploading),

        /**
         * Error status
         */
        ERROR(R.style.BandyerSDKDesign_Whiteboard_UploadProgress_Layout_UploadingError)
    }

    var style = BandyerWhiteboardUploadProgressLayoutState.UPLOADING
        set(value) {
            field = value
            applyCurrentStyle()
        }

    @StyleableChild(R2.styleable.BandyerSDKDesign_Whiteboard_UploadProgress_Layout_bandyer_progressTitleStyle)
    var progressTitle: BandyerTextView? = null
        private set

    @StyleableChild(R2.styleable.BandyerSDKDesign_Whiteboard_UploadProgress_Layout_bandyer_progressSubtitleStyle)
    var progressSubtitle: BandyerTextView? = null
        private set

    @StyleableChild(R2.styleable.BandyerSDKDesign_Whiteboard_UploadProgress_Layout_bandyer_progressPercentageTextStyle)
    var progressText: BandyerTextView? = null
        private set

    @StyleableChild(R2.styleable.BandyerSDKDesign_Whiteboard_UploadProgress_Layout_bandyer_progressPercentageBarStyle)
    var progressBar: ProgressBar? = null
        private set

    @StyleableChild(R2.styleable.BandyerSDKDesign_Whiteboard_UploadProgress_Layout_bandyer_errorImageStyle)
    var errorImage: ImageView? = null
        private set

    init {
        LayoutInflater.from(context).inflate(R.layout.bandyer_progress_view_layout, this)
        val space16 = context.dp2px(16f)
        val space3 = context.dp2px(3f)

        setPadding(space16, space16, space16, space16)
        cardElevation = space3.toFloat()
        useCompatPadding = true
        radius = context.dp2px(3f).toFloat()

        progressTitle = whiteboard_progress_title
        progressSubtitle = whiteboard_progress_subtitle
        progressText = whiteboard_progress_progressText
        progressBar = whiteboard_progress_progressBar
        errorImage = whiteboard_progress_error_image

        applyCurrentStyle()
    }

    private fun applyCurrentStyle(attrs: AttributeSet? = null) {
        StyleCompat.styleBuilder(this)
                .add(attrs)
                .add(style.styleRes)
                .apply()
    }


}
