/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.utils.systemviews.implementation

import com.bandyer.sdk_design.utils.systemviews.SystemViewLayoutObserver

/**
 * @suppress
 */
internal interface SystemViewControlsAwareInstance {

    /**
     * Add an observer to the system controls changes
     * @param observer SystemViewLayoutObserver
     * @param removeOnInsetChanged remove the observer as soon a Inset has been changed
     * @return SystemViewControlsAware
     */
    fun addObserver(observer: SystemViewLayoutObserver, removeOnInsetChanged: Boolean = false): SystemViewControlsAware

    /**
     * Remove the observer from the SystemViewControlsAware
     *
     * @param observer SystemViewLayoutObserver
     * @return SystemViewControlsAware
     */
    fun removeObserver(observer: SystemViewLayoutObserver): SystemViewControlsAware

    /**
     * Request to calculate the offsets
     */
    fun getOffsets()
}