/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.utils.systemviews

import androidx.annotation.Px

/**
 * System views observer which notifies the space a system view is taking off the screen
 */
interface SystemViewLayoutObserver {

    /**
     * Called when a system view is taking space from the top
     *
     * @param pixels height of the system view in pixels
     */
    fun onTopInsetChanged(@Px pixels: Int)

    /**
     * Called when a system view is taking space from the bottom
     *
     * @param pixels height of the system view in pixels
     */
    fun onBottomInsetChanged(@Px pixels: Int)

    /**
     * Called when a system view is taking space from the right
     *
     * @param pixels width of the system view in pixels
     */
    fun onRightInsetChanged(@Px pixels: Int)

    /**
     * Called when a system view is taking space from the left
     *
     * @param pixels width of the system view in pixels
     */
    fun onLeftInsetChanged(@Px pixels: Int)

}