/*
 * Copyright (C) 2018 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.textviews

import android.content.Context
import android.util.AttributeSet

/**
 * This class represents a text title used in Bandyer SDK to display call info.
 * This textView can be styled overriding style 'BandyerSDKDesign.TextView.Title'.
 */
class BandyerTextViewTitle @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0)
    : BandyerTextView(context, attrs, defStyleAttr) {

    /**
     * @suppress
     */
    override fun builderStyle(): BandyerTextViewStyleApplier.StyleBuilder {
        return super.builderStyle().addTitle()
    }
}