package com.bandyer.sdk_design.textviews

import android.content.Context
import android.util.AttributeSet
import com.bandyer.sdk_design.utils.ToggleableVisibilityInterface
import com.bandyer.sdk_design.utils.VisibilityToggle

/**
 * Hideable Bandyer text view
 * @property visibilityToggle VisibilityToggle
 * @constructor
 */
class BandyerHideableTextView @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) :
        BandyerTextView(context, attrs, defStyleAttr), ToggleableVisibilityInterface {

    private val visibilityToggle = VisibilityToggle(this)

    override fun toggleVisibility(show: Boolean, animationEndCallback: (shown: Boolean) -> Unit) {
        visibilityToggle.toggleVisibility(show, animationEndCallback)
    }

    override fun cancelTimer() {
        visibilityToggle.cancelTimer()
    }

    /**
     * @suppress
     */
    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        cancelTimer()
    }
}