/*
 * Copyright (C) 2019 Bandyer S.r.l. All Rights Reserved.
 * See LICENSE.txt for licensing information
 */

package com.bandyer.sdk_design.layout

import android.content.Context
import android.graphics.Canvas
import android.util.AttributeSet
import android.widget.FrameLayout
import com.bandyer.android_common.RoundedView
import com.bandyer.sdk_design.R

/**
 * A frame layout that can round its corners using "round" and "corner_radius" roundable properties.
 * 
 * @constructor
 */
open class RoundableFrameLayout @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : FrameLayout(context, attrs, defStyleAttr), RoundedView {

    init {
        if (attrs != null) {
            val typedArray = context.theme.obtainStyledAttributes(attrs, R.styleable.RoundableStyle, defStyleAttr, 0)
            try {
                if (typedArray.getBoolean(R.styleable.RoundableStyle_bandyer_round, false))
                    round<RoundableFrameLayout>(true)
                else
                    typedArray.getDimensionPixelSize(R.styleable.RoundableStyle_bandyer_corner_radius, 0).takeIf { it > 0 }?.let {
                        setCornerRadius<RoundableFrameLayout>(it.toFloat())
                    }
            } finally {
                typedArray.recycle()
            }
        }
    }

    /**
     * @suppress
     */
    override fun onDraw(canvas: Canvas?) {
        super.onDraw(canvas)
        setRoundClip(canvas)
    }
}