package com.bandyer.sdk_design.imageviews

import android.content.Context
import androidx.appcompat.widget.AppCompatImageButton
import android.util.AttributeSet

/**
 * Bandyer image button without focus capabilities.
 * @constructor
 */
class BandyerNonFocusableAppCompatImageButton @JvmOverloads constructor(
        context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : AppCompatImageButton(context, attrs, defStyleAttr) {

    init {
        isFocusable = false
    }

    /**
     * Overrides setFocusable and always set it to false.
     * @param focusable Boolean
     */
    override fun setFocusable(focusable: Boolean) {
        super.setFocusable(false)
    }

}